package com.cku.controller;


import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.service.EventRelatedServiceImpl;
/**
 * 
 * <p>Title:EventRelatedController </p>
 * <p>Description: 赛事相关接口</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年3月15日 下午3:41:25
 */
@Controller
@RequestMapping(value="event")
public class EventRelatedController {
	private static final Logger logger = Logger.getLogger(EventRelatedController.class);
	
	@Autowired
	public EventRelatedServiceImpl eventRelatedService;
	
	/**
	 * 
	 * @Description：根据页码、展示条数获取主赛事列表
	 * @author: zhuoHeng
	 * @version: 2016年3月15日 下午3:47:11
	 */
	@RequestMapping(value = "/eventList")
	public void eventList (HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "page", required = false)Integer page,
			@RequestParam(value = "limit", required = false)Integer limit)throws IOException {
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getEventList(page,limit);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		
	}
	
	/**
	 * 
	 * @Description：根据主赛事场地查询子赛事列表 
	 * @author: zhuoHeng
	 * @version: 2016年3月16日 上午10:52:25
	 */
	@RequestMapping(value = "/specificEvent")
	public void getSpecificEvent(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "showLocation", required = false)String showLocation,
			@RequestParam(value = "ids", required = false)String ids){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getSpecificEvent(showLocation,ids);
			response.getWriter().write(StringEscapeUtils.unescapeHtml(str));
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		
	}
	/**
	 * 
	 * @Description：根据赛事id获取该赛事具体项目
	 * @author: zhuoHeng
	 * @version: 2016年3月16日 上午11:39:08
	 */
	@RequestMapping(value = "/getEventProject")
	public void getEventProject(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "eventId", required = false)Integer eventId){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getEventProject(eventId);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		
	}
	/**
	 * 
	 * @Description：根据赛事裁判id获取裁判信息
	 * @author: zhuoHeng
	 * @version: 2016年3月16日 下午1:10:50
	 */
	@RequestMapping(value = "/getRefereeMessage")
	public void getRefereeMessage(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "ids", required = false)String  ids){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getRefereeMessage(ids);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：获取赛事费用详情
	 * @author: zhuoHeng
	 * @version: 2016年3月16日 下午3:42:33
	 */
	@RequestMapping(value = "/getMatchCost")
	public void getMatchCost(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "eventId", required = false)Integer eventId){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getMatchCost(eventId);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：根据赛主事场地查询主赛事信息
	 * @author: zhuoHeng
	 * @version: 2016年3月19日 上午10:21:34
	 */
	@RequestMapping(value = "/getTrunkEventInfo")
	public void getTrunkEventInfo(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "showLocation", required = false)String showLocation){
		try {
			//showLocation =new String(showLocation.getBytes("ISO-8859-1"),"UTF-8");//字符转换
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getTrunkEventInfo(showLocation);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：根据主办方获取主办方详细信息
	 * @author: zhuoHeng
	 * @version: 2016年3月22日 下午6:11:57
	 */
	@RequestMapping(value = "/getSponsorInfo")
	public void getSponsorInfo(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "organizer", required = false)String organizer){
		try {
			//organizer =new String(organizer.getBytes("ISO-8859-1"),"UTF-8");//字符转换
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = eventRelatedService.getSponsorInfo(organizer);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
}
