package com.cab.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabMyLoveDogMapper;
import com.cab.model.CabMyLoveDog;
import com.cku.core.ExecResultModel;
import com.cku.upyun.ImageFtp;
import com.cku.util.PageBean;

@Service("cabMyLoveDogService")
public class CabMyLoveDogServiceImpl {

	@Autowired
	public CabMyLoveDogMapper cabMyLoveDogMapper;
	
	@Autowired 
	public UtilServiceImpl utilService;
	/**
	 * 
	 * @Description：根据当前登录人获取我的爱宠列表
	 * @author: zhuoHeng
	 * @version: 2016年4月9日 上午11:47:36
	 */
	public String getMyLoveDog(String userId,PageBean pb) {
		ExecResultModel<CabMyLoveDog> resultModel = new ExecResultModel<CabMyLoveDog>();
		List<CabMyLoveDog> dogList = cabMyLoveDogMapper.getMyLoveDog(userId,pb.get_start(),pb.get_limit());
		long count=cabMyLoveDogMapper.getMyLoveDogCount(userId);
		resultModel.setItems(dogList);
		resultModel.setRc(0);
		resultModel.setMsg("");
		resultModel.setTotal(count);
		return resultModel.getToJson();
	}
	/**
	 * 根据当前登录删除我的爱宠信息
	 * 
	 * @param username
	 * @return
	 */
	public String deleteMyLoveDog(Integer id,String userId) {
		ExecResultModel<CabMyLoveDog> resultModel = new ExecResultModel<CabMyLoveDog>();
		CabMyLoveDog record = new CabMyLoveDog();
		record.setId(id);
		record.setUserId(userId);
		record.setDeleteflag(1);
		int i = cabMyLoveDogMapper.updateByPrimaryKeySelective(record);
		if (i > 0) {
			resultModel.setRc(0);
			resultModel.setMsg("删除成功！");
		} else {
			resultModel.setRc(-1);
			resultModel.setMsg("删除失败！");
		}
		return resultModel.getToJson();
	}

	/**
	 * 根据当前登录新增宠物信息
	 * @param dogType 
	 * @param avatar 
	 * 
	 * @return
	 * @throws ParseException
	 */
	public void insertMyLoveDog(String userId, String dogName, String pedigreeNum, String sex, String weight,
			String dogBirthday, String getHomeDate, String dogType, String avatar,String typeName) throws ParseException {	
		SimpleDateFormat df=new SimpleDateFormat("yyyy-MM-dd");
		CabMyLoveDog cabMyLoveDog = new CabMyLoveDog();
		cabMyLoveDog.setUserId(userId);
		cabMyLoveDog.setDogName(dogName);
		cabMyLoveDog.setPedigreeNum(pedigreeNum);
		cabMyLoveDog.setSex(Integer.valueOf(sex));
		if(!"".equals(weight)&&weight!=null){
			cabMyLoveDog.setWeight(Double.parseDouble(weight));
		}
		if(!"".equals(dogBirthday)&&dogBirthday!=null){
			cabMyLoveDog.setDogBirthday(df.parse(dogBirthday));
		}
		if(!"".equals(getHomeDate)&&getHomeDate!=null){
			cabMyLoveDog.setGetHomeDate(df.parse(getHomeDate));
		}
		cabMyLoveDog.setDogType(dogType);
		cabMyLoveDog.setAvatar(avatar);
		cabMyLoveDog.setCreateTime(new Date());
		cabMyLoveDog.setUpdateTime(new Date());
		cabMyLoveDog.setDeleteflag(0);
		cabMyLoveDog.setTypeName(typeName);
		cabMyLoveDogMapper.insertSelective(cabMyLoveDog);
		utilService.addPoints(userId,6);
	}
	/**
	 * 根据当前登录修改宠物信息
	 * @param dogType 
	 * @Author chaixueteng
	 * @2016年4月26日上午8:45:58
	 */
	public void updateMyLoveDog(String id, String userId, String dogName, String pedigreeNum,
			String sex, String weight, String dogBirthday, String getHomeDate,
			String dogType, String resultOra,String typeName) throws ParseException {
		SimpleDateFormat df=new SimpleDateFormat("yyyy-MM-dd");
		CabMyLoveDog cabMyLoveDog = cabMyLoveDogMapper.selectByPrimaryKey(Integer.valueOf(id));
		String avatar = cabMyLoveDog.getAvatar();
		cabMyLoveDog.setId(Integer.valueOf(id));
		cabMyLoveDog.setUserId(userId);
		cabMyLoveDog.setDogName(dogName);
		cabMyLoveDog.setPedigreeNum(pedigreeNum);
		cabMyLoveDog.setSex(Integer.valueOf(sex));
		if(!"".equals(weight)&&weight!=null){
			cabMyLoveDog.setWeight(Double.parseDouble(weight));
		}
		if(!"".equals(dogBirthday)&&dogBirthday!=null){
			cabMyLoveDog.setDogBirthday(df.parse(dogBirthday));
		}
		if(!"".equals(getHomeDate)&&getHomeDate!=null){
			cabMyLoveDog.setGetHomeDate(df.parse(getHomeDate));
		}
		cabMyLoveDog.setDogType(dogType);
		if(!"".equals(resultOra)){
			cabMyLoveDog.setAvatar(resultOra);
		}
		cabMyLoveDog.setUpdateTime(new Date());
		cabMyLoveDog.setTypeName(typeName);
		int i = cabMyLoveDogMapper.updateByPrimaryKeySelective(cabMyLoveDog);
		if(i>0 && avatar!=null && !"".equals(avatar) && 
				avatar.length()>ImageFtp.UPYUNWEBURL.length() && 
				avatar.startsWith(ImageFtp.UPYUNWEBURL)){
			ImageFtp.deleteFile(avatar.replace(ImageFtp.UPYUNWEBURL, ""));
		}
	}

}
