package com.cku.controller;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.service.CkuMatchSignServiceImpl;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="ckuMatchSign")
public class CkuMatchSignController {
	private static final Logger logger = Logger.getLogger(CkuMatchSignController.class);
	@Autowired
	public CkuMatchSignServiceImpl ckuMatchSignService;
	/**
	 * 检测登陆用户是否有未完成订单和是否是新会员
	 * @param response
	 * @param request
	 */
	@RequestMapping(value="/checkSignUnfinished")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void checkSignUnfinished(HttpServletResponse response,HttpServletRequest request)throws IOException {
		RESTResponse result = null;
		try {
			String userId = UserService.verifyThirdUserId(request);
			Map<String,String> map = ckuMatchSignService.checkSignUnfinished(userId);
			result=new RESTResponse("items",map);
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	
	
	//得到所有接口
	@RequestMapping(value="/addSign")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void addSign(@RequestParam(value = "dogId", required = false)String dogId,
			@RequestParam(value = "trainId", required = false)String trainId,
			@RequestParam(value = "matchId", required = false)Long matchId,
			@RequestParam(value = "projectId", required = false)Long projectId,
			HttpServletResponse response,HttpServletRequest request) {
		try {
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String userNo = (String) request.getSession().getAttribute("userNo");
			String result = ckuMatchSignService.addSign(userNo,dogId,trainId,matchId,projectId);
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
}
