package com.cab.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cab.dao.ContentCommentMapper;
import com.cab.dao.ContentFollowMapper;
import com.cab.dao.ContentMapper;
import com.cab.dao.PointsDetailMapper;
import com.cab.dao.SqlSessionMapper;
import com.cab.model.ContentComment;
import com.cab.model.ContentFollow;
import com.cku.core.PageBeanResult;
import com.cku.util.ArrayUtils;
import com.cku.util.PageBean;

@Service("contentCommentService")
public class ContentCommentServiceImpl {
	@Autowired
	private PointsDetailMapper pointsDetailMapper;
	
	@Autowired
	public ContentCommentMapper contentCommentMapper;

	@Autowired
	public ContentMapper contentMapper;

	@Autowired
	public ContentFollowMapper contentFollowMapper;
	
	@Autowired
	public SqlSessionMapper sqlSessionMapper;
	
	@Autowired
	public UtilServiceImpl utilService;
	
	
	public List<ContentComment> selectByContentId(Long contentId,PageBean pb) {
		List<ContentComment> result = contentCommentMapper.selectByContentId(contentId,pb.get_start(),pb.get_limit());
		
		ArrayList<Long> commentIdList = new ArrayList<Long>();
		for (ContentComment cc : result)
		{
			commentIdList.add(cc.getId());
			List<ContentFollow> contentFollowList=contentFollowMapper.selectByCommentId(cc.getId());
			cc.setFollowList(contentFollowList);
		}
		
		sqlSessionMapper.setGroupContentLength();
		List<String> followStrList = new ArrayList<String>();
		if(commentIdList.size()!=0){
			followStrList = contentFollowMapper.selectIdListByCommentIdList(commentIdList);
		}
		ArrayList<Long> followIdList = new ArrayList<Long>();
		for (String s : followStrList)
		{
			Long[] val = ArrayUtils.splitLong(s, ",", new Long[0]);
			for (int i = 0; i < val.length && i < 3; ++i)
			{
				followIdList.add(val[i]);
			}
		}
		
		List<ContentFollow> followList = new ArrayList<ContentFollow>();
		if(followIdList.size()!=0){
			followList = contentFollowMapper.selectList(followIdList);		
		}
		for (ContentFollow cf : followList)
		{
			for (ContentComment cc : result)
			{
				if (cf.getCommentId() == cc.getId())
				{
					List<ContentFollow> ls = cc.getFollowList();
					ls.add(cf);
					break;
				}
			}
		}
		
		return result;
	}
	@Transactional
	public long addComment(Long contentId, String userId, String content)
	{
		ContentComment cc = new ContentComment();
		cc.setContent(content);
		cc.setUserId(userId);
		cc.setContentId(contentId);
		cc.setCreateTime(new Date());
		cc.setLastUpdated(cc.getCreateTime());
		contentCommentMapper.insertSelective(cc);
		
		//评论积分添加
		utilService.addPoints(userId, 2);
		
		
		long result = cc.getId();
		
		contentMapper.increaseCommentCount(contentId);
		
		return result;
	}
	@Transactional
	public long addCommentFollow(Long commentId, String userId, String toId, String content) {
		ContentFollow cf = new ContentFollow();
		
		cf.setCommentId(commentId);
		cf.setFromId(userId);
		cf.setToId(toId);
		cf.setContent(content);
		cf.setFollowTime(new Date());
		
		contentFollowMapper.insertSelective(cf);
		long result = cf.getId();
		
	    contentCommentMapper.increaseFollowCount(commentId);
		
		return result;
	}

	public PageBeanResult<ContentFollow> getContentFollowList(Long commentId, PageBean pb) {
		PageBeanResult<ContentFollow> pbr = new PageBeanResult<ContentFollow>();
		List<ContentFollow> followList = contentFollowMapper.selectByCommentId(commentId);
		pbr.list = followList;
		pbr.totalCount = Long.MAX_VALUE;
		if(pb.getNeedCount()){
			pbr.totalCount = contentFollowMapper.selectByCommentIdCount(commentId);
		}
		return pbr;
	}

	public Long getCount(Long contentId) {
		return this.contentCommentMapper.getCount(contentId);
	}
}
