package com.cab.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.model.MyMessageCount;
import com.cab.service.MyMessageCountServiceImpl;
import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;
import com.sys.model.MultiUserProfile;

/**
 *user chaixueteng
 *2016年5月3日
 */
@Controller
@RequestMapping("messageCount")
public class CabMessageCountController {
	@Autowired
	public MyMessageCountServiceImpl myMessageCountServiceImpl;
	
	
	/**
	 * 得到个人中心的消息数
	 * @Author chaixueteng
	 * @2016年5月4日上午8:55:38
	 */
	@RequestMapping("/myMessageCount")
	public void MyMessageCount(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try {
			MultiUserProfile userProfile = UserService.verifyTokenObj(request);
			PageBean pb=ServletUtils.getParameterBean(request);
			MyMessageCount myMessageCount=myMessageCountServiceImpl.getMessageCount(userProfile,pb);
			result=new RESTResponse("items",myMessageCount);
		}catch (Exception e){
				result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
}
