$(function(){
    userInfo.refresh();
    if(userInfo.isMember){
        initUser();
        initOrderCount();
    }else{
        layer.open({
            content: "您还不是CKU会员，请注册会员或者到会员中心进行绑定！"
            ,btn: '确定',
            yes:function(){
                window.location.href="registerUser.html";
            }
        });
    }

});
function memberCardFun(){
    window.location.href="memberCard.html";
}
//初始化个人信息
function initUser(){
    var user = userInfo.getUser();
    var member = userInfo.getMember();
    var kennel = userInfo.getKennel();
    $("#userLoginName").html(user.loginName);
    if(userInfo.isMember){
        $("#memberDiv").css("display","block");
        $("#memberName").html(member.name);
        $("#memberCode").html(member.memberCode);
        $("#memberEndDate").html("截止日期:"+member.memberEndDate);
        $("#memberType").html("会员类型:"+(member.memberType=="professional"?"专业":"基础"));
        $("#accountBalance").html(member.accountBalance);
    }
    if(member.avatarUrl==""){
        $("#showImage").attr("src","images/perimg_no.png");
    }else{
        $("#showImage").attr("src",member.avatarUrl);
    }
    if(userInfo.isKennel){
        $("#kennelDiv").css("display","block");
        $("#kennelName").html(kennel.name);
        $("#kennelNameEn").html(kennel.nameEn);
        $("#kennelCode").html(kennel.kennelCode);
        $("#kennelType").html("犬舍类型:"+(kennel.type=="year"?"年度":"永久"));
        $("#kennelEndTime").html("截止日期:"+kennel.endTime);
    }
}
//初始化订单数量
function initOrderCount(){
        util.sendAjax({
            url:'finance/orderCount',
            data:{},
            async:false,
            type:'GET',
            cache:false,
            success:function(json){
                $("#unpayCount").html(json.data.unpayCount);
            }
        });
}
//上传图片
function savePicture(){
    var ifmname = 'ifm' + Math.random();
    var ifm = $('<iframe width="0" height="0" frameborder="0" name="' + ifmname + '">');
    ifm.appendTo($('body'));
    var parentFormContent = $("#formcontent").html();
    $(ifm[0].contentWindow.document.body).append(parentFormContent);
    $(ifm[0].contentWindow.document.body).find("#image_file").click();
    //layer.open({type: 2});
    $(ifm[0].contentWindow.document.body).find("#image_form").change(
        function(){
            $(ifm[0].contentWindow.document.body).find("#image_form").submit();
            ifm.on("load",function() {
                var jsonText = $(ifm[0].contentWindow.document.body).text();
                var json = eval('(' + jsonText + ')');
                $("#showImage").attr("src","/oa-web/api/v1/file/image/"+json.data.id);
                //layer.closeAll();
                save(json.data.id);
            });
        });
}


/**
 * 修改会员信息
 */
function save(avatar){
    var user = userInfo.getUser();
    var member = userInfo.getMember();
    var updatedata={
        name : member.name,
        gender : member.gender,
        nameEn : member.nameEn,
        cardNo : member.cardNo,
        phone : member.phone,
        mobile : member.mobile,
        birthday : member.birthday,
        province : member.province,
        city : member.city,
        street : member.street,
        fax : member.fax,
        email : member.email,
        nickName : user.name,
        avatar : avatar,
        deliveryCertified:member.deliveryCertified,
        deliveryNotice:member.deliveryNotice
    };
    /**
     * 修改个人信息
     */
    util.sendAjax({
        url:'userCenter/personalInfo',
        data: JSON.stringify(updatedata),
        async:true,
        type:'PUT',
        cache:false,
        success:function(json){
            if(json.rc==0){
                layer.open({
                    content: "修改个人头像成功！"
                    ,btn: '确定',
                    yes:function(){
                        window.location.reload();
                    }
                });
            }else{
                layer.open({
                    content: "修改个人头像失败,错误代码:"+json.rc+"错误信息:"+json.msg
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
            }
        }
    });
};
