define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();  
        me.member = ko.observable({});
        me.memberCode = ko.observable(userInfo.getMember().memberCode);
        me.name = ko.observable(userInfo.getMember().name);
        me.amount = ko.observable("0");
        me.orderId = ko.observable("");

        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findPaymentRecord(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<me.pageArray().length){
                me.pageNo(me.pageNo()+1);
            }

            me.findPaymentRecord(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findPaymentRecord(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findPaymentRecord(false);
            }
            return false;
        }
        //充值记录
        me.listData = ko.observableArray([]);

        me.findPaymentRecord = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            sendData["chargingItemId"] = "0";
            util.sendAjax({
                url:'finance/paymentRecord',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            me.listData(json.list);
                        }else{
                            me.listData([]);
                        }
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("充值记录失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        /**
         * 充值
         */
        me.rechargewx = function(){
            var sendData = {};
            sendData["memberCode"] = me.memberCode();
            sendData["name"] = me.name();
            sendData["amount"] = me.amount();
            sendData["paymentWay"] = "24";
            util.sendAjax({
                url:'userCenter/rechargeWeiXin',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.orderId(json.data.id);
                        layer.open({
                            type: 2,
                            area: ['618px', '470px'],
                            fix: false, //不固定
                            maxmin: true,
                            content: 'code.html?id='+me.orderId()
                        });
                    }else{
                        layer.msg("充值失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        me.rechargeap = function(){
            var sendData = {};
            sendData["memberCode"] = me.memberCode();
            sendData["name"] = me.name();
            sendData["amount"] = me.amount();
            sendData["paymentWay"] = "1";
            util.sendAjax({
                url:'userCenter/rechargeAlipay',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.orderId(json.data.id);
                        window.location.href = "http://vip.chongaibao.com/oa-web/api/v1/open/alipay/pay/" +json.data.id;
                    }else{
                        layer.msg("充值失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        $(function(){
            me.member(userInfo.getMember());
            me.findPaymentRecord();
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});