<%@page import="com.cku.oa.sys.entity.user.MemberCardTypeEnum"%>
<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 150px!important;
		}
	</style>
	<script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		function loadFun(btnId){
			layer.load();
			$("#"+btnId).prop("disabled",true);
		}
		
		function closeLoadFun(btnId){
			layer.closeAll('loading');
			$("#"+btnId).prop("disabled",false);
		}
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent().html());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$("#btnSubmit").click(function(){
				loadFun("btnSubmit");
				$("#inputForm").ajaxSubmit({
			        dataType: 'json',
			        beforeSubmit: function(){
						if (!$("#inputForm").valid() || $(".error-label:visible").length > 0){
							closeLoadFun("btnSubmit");
							return false;
						}
						else{
				            return true;
						}
			        },
			        success: function(data){
						closeLoadFun("btnSubmit");
			            top.layer.msg(data.msg);
					    if(data.rc == 0){
							window.location = "${ctx}/sys/user/member"
					    }
			        },  
			        error: function(err) { 
						closeLoadFun("btnSubmit");
						top.layer.msg("操作失败!");           
			        }
				});
			});

			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${member.province}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#province").append(html);
						if(option!=''){
							$("#province").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});


			$("#registerProvince").empty().val("").select2();
			$("#registerCity").empty().val("").select2();
			$("#registerArea").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${member.registerProvince}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#registerProvince").append(html);
						if(option!=''){
							$("#registerProvince").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
			

			if("${member.memberCardType}" == "${MemberCardTypeEnum.PLATINUM_CARD.code()}" || "${member.memberCardType}" == "${MemberCardTypeEnum.PURPLE_CARD.code()}"){
				$(".kennelClass").show();
			}else{
				$(".kennelClass").hide();
			}
		});
		function bind(id){
			parent.layer.open({
				type: 2,
				title: ['会员缴费历史记录', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '400px'],
				content: "${ctx}/sys/user/member/renewalRecords?id="+id,
			});

			return false;
		}
		
		function searchSingleClub(){
			top.layer.open({
				type: 2,
				title: ['单犬种俱乐部查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/singleOrg/search"
			});
		}
		this.searchSingleClubCallback = function (json){
			console.log(1111111);
			$("#singleClubId").val(json.id);
			$("#singleClub").val(json.name);
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/user/member/">会员列表</a></li>
		<li class="active"><a href="${ctx}/sys/user/member/form?id=${member.id}">会员<shiro:hasPermission name="sys:user:member:edit">${not empty member.id?'修改':'添加'}</shiro:hasPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="member" action="${ctx}/sys/user/member/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group" style="width:80%">
			<label class="control-label">2寸照：</label>
			<div class="controls">
				<sys:singleImgUpload module="member" imgId="${member.avatar }" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>
			</div>
		</div>
		<div style="clear:both;"></div>
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" readonly="true" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名拼音：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false" maxlength="100" class="input-xlarge " />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="200" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">安全手机：</label>
			<div class="controls">
				<form:input path="safeMobile" readonly="true" htmlEscape="false" maxlength="200" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>

		<c:if test="${!empty member.contractCode}">
			<div class="control-group">
				<label class="control-label">淘宠合同编号：</label>
				<div class="controls">
					<form:input path="contractCode" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
					<span class="help-inline"><font color="red">*</font></span>
				</div>
			</div>
		</c:if>

		<div class="control-group">
			<label class="control-label">账户余额：</label>
			<div class="controls">
				${ member.accountBalance}
					<form:select path="balanceBlockedFlag" class="input-small">
						<form:option value="0" label="未冻结"/>
						<form:option value="1" label="已冻结"/>
					</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍名称：</label>
			<div class="controls">
				${fns:escapeHtml(member.kennel.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记人：</label>
			<div class="controls">
				<fmt:formatDate value="${member.createBy.name}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记日期：</label>
			<div class="controls">
				<fmt:formatDate value="${member.createDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		
		<div style="clear:both;"></div>
		<h3>邮寄地址</h3>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var option = "";
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
								if('${member.city}'==lists[i].city) {
									option = lists[i].city;
								}
							}
							$("#city").append(html);
							if(option!=''){
								$("#city").val(option).select2().change();
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var option = "";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
								if('${member.area}'==lists[i].area) {
									option = lists[i].area;
								}
							}
							$("#area").append(html);
							if(option!=''){
								$("#area").val(option).select2().change();
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
			
		</div>
		
		
		<div style="clear:both;"></div>
		<h3>注册地址</h3>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="registerProvince" path="registerProvince" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="registerCity" path="registerCity" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#registerProvince").change(function(){
				$("#registerCity").empty().val("").select2();
				$("#registerArea").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var option = "";
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
								if('${member.registerCity}'==lists[i].city) {
									option = lists[i].city;
								}
							}
							$("#registerCity").append(html);
							if(option!=''){
								$("#registerCity").val(option).select2().change();
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="registerArea" path="registerArea" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#registerCity").change(function(){
				$("#registerArea").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var option = "";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
								if('${member.registerArea}'==lists[i].area) {
									option = lists[i].area;
								}
							}
							$("#registerArea").append(html);
							if(option!=''){
								$("#registerArea").val(option).select2().change();
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="registerStreet" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div style="clear:both;"></div>
		<h3>会员缴费信息</h3>
		<div class="control-group">
			<label class="control-label">CKU会员类型：</label>
			<div class="controls">
				<form:select path="memberCardType" class="input-large">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('member_card_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<c:if test="${member.memberCardType ne MemberCardTypeEnum.PURPLE_CARD.code() && member.memberCardType ne MemberCardTypeEnum.FOREIGN_CARD.code()}">
					<shiro:hasPermission name="sys:user:member:pay">
<%-- 						<button class="btn btn-primary" onclick="util.mergePay('${member.id}','sys_member@BTP,sys_member@P','${member.memberCode}');return false;">升级</button> --%>
					</shiro:hasPermission>
				</c:if>
                <ul>
                   <font color="#FF0000" style="margin: -25px;">注：会员无效的情况下可修改会员类型</font>
                </ul>
			</div>
		</div>
		<div style="clear:both;"></div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input id="kennelName" path="kennel.name" htmlEscape="false"  readonly="true" class="input-xlarge" />
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameError" style="display:none" class="error error-label"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input id="nameEn" path="kennel.nameEn" htmlEscape="false"  readonly="true" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameEnError" style="display:none" class="error error-label"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍FCI英文名：</label>
			<div class="controls">
				<form:input id="fciName" path="kennel.fciName" htmlEscape="false"  readonly="true" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="fciNameError" style="display:none" class="error error-label"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍FCI备用名：</label>
			<div class="controls">
				<form:input id="fciNameBackup" path="kennel.fciNameBackup" htmlEscape="false"  readonly="true" class="input-xlarge"/>
				<label id="fciNameBackupError" style="display:none" class="error error-label"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费状态：</label>
			<div class="controls">
				<input type="text" value="${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}" class="input-xlarge " readonly="readonly"/>
				<shiro:hasPermission name="sys:user:member:pay">
					<c:if test="${!empty payItem && fn:contains(payItem, ',')}">
						<button class=" btn btn-primary" onclick="util.mergePay('${member.id}','${payItem }','${member.memberCode}');return false;">缴会员费</button>
					</c:if>
					<c:if test="${!empty payItem && !fn:contains(payItem, ',')}">
						<button class=" btn btn-primary" onclick="util.pay('${member.id}','${payItem }','1','','${member.memberCode}');return false;">缴会员费</button>
					</c:if>
				</shiro:hasPermission>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第一次缴费时间：</label>
			<div class="controls">
				<fmt:formatDate value="${member.firstPaymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group" style="clear:left;">
			<label class="control-label">会员截止时间：</label>
			<div class="controls">
				<input name="" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.memberEndDate}" pattern="yyyy-MM-dd"/>"/>
			</div>
		</div>
		<div class="control-group">
					<label class="control-label"><a href="javascript:;"  onclick="bind('${member.id}')">查看历史缴费</a></label>

		</div>
		<div class="control-group"  style="clear:left;">
			<label class="control-label">美容师类型：</label>
			<div class="controls">
				<form:select path="groomerType" class="input-small">
					<form:option value="">非会员</form:option>
					<form:options items="${fns:getDictList('user_groomer_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" >美容师结束时间：</label>
			<div class="controls">
				<input name="" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.groomerEndDate}"  pattern="yyyy-MM-dd"/>"/>
				<shiro:hasPermission name="sys:user:member:pay">
					<c:if test="${member.groomerType eq 'reserve'}">
						<button class=" btn btn-primary" onclick="util.pay('${member.id}','sys_member@GR','1','','${member.memberCode}');return false;">预备美容师费</button>
					</c:if>
					<c:if test="${member.groomerType eq 'formal'}">
						<button class=" btn btn-primary" onclick="util.pay('${member.id}','sys_member@GF','1','','${member.memberCode}');return false;">正式美容师费</button>
					</c:if>
				</shiro:hasPermission>
			</div>
		</div>
		<div class="control-group"  style="clear:left;">
			<label class="control-label">犬运动会员类型：</label>
			<div class="controls">
				${fns:getDictLabels(member.dgMemberType, 'dg_member_type', '非会员')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬运动会员过期时间：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.dgEndDate}" pattern="yyyy-MM-dd"/>"/>
					<shiro:hasPermission name="sys:user:member:pay">
					<button class="btn btn-primary" onclick="util.pay('${member.id}','sys_member@D','1','','${member.memberCode}');return false;">缴费</button>
					</shiro:hasPermission>
			</div>
		</div>
		
		<div style="clear:both;"></div>
		<h3>其他信息</h3>
		<div class="control-group">
			<label class="control-label">推荐人会员号：</label>
			<div class="controls">
				<form:input path="referee" htmlEscape="false"  maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<!--
		<div class="control-group">
			<label class="control-label">杂志邮寄方式：</label>
			<div class="controls">
				<form:input path="deliveryMagazine" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		 -->
		<div class="control-group">
			<label class="control-label">邮寄 -证书类：</label>
			<div class="controls">
				<form:select path="deliveryCertified" class="input-small " >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_certified')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮寄-通知类：</label>
			<div class="controls">
				<form:select path="deliveryNotice" class="input-small" >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_notice')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">最后联系时间：</label>
			<div class="controls">
				<input name="lastCall" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.lastCall}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">禁止报名截至时间：</label>
			<div class="controls">
				<input name="banEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.banEndDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记人：</label>
			<div class="controls">
				<form:input path="registrant" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记日期：</label>
			<div class="controls">
				<input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.createDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属俱乐部：</label>
			<div class="controls">
				<form:input path="ckuClub" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">单犬种机构归属：</label>
			<div class="controls">
				<form:hidden path="singleClubId"  class="input-xlarge required" readonly="true"/>
				<form:input  path="singleClub"  htmlEscape="false" maxlength="100" class="input-xlarge" readonly="true"/>
				<input id="selectSingleClub" class="btn btn-primary" value="查询" type="button" onclick="searchSingleClub()"/>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>冻结信息</h3>
		<div class="control-group">
			<label class="control-label">冻结状态：</label>
			<div class="controls">
				<form:select path="freezeFlag" class="input-small" >
					<form:option value=""></form:option>
					<form:option value="0">未冻结</form:option>
					<form:option value="1">已冻结</form:option>
				</form:select>
				<ul>
					<font color="#FF0000" style="margin: -25px;">犬舍是否同时冻结，请前往犬舍管理进行确认</font>
				</ul>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" maxlength="5000" class="input-xlarge "/>
			</div>
		</div>

		<div style = "clear:both;"></div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:user:member:edit"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
			<button class="btn" onclick="util.showLog('/oa-web/oaManage/sys/user/member','${member.id}');return false;">查看操作日志</button>
		</div>

	</form:form>

</body>
</html>