<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>邮寄发件管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.ant-btn {
		    position: relative;
		    display: inline-block;
		    font-weight: 400;
		    white-space: nowrap;
		    text-align: left;
		    border: 1px solid transparent;
		    cursor: pointer;
		    transition: all .3s cubic-bezier(.645,.045,.355,1);
		    -moz-user-select: none;
		    user-select: none;
		    touch-action: manipulation;
		    height: 32px;
		    font-size: 14px;
		    margin-left: -5px;
		}
		.ant-btn, .ant-btn:active, .ant-btn:focus {
		    outline: 0;
		}
		.ant-btn-link {
		    color: #1ab394;
		    border-color: transparent;
		    background: transparent;
		    box-shadow: none;
		}
		.xm-select-view {
			width:470px;
		}
	</style>
	<script src="${ctxStatic}/xmSelect/xm-select.js" type="text/javascript"></script>
	<script type="text/javascript">
		var scs = null;
		$(document).ready(function() {
			$('body').click(function(){
				if(scs != null){
					scs.closed();
				}
			})
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					try {
						if($("input[name='ids'][samplingFlag='true']:checked").length > 0
							&& ($("#contentValue").val() == '' || $("#contentValue").val() == undefined)){
							$.jBox.alert("邮寄采样包应选择对应采样包编号！","提示");
							return false
						}
						if(($("#contentValue").val() != '' && $("#contentValue").val() != undefined)
							&& $("input[name='ids'][samplingFlag='true']:checked").length != $("#contentValue").val().split(",").length
							){
							$.jBox.alert("采样包编号与发件内容数量不等！","提示");
							return false
						}
					}
					catch(err) {
						console.log("错误信息：" + err);
					    return false;
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${expressSend.province}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#province").append(html);
						if(option!=''){
							$("#province").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});

			var e='${delivery}';
			var a=e.split(":");
			var b=a[1];
			$("input[type=radio][name='expressType'][value='"+b+"']").attr("checked",'true');

			// TODO zhaoxy
			 if(b=='顺丰到付快递'){
				$("#expressName option[value='shunfeng']").attr("selected","selected");
				$("#expressName").trigger("change");

			    var expressNo = '${expressSend.expressNo}';
				if(expressNo == null || expressNo == ''){
					var timestamp = (new Date()).valueOf();
		        	$("#expressNo").val("CAWGDOG" + timestamp);
		        	$("#expressNo").attr("readonly","readonly");
				}
			}else if(b=='申通到付快递'){
				$("#expressName option[value='shentong']").attr("selected","selected");
				$("#expressName").trigger("change");
			    $("#expressNo").removeAttr("readonly");
			}

			$("#pingyang").hide();
			$("#chongai").hide();
			var sender = '${expressSend.sender}';
			if(sender == '' || sender == '1'){
				sender = "1";
				$("#pingyang").show();
			}
			else{
				sender = "2";
				$("#chongai").show();
			}
			$(":radio[name='sender'][value='" + sender + "']").prop("checked", "checked");

			$('input[type=radio][name=sender]').change(function() {
		          if (this.value == '1') {
		        	  $("#pingyang").show();
		  			  $("#chongai").hide();
		          }
		          else if (this.value == '2') {
		        	  $("#pingyang").hide();
		  			  $("#chongai").show();
		          }
		      });


			// TOTO zhaoxy
		    $('input[type=radio][name=expressType]').change(function() {
		          if (this.value == '顺丰到付快递') {
		        	  var timestamp = (new Date()).valueOf();
		        	  $("#expressNo").val("CAWGDOG" + timestamp);
		        	  $("#expressNo").attr("readonly","readonly");
		        	  $("#expressName option[value='shunfeng']").attr("selected",true);
		        	  $("#expressName").trigger("change");
		          }
		          else{
		        	  $("#expressNo").val("");
		        	  $("#expressNo").removeAttr("readonly");
		          }

		     });

		    /* var temp = '${expressDetail}';
			if(!(temp == null || temp == '')){
				var expressDetail = JSON.parse(temp);
				if(expressDetail != '' || expressDetail.length > 0){
					var sfNumber = expressDetail[0].waybillNo;
					var content = '物流单号:' + sfNumber + '<br/>';
					for(var i = 0; i < expressDetail.length;i++){
						content += expressDetail[i].createTime + "&nbsp;&nbsp;&nbsp;&nbsp;[" + expressDetail[i].netcode + "]  " + expressDetail[i].orderStateDesc + "<br/>";
					}
					$("#expressDetail").html(content);
				}
			} */

			var expressNo = '${expressNo}';
			if(!(expressNo == null || expressNo == '')){
				if(expressNo.substring(0,4) == "CAWG"){
					$("#expressNo").attr("disabled","disabled");
				}
			}
			if(Boolean("${showSampling}")){
				initSampling();
			}
		});
		var b=false;
		function allCheck(){
			if (!b) {
				b=true;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
					checkItemOnclick(this);
				});
				$("#buttonSel").text("取消全选")
			}else{
				b=false;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
					checkItemOnclick(this);
				});
				$("#buttonSel").text("全选")
			}
		}

		function initSampling(){
			var samplingList = [];
			/* var samplingInitValue = []; */
			<c:forEach items="${usableSamplingList}" var="item">
				var temp = {};
				temp.id = "${item.samplingCode}";
				temp.samplingCode = "${item.samplingCode}";
				temp.dogCode = "${item.dogCode}";
				if("${item.flowState}"=="1"){
					temp.selected = true
				}
				
				if("${item.bindType}"=="1"){
					temp.disabled = true
				}
				samplingList.push(temp);
			</c:forEach>
			//初始化select
			scs = xmSelect.render({
				el: '#samplingCodeSelect',
				checkbox: true,
				repeat: false,
				autoRow: true,
				filterable: true,
				prop: {name: 'samplingCode', value: 'samplingCode'},
				height: '300px',
				tips: '请选择',
				toolbar: {
					show: false,
					list:['CLEAR']
				},
				template({ item, sels, name, value }){
					var label = name;
					if(item.dogCode && item.dogCode !=""){
						label += '<span style="position:absolute; right:10px;color:#8799a3">已绑定犬只（'+item.dogCode+'）</span>'; 
					}
					return label; 
				},
				tree: {
					show: true,
					showFolderIcon: true,
					showLine: true,
					indent: 20,
					expandedKeys: [-3],
					strict: false,
				},
				data: function () {
					return samplingList;
				},
				on: function (data) {
					if($("input[name='ids'][samplingFlag='true']:checked").length == 0){
						$.jBox.alert("请先选择发件内容！","提示");
						$.each(data.arr, function(i, item){     
							if(!item.disabled){
								data.arr.pop(item);
							}
						});   
						setTimeout(function(){
							scs.closed();
						},100);
					}else if(data.arr.length > $("input[name='ids'][samplingFlag='true']:checked").length){
						$.jBox.alert("采样包编号数量不能大于已选中的发件数！","提示");
						data.arr.pop(data.change)
						setTimeout(function(){
							scs.closed();
						},100);
					}
					let valStr = "";
					$.each(data.arr, function (index, item) {
						valStr += item.samplingCode;
						if (index != data.arr.length - 1) {
							valStr += ',';
						}
					});
					$("#contentValue").val(valStr);
				}
			});
			
		}
		
		function checkItemOnclick(checkbox){
			var reissueSamplingFlag = $(checkbox).attr("reissueSamplingFlag");
			if(Boolean(reissueSamplingFlag)){
				var reissueSamplingCode = $(checkbox).attr("reissueSamplingCode");
				var checkedReissueSamplingCodes = [];
				$("input[name='ids'][reissueSamplingFlag='true']:checked").each(function(){
					checkedReissueSamplingCodes.push($(this).attr("reissueSamplingCode"));
				});
				$("#reissueContentValue").val(checkedReissueSamplingCodes.toString());
			}
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/expressSend/form?id=${expressSend.id}">邮寄发件<shiro:hasPermission name="sys:expressSend:view">${not empty expressSend.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="sys:expressSend:view">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="expressSend" action="${ctx}/sys/expressSend/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="expressName"/>
		<form:hidden path="expressType"/>

		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<c:if test="${empty expressQueue }">
					<button class="btn btn-primary" onclick="searchUser();return false;">查询</button>
				</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				<form:input path="memberName" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">邮寄地址：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:select id="area" path="area" class="input-small">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:input path="address" htmlEscape="false" maxlength="255" class="input-xlarge required" value="${address }"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>

			<script>
				$("#province").change(function(){
					$("#city").empty().val("").select2();
					$("#area").empty().val("").select2();
					var code = $(this).find("option:selected").attr("code");
					$.ajax({
						url:'${ctxCity}',
						data: {province_code:code},
						async:true,
						loadFlag:true,
						type:'get',
						cache:false,
						success:function(json){
							if(json.rc==0){
								var option = "";
								var html = "<option value='' code=''>请选择城市</option>";
								var lists = json.items;
								for(var i = 0;i<lists.length;i++){
									html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
									if('${expressSend.city}'==lists[i].city) {
										option = lists[i].city;
									}
								}
								$("#city").append(html);
								if(option!=''){
									$("#city").val(option).select2().change();
								}
							}else{
								layer.msg(json.msg);
							}
						}
					});
				})
				$("#city").change(function(){
					$("#area").empty().val("").select2();
					var code = $(this).find("option:selected").attr("code");
					$.ajax({
						url:'${ctxArea}',
						data: {city_code:code},
						async:true,
						loadFlag:true,
						type:'get',
						cache:false,
						success:function(json){
							if(json.rc==0){
								var html = "<option value='' code=''>请选择区域</option>";
								var option = "";
								var lists = json.items;
								for(var i = 0;i<lists.length;i++){
									html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
									if('${expressSend.area}'==lists[i].area) {
										option = lists[i].area;
									}
								}
								$("#area").append(html);
								if(option!=''){
									$("#area").val(option).select2().change();
								}
							}else{
								layer.msg(json.msg);
							}
						}
					});
				})
		</script>
		</div>

		<%-- <div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" maxlength="255" class="input-xlarge required" value="${address }"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>  --%>

		<div class="control-group">
			<label class="control-label">收件人：</label>
			<div class="controls">
				<form:input path="receiver" htmlEscape="false"  maxlength="100"  class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="64" class="input-xlarge required" value="${mobile }"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">邮寄方式：</label>
			<div class="controls">
				<form:radiobuttons path="expressType" disabled = "true" items="${fns:getDictList('delivery_certified') }" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<br/>
				<div id="recent">
					${recentSend}
				</div>
				<br/>
				<div id="delivery">
					${delivery}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">快递公司：</label>
			<div class="controls">
				<form:select path="expressName" disabled="true" class="input-small required ">
					<form:option value="无">无</form:option>
					<form:options items="${fns:getDictList('express_name')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">快递单号：</label>
			<div class="controls">
				<form:input path="expressNo" htmlEscape="false" maxlength="50"   class="input-xlarge" />
				<span class="help-inline"> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">发件日期：</label>
			<div class="controls">
				<input name="postDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required" value="<fmt:formatDate value="${expressSend.postDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">发件内容：</label>
			<div class="controls">
				<div>
					<!-- <a id="buttonSel" href="#" onclick="allCheck()" >全选</a> -->
					<button id="buttonSel" class="ant-btn ant-btn-link" type="button" onclick="allCheck()">全选</button>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
				<div style="width:800px;overflow-x: scroll;">
					<c:forEach items="${expressQueue}" var="express" varStatus="status">
						<input name="ids" samplingFlag="${express.samplingFlag}" type="checkbox" reissueSamplingFlag="${express.reissueSamplingFlag}" onclick="checkItemOnclick(this);" reissueSamplingCode="${express.reissueSamplingCode}" value="${express.id }" ${express.expressSendId == null?'':'checked="checked"' } class="checkedId"/> ${express.itemName }
						<c:if test="${ status.count % 3 eq 0}">
							<br/>
						</c:if>
					</c:forEach>
				</div>
			</div>
		</div>
		<c:if test="${showSampling}">
			<div class="control-group">
				<label class="control-label">采样包编号：</label>
				<div class="controls" style="overflow: visible">
					<form:hidden path="contentValue"/>
					<div id="samplingCodeSelect" class="xm-select-view"></div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">补寄采样包编号：</label>
				<div class="controls" style="overflow: visible">
					<input type="text" id="reissueContentValue" name="reissueContentValue" value="${expressSend.reissueContentValue}" class="input-xxlarge" readonly="readonly" />
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">收件日期：</label>
			<div class="controls">
				<input name="receiveDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate" value="<fmt:formatDate value="${expressSend.receiveDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">发件备注：</label>
			<div class="controls">
				<form:textarea path="sendRemarks" htmlEscape="false" rows="4" class="input-xxlarge " />
			</div>
		</div>

		<!-- TODO zhaoxy -->
		<div class="control-group">
            <label class="control-label">发件人：</label>
            <div class="controls">
	            <input name="sender" maxlength="50" class="input-xlarge" type="radio" value="1" />
	            <label>平阳中爱</label>
	            <input name="sender" maxlength="50" class="input-xlarge" type="radio" value="2" />
	            <label>宠爱王国</label>
       	 	</div>

       	 	<div class="controls" id="pingyang">
       	 		发件人: ${fns:getDictList('express_sender')[0]}<br/>
       	 		发件地址: ${fns:getDictList('express_send_address')[0]}<br/>
       	 		联系电话: 13396953132
       	 	</div>
       	 	<div class="controls" id="chongai">
       	 		发件人: ${fns:getDictList('express_sender')[1]}<br/>
       	 		发件地址: ${fns:getDictList('express_send_address')[1]}<br/>
       	 		联系电话: 400-6607000
       	 	</div>
        </div>
       <!--  <div class="control-group">
        	 <label class="control-label">物流信息：</label>
        	 <div class= "controls" id="expressDetail">

        	 </div>
        </div> -->

		<c:if test="${ not empty expressSend.id}">
			<div class="control-group">
				<label class="control-label">操作记录：</label>
				<div class="controls">
					<form:textarea path="remarks" readonly="true" htmlEscape="false" rows="4" class="input-xxlarge " />
				</div>
			</div>
		</c:if>
		<div class="form-actions">
			<!-- TODO zhaoxy -->
			<%--  <c:if test="${empty expressSend.otherExpressNo}">  --%>
			<shiro:hasPermission name="sys:expressSend:view"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<%--  </c:if>  --%>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>

		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode").val(json.memberCode);
			$("#memberName").val(json.name);
			$("#phone").val(json.mobile);
			$("#receiver").val(json.name);
			$("#address").val(json.street);
			$("#postcode").val(json.postcode);
			setTimeout(function(){
				$("#province").val(json.province).trigger("change");
			},1000);
			setTimeout(function(){
				$("#city").val(json.city).trigger("change");
			},2000);
			setTimeout(function(){
				$("#area").val(json.area).trigger("change");
			},3000);
			// 省
			<%--var province = '${province}'.replace("[" , "").replace("]","");--%>
			<%--var provinceList = province.split(",");--%>
			<%--var provinceContent = "<option value=''></option>";--%>
			<%--for (i = 0; i < provinceList.length; i++) {--%>
				<%--var provinceValue = provinceList[i].trim();--%>
				<%--if (provinceValue == json.province) {--%>
					<%--provinceContent += "<option selected value='"+ provinceValue +"'>" + provinceValue + "</option>"--%>
				<%--} else {--%>
					<%--provinceContent += "<option  value='"+ provinceValue +"'>" + provinceValue + "</option>"--%>
				<%--}--%>
			<%--}--%>
			<%--$("#province").html(provinceContent).trigger("change");--%>

			<%--// 城市--%>
			<%--var extId = json.province;--%>
			<%--//异步请求数据--%>
			<%--var url = "${ctx}" + "/sys/area/treeData";--%>
			<%--$.get(url, {--%>
				<%--extId : extId--%>
			<%--}, function(data) {--%>
				<%--var content = "<option value=''></option>";--%>
				<%--for ( var i in data) {--%>
					<%--if (data[i].name == json.city) {--%>
						<%--content += "<option selected value='"+data[i].name+"'>" + data[i].name + "</option>"--%>
					<%--} else {--%>
						<%--content += "<option  value='"+data[i].name+"'>" + data[i].name + "</option>"--%>
					<%--}--%>
				<%--}--%>
				<%--$("#city").html(content).trigger("change");--%>
			<%--}, "json")--%>

			$("#postcode").val(json.postcode);
			$(
					"input[type=radio][name='expressType'][value='"
							+ json.deliveryCertified + "']").attr("checked",
					'true');
			/* if(json.deliveryCertified=='顺风到付快递'){
				$("#expressName option[value=shunfeng]").attr('selected','true');
			}else if(json.deliveryCertified=='申通到付快递'){
				$("#expressName option[value=shentong]").attr('selected','true');
			} */
			var c = json.deliveryCertified;
			// TODO zhaoxy
			if (c == '顺丰到付快递') {
				$("#expressName option[value='shunfeng']").attr("selected",
						"selected");
				$("#expressName").trigger("change");
			    var timestamp = (new Date()).valueOf();
	        	$("#expressNo").val("CAWGDOG" + timestamp);
	        	$("#expressNo").attr("readonly","readonly");

			} else if (c == '申通到付快递') {
				$("#expressName option[value='shentong']").attr("selected",
						"selected");
				$("#expressName").trigger("change");
				$("#expressNo").val("");
				$("#expressNo").removeAttr("readonly");
			} else {
				$("#expressNo").val("");
				$("#expressNo").removeAttr("readonly");
			}

			var memberCode = json.memberCode;
			$.ajax({
				type : "POST",
				url : ctx + "/sys/expressSend/searchOne",
				data : {
					'memberCode' : memberCode
				},
				dataType : 'json',
				async : false,
				success : function(jsons) {
					$("#recent").html(jsons.recentSend);
					$("#delivery").html(jsons.delivery);
				}
			});
		}
	</script>
</body>
</html>