<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员消费信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function mySubmit()
		{	
			document.getElementById("isOnSubmit").value = "1";
			document.getElementById("searchForm").submit();
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class=""><a href="${ctx}/statistics/member/regionalDistribution">会员分布信息</a></li>
		<li class=""><a href="${ctx}/statistics/member/regionalConsumption">会员地区消费信息</a></li>
		<li class="active"><a href="#">会员消费信息</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="memberInfo" action="${ctx}/statistics/member/memberConsumption" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}" />
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>			
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>开始时间：</label>
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="<fmt:formatDate value="${memberInfo.startDate}" pattern="yyyy-MM-dd"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			<li><label>结束时间：</label>
				<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="<fmt:formatDate value="${memberInfo.endDate}" pattern="yyyy-MM-dd"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" name="btnSubmit" class="btn btn-primary" type="submit" onclick = "mySubmit()" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form >
	<sys:message content="${message}"/>
	<div style="color:red;font-size: 20px;float:right">支出:${outPrice}  充值:${inPrice}  余额:${ balance}</div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>姓名</th>
				<th>消费总计</th>				
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="result">
			<tr>
				<td><a href="${ctx}/sys/user/member/toMemberView?memberCode=${result.memberCode}">
					${fns:escapeHtml(result.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(result.name)}
				</td>
				<td>
					${fns:escapeHtml(result.price)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>	
</body>
</html>