<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展报名表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			$("#btnExport").click(function(){
				$.jBox($("#importBox").html(), {title:"犬展导出", buttons:{"关闭":true},
					bottomText:"只有犬展报名已截止后才能导出数据"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function setExportParam(){
			var showCodePrefix = $(":input[name='showCodePrefix']").get(1).value;
			if(showCodePrefix.length<6){
				$("a[name='exportURL']:eq(1)").attr('href','#');
//				$("a[name='editURL']:eq(1)").attr('href','#');
				return;
			}
			var exportURL = "${ctx}/apply/showApply/export?showCodePrefix=";
			var editURL = "${ctx}/apply/showApply/getExportlist?showCodePrefix=";
			$("a[name='exportURL']:eq(1)").attr('href',exportURL+showCodePrefix);
			$("a[name='editURL']:eq(1)").attr('href',editURL+showCodePrefix);
		}
		function open_win() {
			var showCodePrefix = $(":input[name='showCodePrefix']").get(1).value;
			if(showCodePrefix.length<6){
				return;
			}
			window.open("exportApplyList.html")
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
<div id="importBox" class="hide">
	<form id="importForm" class="form-search" style="padding-left:20px;text-align:center;"><br/>
		<label>请输入需要导出的6位犬展编号</label>
		<input name="showCodePrefix" type="text" onblur="setExportParam()" style="width:100px"/><br/><br/>
		<a name="exportURL" href="#">导出</a><br/><br/>
		<a name="editURL"  href="${ctx}/apply/showApply/getExportlist" target="_blank">预览编辑</a>
	</form>
</div>
	<ul class="nav nav-tabs">
		<shiro:hasPermission name="apply:showApply:view"><li class="active"><a href="${ctx}/apply/showApply/">犬展报名表列表</a></li></shiro:hasPermission>
		<shiro:hasPermission name="apply:showApply:add"><li><a href="${ctx}/apply/showApply/editForm">犬展报名表添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showApply" action="${ctx}/apply/showApply/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>报名序号：</label>
				<form:input path="applyCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>证书/芯片：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬种中文名：</label>
				<form:input path="dogBreedNameCn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主人/会员号：</label>
				<form:input path="dogOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>备注：</label>
				<form:input path="remarks" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>犬展编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<shiro:hasPermission name="apply:showApply:notDefault">
			<li><label>缴费：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			</shiro:hasPermission>
			<li><label>过期：</label>
				<form:select path="expireFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未过期"/>
					<form:option value="1" label="已过期"/>
				</form:select>
			</li>
			<li><label>删除：</label>
				<form:select path="delFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('del_flag')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${showApply.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${showApply.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>电话报名服务费：</label>
				<form:select path="phoneApplyFlag" class="input-medium">
					<form:option value="" label="请选择"/>
					<form:option value="-1" label="全部"/>
					<form:option value="0" label="未缴费"/>
					<form:option value="1" label="已缴费"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<%--<li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出犬展报名信息"/></li>--%>
			<li class="btns"><a name="editURL" class="btn btn-primary" href="${ctx}/apply/showApply/getExportlist" target="_blank">导出犬展报名信息</a></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>犬主人</th>
				<th>会员号</th>
				<th>备注</th>
				<th>犬种</th>
				<th width="15%">犬名</th>
				<th>出生日期</th>
			<%--	<th>年龄组别</th>
				<th>BBE</th>--%>
				<th>血统证书号</th>
				<th>芯片号</th>
				<th>犬展编号</th>
				<th>余额</th>
				<th>报名费</th>
				<th>实收金额</th>
				<th>缴费</th>
				<th>提交时间</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showApply">
			<tr>
				<td>
					${fns:escapeHtml(showApply.applyCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogOwnerNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogOwnerMemberCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.remarks)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogBreedNameCn)}
				</td>
				<td title="${fns:escapeHtml(showApply.dogName)}">
					<%--${fns:abbr(showApply.dogName,20)}--%>
                    ${fns:escapeHtml(showApply.dogName)}
				</td>
				<td>
					<fmt:formatDate value="${showApply.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
<%--				<td>
					${fns:getDictLabel(showApply.ageGroup, 'show_age_group', '')}
				</td>
				<td>
					${fns:getDictLabel(showApply.bbeFlag, 'show_apply_bbe', '')}
				</td>--%>
				<td>
					${fns:escapeHtml(showApply.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(showApply.chipCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.showCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.accountBalance)}
				</td>
				<td>
					${fns:escapeHtml(showApply.fee)}
				</td>
				<td>
					${fns:escapeHtml(showApply.paymentAmount)}
				</td>
				<td>
					<shiro:hasPermission name="finance:deductCost:payment">
					<c:choose>
						<c:when test="${showApply.phoneApplyFlag=='0'}">
								<a onclick="util.pay('${showApply.id}','show_apply@phoneApplyFee${showApply.organizer}',${showApply.showNum},'${showApply.phoneApplyFee}','${fns:escapeHtml(showApply.dogOwnerMemberCode)}')">
								服务费
								</a>
						</c:when>
						<c:when test="${showApply.paymentState=='1'&&(!fns:startsWith(showApply.applyCode,'WB')&&!fns:startsWith(showApply.applyCode,'CAB'))}">
							<%-- <a onclick="util.pay('${showApply.id}','${showApply.shortName}',${showApply.showNum},'${showApply.orderPrice}','${fns:escapeHtml(showApply.dogOwnerMemberCode)}')">  --%>
							<a onclick="util.payBusinessOrderByDataId('256017898cf24ccdad0533501f6b0a58','${showApply.dogOwnerMemberCode}','${showApply.id}')">
							${fns:getDictLabel(showApply.paymentState, 'user_payment_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(showApply.paymentState, 'user_payment_state', '')}
						</c:otherwise>
					</c:choose>
					</shiro:hasPermission>
				</td>
				<td>
					<fmt:formatDate value="${showApply.createDate}" pattern="yyyy/MM/dd HH:mm"/>
				</td>
				<td>
				
				<shiro:hasPermission name="apply:showApply:view">
					<a href="${ctx}/apply/showApply/form?id=${showApply.id}">查看</a>
				</shiro:hasPermission>
				<c:if test="${!showApply.businessRefundState}">
					<shiro:hasPermission name="apply:showApply:edit">
						<a href="${ctx}/apply/showApply/editForm?id=${showApply.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="apply:showApply:delete">
						<a href="${ctx}/apply/showApply/delete?id=${showApply.id}" onclick="return confirmx('确认要删除该犬展报名表吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>