<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>在册牵犬师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handler/">在册牵犬师列表</a></li>
		<shiro:hasPermission name="handler:handler:edit"><li><a href="${ctx}/handler/handler/form">在册牵犬师添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="handler" action="${ctx}/handler/handler/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>网站会员：</label>
				<form:input path="webMembershipCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>证书号：</label>
				<form:input path="certificateCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>审核</th>
				<th>会员姓名</th>
				<th>网站会员</th>
				<th>会员号</th>
				<th>性别</th>
				<th>身份证号</th>
				<th>联系电话</th>
				<th>证书号</th>
				<th>查看</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handler">
			<tr>
				<td>
					<c:choose>
						<c:when test="${handler.reviewState=='1' }">
							<font color="green">√</font>
						</c:when>
						<c:when test="${handler.reviewState=='2' }">
							<font color="red">×</font>
						</c:when>
						<c:otherwise>
							<font color="red">未审核</font>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					${fns:escapeHtml(handler.name)}
				</td>
				<td>
					${fns:escapeHtml(handler.webMembershipCode)}
				</td>
				<td>
					<a href="${ctx}/sys/user/member/toMemberView?memberCode=${handler.memberCode}">
					${fns:escapeHtml(handler.memberCode)}
					</a>
				</td>
				<td>
					${handler.gender}
				</td>
				<td>
					${handler.identityCard}
				</td>
				<td>
					${handler.telephone}
				</td>
				<td>
					${handler.certificateCode}
				</td>
				<td>
					<a href="${ctx}/handler/handler/view?id=${handler.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>