<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>新生犬登记管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					save();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.isYes = false;
			parent.layer.closeAll();
		}
		//生成业务信息保存方法
		function save(){
			var hidDogOwenr = $("#hidDogOwenr").val();
			var hidBirthCode = $("#hidBirthCode").val();
			var orgCode = $("#orgCode").val()
			if(hidDogOwenr==''){
				alert("请先查询新犬主会员信息！");
				return;
			}
			if(hidBirthCode==''){
				alert("请先查询出生证明编号！");
				return;
			}
			$("#hospitalName").val($("#orgCode").find("option:selected").text());
			var frm = $("#inputForm");
			var dataPara = util.getFormJson(frm);
			$.ajax({
				url: '${ctx}/newdogchip/dogChip/orderSave',
				type: 'POST',
				data: dataPara,
				async:false,
				success: function(data){
					if(data.rc==0){
						alert("订单录入成功！");
						parent.isYes = true;
						parent.layer.closeAll();
					}else{
						alert("提交失败,错误信息："+data.msg);
					}
				}
			});
		}
		//出生纸信息验证方法
		function getDogBirthCode(){
			var birthCode = $("#birthCode").val();
			if(birthCode==''){
				alert("请填写出生证明编号！");
				return;
			}
			$.post('${ctx}/birthcertificate/dogBirthCertificate/getBirthCerRegByCode', {
				birthCerRegCode: birthCode
			}, function(data) {
				if(data.result=="success"){
					$("#dogBreedCnName").html(data.dogBreedCnName);
					$("#dogGender").html(data.dogGender);
					$("#dogEnName").html(data.dogEnName);
					$("#hidBirthCode").val($("#birthCode").val());
				} else {
					alert("出生证明编号无效！");
				}
			});
		}
		//会员信息验证方法
		function searchUser(){
			var dogOwenr = $("#dogOwenr").val();
			if(dogOwenr==''){
				alert("请填写新犬主会员号！");
				return;
			}
			$.post('${ctx}/sys/user/member/getByMemberCode', {
				memberCode: dogOwenr
			}, function(data) {
				$("#memberName").html(data.name);
				if(data.paymentState=='1'){
					$("#paymentState").html("无效");
					$("#hidDogOwenr").val(data.memberCode);
					$("#hidDogOwenrName").val(data.name);
				}
				if(data.paymentState=='2'){
					$("#paymentState").html("有效");
					$("#hidDogOwenr").val(data.memberCode);
					$("#hidDogOwenrName").val(data.name);
				}
			});
		}
	</script>
</head>
<body>
<form:form id="inputForm" modelAttribute="dogChip" action="" method="post" class="form-horizontal">
	<form:hidden path="id"/>
	<form:hidden id="hidDogOwenr" path="dogBirthCertificate.memberCode"/>
	<form:hidden id="hidBirthCode" path="birthCode"/>
	<form:hidden id="memberCode" path="paymentMemberCode"/>
	<form:hidden path="hospitalName"/>
	<form:hidden path="runningNumber"/>
	<input type="hidden" id="hidDogOwenrName" name="hidDogOwenrName">
	<sys:message content="${message}"/>
	<div class="control-group">
	</div>
	<div class="control-group">
		<label class="control-label">出生证明编号：</label>
		<div class="controls">
			<input id="birthCode" htmlEscape="false" maxlength="64" class="input-xlarge " type="text"/>
			<input id="searchBirthCode" class="btn btn-primary" type="button" value="查" onclick="getDogBirthCode()"/>
		</div>
	</div>
	<script>
		$("#birthCode").change(function(){
			$("#dogBreedCnName").html('');
			$("#dogGender").html('');
			$("#dogEnName").html('');

		})
	</script>
	<div class="control-group">
		<label class="control-label">品种：</label>
		<div class="controls" id="dogBreedCnName">

		</div>
		<label class="control-label">性别：</label>
		<div class="controls" id="dogGender">

		</div>
		<label class="control-label">犬名：</label>
		<div class="controls" id="dogEnName">

		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬只呼名：</label>
		<div class="controls">
			<form:input path="callName" htmlEscape="false" maxlength="4" class="input-xlarge "/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">新犬主会员号：</label>
		<div class="controls">
			<input id="dogOwenr"  htmlEscape="false" maxlength="64" class="input-xlarge " type="text"/>
			<input id="search" class="btn btn-primary" type="button" value="查" onclick="searchUser()"/>
		</div>
	</div>
	<script>
		$("#dogOwenr").change(function(){
			$("#memberName").html('');
			$("#paymentState").html('');

		})
	</script>
	<div class="control-group">
		<label class="control-label">会员姓名：</label>
		<div class="controls" id="memberName">

		</div>
		<label class="control-label">会员状态：</label>
		<div class="controls" id="paymentState">

		</div>
	</div>
	<div class="control-group">
		<label class="control-label">申请医院：</label>
		<div class="controls">
			<select id="province" class="input-small">
				<option value=""></option>
				<c:forEach items="${province}" var="p">
					<option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</option>
				</c:forEach>
			</select>
			<form:select id="orgCode" path="hospitalCode" class="input-xlarge">
				<form:option value="" label=""/>
				<c:forEach items="${orgList}" var="c">
					<form:option value="${fns:escapeHtml(c.orgCode) }">${fns:escapeHtml(c.name) }</form:option>
				</c:forEach>
			</form:select>
		</div>
	</div>
	<script>
		$("#province").change(function(){
			var province = $("#province").val();
			//异步请求数据
			var url="${ctx}"+"/sys/org/getOrg";
			$.get(url,{province:province},function(data){
				var content = "";
				for(var i in data){
					content+="<option value='"+data[i].id+"'>"+data[i].name+"</option>"
				}
				$("#orgCode").html(content).trigger("change");
			},"json")

		})
	</script>
	<div class="form-actions">
		<shiro:hasPermission name="newdogchip:dogChip:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="提交" />&nbsp;</shiro:hasPermission>
		<input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>