<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>藏獒犬只鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function openReviewPage(id){
            parent.layer.open({
                type: 2,
                title: ['犬主变更审核', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['560px', '480px'],
                content: ctx+"/dogtibetanmastiff/dogTibetanMastiff/review?id="+id,
                end: function(){
                    if(parent.isYes){
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    };
                }
            });
        };
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/">藏獒犬只鉴定列表</a></li>
		<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:add"><li><a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/form">藏獒犬只鉴定添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogTibetanMastiff" action="${ctx}/dogtibetanmastiff/dogTibetanMastiff/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="dogOwner" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>犬只名称：</label>
				<form:input path="dogName" htmlEscape="false" maxlength="200" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>申请时间：</label>
				<input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogTibetanMastiff.createDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogTibetanMastiff.endDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬只名称</th>
				<th>性别</th>
				<th>出生日期</th>
				<th>毛色</th>
				<th>犬主姓名</th>
				<th>申请日期</th>
				<th>审核状态</th>
				<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogTibetanMastiff">
			<tr>
				<td>
					${fns:escapeHtml(dogTibetanMastiff.dogName) }
				</td>
				<td>
                    ${fns:getDictLabel(dogTibetanMastiff.gender, 'dog_gender', '')}
                </td>
				<td>
					<fmt:formatDate value="${dogTibetanMastiff.birthdate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogTibetanMastiff.colorFlag) }
				</td>
				<td title="${fns:escapeHtml(dogTibetanMastiff.memberCode)}">
                    ${fns:escapeHtml(dogTibetanMastiff.dogOwner) }
                </td>
				<td>
                    <fmt:formatDate value="${dogTibetanMastiff.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
				<td title="${dogTibetanMastiff.reviewRemarks}">
				    <a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/review?id=${dogTibetanMastiff.id}">
					    <c:if test="${dogTibetanMastiff.reviewState==0}"><font color="red"></c:if>
	                        ${fns:getDictLabel(dogTibetanMastiff.reviewState, 'review_state', '')}
	                    <c:if test="${dogTibetanMastiff.reviewState==0}"></font></c:if>
                    </a>
				</td>
				<td>
				<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:view">
				    <a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/view?id=${dogTibetanMastiff.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:edit">
    				<a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/form?id=${dogTibetanMastiff.id}">编辑</a>
    			</shiro:hasPermission>
    		    <shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:delete">
					<a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/delete?id=${dogTibetanMastiff.id}" onclick="return confirmx('确认要删除该藏獒犬只鉴定吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>