<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>芯片变更管理管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>旧芯片号</th>
				<th>新芯片号</th>
				<th>出生纸编号</th>
				<th>国外血统证书号</th>
				<th>犬展鉴定编号</th>
				<th>缴费会员号</th>
				<th>流水号</th>
				<th>付款的状态</th>
				<th>流程状态</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogChipChange">
			<tr>
				<td>
					${dogChipChange.chipCodeOld}
				</td>
				<td>
					${dogChipChange.chipCodeNew}
				</td>
				<td>
					${dogChipChange.birthCode}
				</td>
				<td>
					${dogChipChange.overseasPedigreeCertified}
				</td>
				<td>
					${dogChipChange.showAppraisalCode}
				</td>
				<td>
					${dogChipChange.paymentMemberCode}
				</td>
				<td>
					${dogChipChange.runningNumber}
				</td>
				<td>
					<c:if test="${dogChipChange.paymentState==1}"><font color="red">${fns:getDictLabel(dogChipChange.paymentState, 'user_payment_state', '')}</font></c:if>
					<c:if test="${dogChipChange.paymentState==2}"><font color="green">${fns:getDictLabel(dogChipChange.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
				<td>
				<c:if test="${dogChipChange.processState==0}"><a onclick="changeProcessState('${dogChipChange.id}')">
					${fns:getDictLabel(dogChipChange.processState, 'proccess_state', '')}</a></c:if>
					<c:if test="${dogChipChange.processState==1}">${fns:getDictLabel(dogChipChange.processState, 'proccess_state', '')}</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>