<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>DNA血样留存管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function editForm(id){
			parent.layer.open({
				type: 2,
				title: ['DNA血样留存 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '550px'],
				content: ctx+"/dogbloodsave/dogBloodSave/editForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogbloodsave/dogBloodSave/">DNA血样留存列表</a></li>
		<%--<shiro:hasPermission name="dogbloodsave:dogBloodSave:edit"><li><a href="${ctx}/dogbloodsave/dogBloodSave/form">DNA血样留存添加</a></li></shiro:hasPermission>--%>
	</ul>
	<form:form id="searchForm" modelAttribute="dogBloodSave" action="${ctx}/dogbloodsave/dogBloodSave/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>出生纸：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>国外血统证书号：</label>
				<form:input path="overseasPedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬展鉴定编号：</label>
				<form:input path="showAppraisalCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>DNA血样编号：</label>
				<form:input path="bloodSampleCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>办理机构：</label>
				<form:input path="organizationName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogBloodSave.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogBloodSave.endCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>完成时间：</label>
				<input name="beginFinishDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogBloodSave.beginFinishDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endFinishDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogBloodSave.endFinishDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>国外血统证书编号</th>
				<th>犬展鉴定编号</th>
				<th>血统证书编号</th>
				<th>犬主</th>
				<th>办理机构</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>撤销状态</th>
				<th>DNA血样编号</th>
				<th>采集方式</th>
				<th>完成时间</th>
				<shiro:hasPermission name="dogbloodsave:dogBloodSave:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBloodSave">
			<tr>
				<td>
					${dogBloodSave.birthCode}
				</td>
				<td>
					${dogBloodSave.overseasPedigreeCertified}
				</td>
				<td>
					${dogBloodSave.showAppraisalCode}
				</td>
				<td>
					${dogBloodSave.pedigreeCertified}
				</td>
				<td>
					${dogBloodSave.name}
				</td>
				<td>
					${dogBloodSave.organizationName}
				</td>
				<td>
					<fmt:formatDate value="${dogBloodSave.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td style="color:${dogBloodSave.paymentState=='2'?'#090':'#F00'}">
						${fns:getDictLabel(dogBloodSave.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<c:if test="${dogBloodSave.isCanceled=='1'}">
						已撤销
					</c:if>
				</td>
				<td><c:if test="${!dogBloodSave.businessRefundState && dogBloodSave.isOEC!='1'}">
					<c:choose>
						<c:when test="${not empty dogBloodSave.bloodSampleCode}">
							<a onclick="editForm('${dogBloodSave.id}')">${fns:escapeHtml(dogBloodSave.bloodSampleCode)}</a>
						</c:when>
						<c:when test="${empty dogBloodSave.bloodSampleCode&&dogBloodSave.paymentState=='2'}">
							<a style="color:#F00" onclick="editForm('${dogBloodSave.id}')">录入</a>
						</c:when>
					</c:choose>
				</c:if></td>
				<td>
					<c:if test="${dogBloodSave.isOEC=='1'}">
						唾液
					</c:if>
					<c:if test="${dogBloodSave.isOEC=='0'}">
						血样
					</c:if>
				</td>
				<td>
					<fmt:formatDate value="${dogBloodSave.finishTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="dogbloodsave:dogBloodSave:edit">
				<td>
					<c:if test="${!dogBloodSave.businessRefundState}">
						<c:if test="${dogBloodSave.paymentState=='2' && dogBloodSave.isCanceled!='1'}">
								<a href="${ctx}/dogbloodsave/dogBloodSave/cancel?id=${dogBloodSave.id}" onclick="return confirmx('确认要撤销该DNA血样留存吗？', this.href)">撤销</a>
						</c:if>
						<shiro:hasPermission name="dogbloodsave:dogBloodSave:delete">
							<a href="${ctx}/dogbloodsave/dogBloodSave/delete?id=${dogBloodSave.id}" onclick="return confirmx('确认要删除该DNA血样留存吗？', this.href)">删除</a>
						</shiro:hasPermission>
					</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>