package com.cku.subsystem.sys;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 杜高登录拦截器
 * 
 * @author chaixueteng
 */
public class LoginInterceptor implements HandlerInterceptor {
	// private Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);

	@Override
	public void afterCompletion(HttpServletRequest arg0,
			HttpServletResponse arg1, Object arg2, Exception arg3)
			throws Exception {

	}

	
	@Override
	public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1,
			Object arg2, ModelAndView arg3) throws Exception {
		
	}

	/**
	 * 杜高后台的接口拦截器
	 */
	@Override
	public boolean preHandle(HttpServletRequest request,
			HttpServletResponse response, Object arg2) throws Exception {
		// 判断用户的登录信息
		User user = UserUtils.getLoginUser();
		if(user == null || user.getId() == null){
			String source=request.getParameter("source");
			if("dcoa".equals(source)){
				response.sendRedirect("/oa-web/subSystem/dcoa/login");
			}else if("mcoa".equals(source)){
				response.sendRedirect("/oa-web/subSystem/mcoa/login");
			}
			return false;
		}
		return true;
	}


}