package com.cku.restful.v1.sys.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.annotation.MultiSubmit;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="/api/v1/open/balpay")
/**
 * 会员通过余额付款的业务
 * @author fanhuibin
 *
 */
public class BalancepayController extends BaseRestController{
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private ShopOrderService shopOrderService;
	private Logger logger = LoggerFactory.getLogger(BalancepayController.class);
	@RequestMapping(value="/pay/{orderId}" , method = RequestMethod.GET)
	@ResponseBody
	public void pay(@PathVariable String orderId,HttpServletRequest request, HttpServletResponse response) throws IOException {
		logger.info("余额支付开始："+request.getParameterMap());
		
		//判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		//判断是否是商城订单
		ShopOrder sOrder = shopOrderService.get(orderId);
		//如果订单已删除。报错提示
		if(order!=null){
			if("1".equals(order.getDelFlag())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该订单已删除，请勿支付");
			}
			if(order.getPaymentState().equals("1")){
				Member member = UserUtils.getLoginMember();
				restOrderService.balPay(order, member);//余额支付订单
			}
		}else if(sOrder!=null){
			if("1".equals(sOrder.getDelFlag())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该商城订单已删除，请勿支付");
			}
			if(sOrder.getPaymentState().equals("1")){
				shopOrderService.clientBalPay(sOrder);//商城余额付款
			}
		}else{
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"订单验证失败，无此订单");
		}
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：余额支付业务订单
	 * @author: zhuoHeng
	 * @version: 2016年12月26日 上午9:06:20
	 */
	@MultiSubmit
	@RequestMapping(value="/cab/pay" , method = RequestMethod.GET)
	@ResponseBody
	public void pay(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String orderId = request.getParameter("orderId");
		//判断用户是否是
		
		//判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		//如果订单已删除。报错提示
		if("1".equals(order.getDelFlag())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该订单已删除，请勿支付");
		}
		if(order != null && order.getPaymentState().equals("1")){
			Member member = UserUtils.getLoginMember();
			restOrderService.balPay(order,member);//余额支付订单
		}else{
			//判断是否是商城订单
			ShopOrder sOrder = shopOrderService.get(orderId);
			if(sOrder != null && sOrder.getPaymentState().equals("1")){
				shopOrderService.clientBalPay(sOrder);//商城余额付款
			}else{
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"订单验证失败");
			}
		}
		
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}
}
