package com.cku.restful.v1.sys.web;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alipay.config.AlipayConfig;
import com.alipay.util.AlipayNotify;
import com.alipay.util.AlipaySubmit;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentPayLog;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentPayLogService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.thinkgem.jeesite.common.config.Global;

@Controller
@RequestMapping(value = "/api/v1/open/alipay")
/**
 * 支付宝扣费
 * 
 * @author fanhuibin
 *
 */
public class AlipayController extends BaseRestController {
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private ShopOrderService shopOrderService;
	@Autowired
	private RestShowApplyService restShowApplyService;
	@Autowired
	private PaymentPayLogService paymentPayLogService;
	private Logger logger = LoggerFactory.getLogger(AlipayController.class);

	@RequestMapping(value = "/pay/{orderId}", method = RequestMethod.GET)
	@ResponseBody
	public void pay(@PathVariable String orderId, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		// 判断订单是否存在，是否为未付款
		String totalPrice = "";
		String memberName = "";
		String title = "";
		PaymentOrder order = paymentOrderService.get(orderId);
		// 如果订单已删除。报错提示
		if ("1".equals(order.getDelFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已删除，请勿支付");
		}
		if (order != null && order.getPaymentState().equals("1")) {
			totalPrice = order.getTotalPrice();
			memberName = order.getMemberName();
			title = "CKU业务扣费";
			// 支付宝、微信支付不允许支付包含赛事报名的订单
			if (restShowApplyService.isShowApplyOrder(order)) {
				BufferedImage image = ImageIO.read(
						new FileInputStream(AlipayController.class.getResource("/").getPath() + "wxPayWarn2.png"));
				ImageIO.write(image, "png", response.getOutputStream());// 输出png图片
				return;
			}
		} else {
			// 判断是否是商城订单
			ShopOrder sOrder = shopOrderService.get(orderId);
			if (sOrder != null && sOrder.getPaymentState().equals("1")) {
				totalPrice = sOrder.getPrice();
				memberName = sOrder.getMemberName();
				title = "CKU商城扣费";
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单验证失败");
			}
		}
		if (Global.isDevMode()) {
			totalPrice = "0.01";
		}
		String path = request.getContextPath();
		String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
		Map<String, String> sParaTemp = new HashMap<String, String>();
		sParaTemp.put("service", AlipayConfig.service);
		sParaTemp.put("partner", AlipayConfig.partner);
		sParaTemp.put("seller_id", AlipayConfig.seller_id);
		sParaTemp.put("_input_charset", AlipayConfig.input_charset);
		sParaTemp.put("payment_type", AlipayConfig.payment_type);
		sParaTemp.put("notify_url", basePath + AlipayConfig.notify_url);
		sParaTemp.put("return_url", basePath + AlipayConfig.return_url);
		sParaTemp.put("anti_phishing_key", AlipayConfig.anti_phishing_key);
		sParaTemp.put("exter_invoke_ip", AlipayConfig.exter_invoke_ip);
		sParaTemp.put("out_trade_no", orderId); // 订单号
		sParaTemp.put("subject", title);
		sParaTemp.put("total_fee", totalPrice);
		sParaTemp.put("it_b_pay", "30m");
		// sParaTemp.put("it_b_pay",AlipayConfig.timeOut(order.getAddTime()));
		// //二维码页面超时支付限制
		sParaTemp.put("body", "CKU会员" + memberName + "的业务缴费");// 以逗号隔开的商品详情
		String sHtmlText = AlipaySubmit.buildRequest(sParaTemp, "post", "确认");
		// 增加支付日志
		paymentPayLogService.savePayLog(order.getId(), "1");
		response.getWriter().write(sHtmlText);
		response.setContentType("text/html;charset=UTF-8");
	}

	/**
	 * 支付宝异步通知，请不要随便修改这个url，会影响付款功能
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/notifyUrl")
	@ResponseBody
	public void notifyUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
		logger.info("支付宝回调开始:");
		boolean flag = afterPayOrder(request);
		if (flag) {
			response.getWriter().write("success"); // 告诉支付宝成功了，别请求我了。
		}
	}

	/**
	 * 支付宝异步通知，请不要随便修改这个url会影响支付功能
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/returnUrl")
	@ResponseBody
	public void returnUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
		afterPayOrder(request);
		//
		// //判断当前是商城订单还是会员业务订单
		// String out_trade_no = new
		// String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"),"UTF-8");
		// ShopOrder sOrder = shopOrderService.get(out_trade_no);
		// String path = request.getContextPath();
		response.setContentType("text/html;charset=UTF-8");
		response.getWriter().write("恭喜您支付成功，请关闭该页面");
	}

	private boolean afterPayOrder(HttpServletRequest request) throws UnsupportedEncodingException {
		boolean flag = true;
		try {
			// 获取支付宝POST过来反馈信息
			Map<String, String> params = new HashMap<String, String>();
			Map requestParams = request.getParameterMap();
			String logInfo = "";
			for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
				String name = (String) iter.next();
				String[] values = (String[]) requestParams.get(name);
				String valueStr = "";
				for (int i = 0; i < values.length; i++) {
					valueStr = (i == values.length - 1) ? valueStr + values[i] : valueStr + values[i] + ",";
				}
				// 乱码解决，这段代码在出现乱码时使用。如果mysign和sign不相等也可以使用这段代码转化
				// valueStr = new String(valueStr.getBytes("ISO-8859-1"), "gbk");
				logInfo += name + ":" + valueStr + ",";
				params.put(name, valueStr);
			}
			logger.info(logInfo);
			// 获取支付宝的通知返回参数，可参考技术文档中页面跳转同步通知参数列表(以下仅供参考)//
			// 商户订单号
			String out_trade_no = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
			// 支付宝交易号
			String trade_no = new String(request.getParameter("trade_no").getBytes("ISO-8859-1"), "UTF-8");
			// 交易状态
			String trade_status = new String(request.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
			// 保存回调的支付日志
			paymentPayLogService.updatePayInfo(out_trade_no, trade_no, params.toString());
			// 获取支付宝的通知返回参数，可参考技术文档中页面跳转同步通知参数列表(以上仅供参考)//
			if (AlipayNotify.verify(params)) {// 验证成功
				//////////////////////////////////////////////////////////////////////////////////////////
				// 请在这里加上商户的业务逻辑程序代码
				// ——请根据您的业务逻辑来编写程序（以下代码仅作参考）——
				if (trade_status.equals("TRADE_FINISHED")) {
					// 判断该笔订单是否在商户网站中已经做过处理
					// 如果没有做过处理，根据订单号（out_trade_no）在商户网站的订单系统中查到该笔订单的详细，并执行商户的业务程序
					// 请务必判断请求时的total_fee、seller_id与通知时获取的total_fee、seller_id为一致的
					// 如果有做过处理，不执行商户的业务程序

					// 注意：
					// 退款日期超过可退款期限后（如三个月可退款），支付宝系统发送该交易状态通知
					logger.info("支付状态：TRADE_FINISHED");
				} else if (trade_status.equals("TRADE_SUCCESS")) {
					try {
						PaymentOrder order = paymentOrderService.get(out_trade_no);
						if (order != null && !StringUtils.isEmpty(order.getOrderCode())) {
							// 业务逻辑
							if (order.getPaymentState().equals("1")) {
								// 会员端支付后处理逻辑
								order.setPaymentWay("1");
								order.setTransactionId(trade_no);
								restOrderService.afterPay(order);
								// 修改支付日志支付状态
								paymentPayLogService.updatePayState(out_trade_no, "2", null);
							} else {
								// 补做任何处理
								logger.error("已处理的订单");
							}
						} else {
							// 判断是否是商城订单
							ShopOrder sOrder = shopOrderService.get(out_trade_no);
							if (sOrder != null && sOrder.getPaymentState().equals("1")) {
								sOrder.setPaymentWay("1");
								shopOrderService.clientPay(sOrder);
								// 修改支付日志支付状态
								paymentPayLogService.updatePayState(out_trade_no, "2", null);
							} else {
								// 可能是已经被处理过的订单，不做处理直接放过
								// 以前抛出异常是错误的
								logger.error("已处理的商城订单");
							}
						}
					} catch (Exception e) {
						logger.error("处理失败", e);
						// 修改支付日志支付状态
						paymentPayLogService.updatePayState(out_trade_no, "3", ExceptionUtil.printStackTrace(e));
						flag = false;
					}
				} else if (trade_status.equals("WAIT_BUYER_PAY")) {
					logger.info("等待支付状态：WAIT_BUYER_PAY");
					// 修改支付日志支付状态
					paymentPayLogService.updatePayState(out_trade_no, "4", "WAIT_BUYER_PAY");
				}
			} else {// 验证失败
				logger.error("验证签名失败");
				// 修改支付日志支付状态
				paymentPayLogService.updatePayState(out_trade_no, "3", "验证签名失败");
				flag = false;
			}
		} catch (Exception e) {
			logger.error("支付宝支付出错" + request.getParameterMap(), e);
		}
		return flag;
	}
	
	@RequestMapping(value = "/test")
	@ResponseBody
	public void test(String id) throws IOException {
		PaymentPayLog log = paymentPayLogService.get(id);
		// 商户订单号
		String out_trade_no = log.getOrderId();
		// 支付宝交易号
		String trade_no = log.getTransactionId();
		PaymentOrder order = paymentOrderService.get(out_trade_no);
		if (order != null && !StringUtils.isEmpty(order.getOrderCode())) {
			// 业务逻辑
			if (order.getPaymentState().equals("1")) {
				// 会员端支付后处理逻辑
				order.setPaymentWay("1");
				order.setTransactionId(trade_no);
				restOrderService.afterPay(order);
				// 修改支付日志支付状态
				paymentPayLogService.updatePayState(out_trade_no, "2", null);
			} else {
				// 补做任何处理
				logger.error("已处理的订单");
			}
		} else {
			// 判断是否是商城订单
			ShopOrder sOrder = shopOrderService.get(out_trade_no);
			if (sOrder != null && sOrder.getPaymentState().equals("1")) {
				sOrder.setPaymentWay("1");
				shopOrderService.clientPay(sOrder);
				// 修改支付日志支付状态
				paymentPayLogService.updatePayState(out_trade_no, "2", null);
			} else {
				// 可能是已经被处理过的订单，不做处理直接放过
				// 以前抛出异常是错误的
				logger.error("已处理的商城订单");
			}
		}
	
	}
}
