package com.cku.restful.v1.shop.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.shop.service.RestShopOrderService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 商城订单Controller
 * 
 * @author lyy
 * @version 2016-08-12
 */
@Controller
@RequestMapping(value = "/api/v1/shop")
public class RestShopOrderController extends BaseRestController {

	@Autowired
	private RestShopOrderService restShopOrderService;

	@RequestMapping(value = "/shopOrder/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void get(@PathVariable("id") String id, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopOrderService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopOrder", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopOrderService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopOrder", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopOrderService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopOrder/pay", method = RequestMethod.POST)
	@ResponseBody
	public void pay(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopOrderService.pay(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopOrder/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void delete(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restShopOrderService.delete(id);
		ServletUtils.writeResponse(response, result);
	}

}