package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogPedigreeCertifiedChangeService;
import com.cku.restful.v1.dog.vo.ChangeOrgReqVo;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiOperation;

/**
 * 证书换发Controller
 * 
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogPedigreeCertifiedChangeController extends
		BaseRestController {

	@Autowired
	private RestDogPedigreeCertifiedChangeService restDogPedigreeCertifiedChangeService;

	@RequestMapping(value = "/dogpedigreecertifiedchange/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void get(@PathVariable("id") String id,HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedChangeService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogpedigreecertifiedchange", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogPedigreeCertifiedChangeService
				.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogpedigreecertifiedchange/canceled/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void canceled(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedChangeService.canceled(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogpedigreecertifiedchange", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogPedigreeCertifiedChangeService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogpedigreecertifiedchange/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedChangeService
				.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月9日 上午10:49:39
	 */
	@RequestMapping(value = "/dogpedigreecertifiedchange/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogPedigreeCertifiedChangeService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}

	
	@ApiOperation(value = "3.8.2国外证书换发" ,tags = { "3.8.2" } )
	@RequestMapping(value = "/dogpedigreecertifiedchange/changeOrg", method = RequestMethod.POST)
	@ResponseBody
	public void orderDetail(@RequestBody @Valid ChangeOrgReqVo changeOrgReq ,HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogPedigreeCertifiedChangeService.changeOrg(changeOrgReq);
		ServletUtils.writeResponse(response, result);
	}
	
	
	
}