/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Validator;

import com.cku.oa.constant.Constants;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.CouponDivideEquallyDto;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogDnaDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogDna;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogName;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.BusinessBanService;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelAllianceService;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ConstantUtils;
import com.cku.oa.sys.util.DateUtils;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.tcb.service.TcbKennelService;
import com.cku.restful.v1.dog.model.PetClass;
import com.cku.restful.v1.dog.model.RestDogBirthCertificate;
import com.cku.restful.v1.dog.vo.RestDogBirthCertificatePostVO;
import com.cku.restful.v1.sys.model.RestCouponGroup;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.CouponUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 出生证明Service
 *
 * @author lgl
 * @version 2016-08-04
 */
@Service
@Transactional(readOnly = true)
public class RestDogBirthCertificateService {

	private static final Logger logger = LoggerFactory.getLogger(RestDogBirthCertificateService.class);

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL = "dog_birth_certificate@All";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO = "dog_birth_certificate@Zangao";

	/**
	 * 第二繁殖人登记服务费
	 */
	private static final String SECOND_BREEDER = "second_breeder@all";

	// 电子血统证书优惠，10元
	public static final double ECERT_DISCOUNTS = 10;

	/**
	 * 验证Bean实例对象
	 */
	@Autowired
	protected Validator validator;

	@Autowired
	private DogService dogService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private KennelAllianceService kennelAllianceService;
	@Autowired
	public BusinessBanService businessBanService;
	@Autowired
	public TcbKennelService tcbKennelService;
	@Autowired
	public DogNewbornDao dogNewbornDao;
	@Autowired
	public DogTypeDao dogTypeDao;
	@Autowired
	public DogColorMarkDao dogColorMarkDao;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	public SysCouponService sysCouponService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public DogNoseService dogNoseService;
	@Autowired
	public DogChipService dogChipService;
	@Autowired
	public DogDnaDao dogDnaDao;
	@Autowired
	public DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	public RestDogService restDogService;
	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.get(id);
		if (dogBirthCertificate == null || !member.getMemberCode().equals(dogBirthCertificate.getBreederMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestDogBirthCertificate vo = new RestDogBirthCertificate();
		BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		vo.setBreedDate(sdf.format(dogNewborn.getBreedDate()));
		DogType dogType = dogTypeDao.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		if (dogType != null) {
			vo.setBreedCnName(dogType.getBreedCnName());
		}
		DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
		if (dogColorMark != null) {
			vo.setDogColorMarkCn(dogColorMark.getDogColorMarkCn());
		}
		vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
		vo.setBusinessState(dogBirthCertificateService.getBusinessState(dogBirthCertificate));
		this.validateRefundState(dogBirthCertificate, vo);
		return new RESTResponse("data", vo);
	}

	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		// json转换为对象
		DogBirthCertificate put = BeanUtil.toBean(json, DogBirthCertificate.class);

		// 参数校验
		if (StringUtils.isBlank(put.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id为空");
		}
		if (StringUtils.isBlank(put.getDogEnName())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬英文名为空");
		}
		// 只能为英文字母和空格
		Pattern pattern = Pattern.compile("^[A-Za-z ]+$");
		Matcher matcher = pattern.matcher(put.getDogEnName());
		if (!matcher.matches()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬英文名只能为英文字母和空格");
		}
		if (StringUtils.isBlank(put.getColorFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只毛色为空");
		}

		// 业务校验
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.get(put.getId());
		Member member = UserUtils.getLoginMember();
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(dogBirthCertificate.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if ("1".equals(dogBirthCertificate.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该记录已经通过审核，不允许修改");
		}
		//查找同窝list
		List<DogBirthCertificate> birthCertificateList = dogBirthCertificateService.findByFmdogBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		if(birthCertificateList.stream()
				.map(DogBirthCertificate::getDogEnName)
				.anyMatch(name-> put.getDogEnName().equals(name))){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只英文名同窝内不可重复！");
		}

		this.validateRefundState(dogBirthCertificate, null);// 这个问题我没测出来

		// 更新,并且更新后改为待审核
		DogNewborn dogNewborn = dogNewbornService
				.getBybreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		String dog_kennelName = validateKennel(dogNewborn);
		String dogEnName = put.getDogEnName();
		if (!put.getDogEnName().toUpperCase().contains(dog_kennelName.toUpperCase())) {
			dogEnName = dog_kennelName + " " + put.getDogEnName().substring(0, 1).toUpperCase()
					+ put.getDogEnName().substring(1).toLowerCase();
		}
		dogBirthCertificate.setDogEnName(dogEnName);
		dogBirthCertificate.setColorFlag(put.getColorFlag());
		dogBirthCertificate.setReviewState("0");
		// 白色柴犬禁止繁殖和赛事业务
		dogBirthCertificate.setBusinessBan(businessBanService.getBusinessBan(dogNewborn.getDogBreed(),
				put.getColorFlag(), dogBirthCertificate.getDogBirthday()));
		dogBirthCertificate.setShowBan(businessBanService.getShowBan(dogNewborn.getDogBreed(), put.getColorFlag(),
				dogBirthCertificate.getDogBirthday()));
		dogBirthCertificateService.save(dogBirthCertificate);
		// delete和put方法直接返回RESTResponse对象表示操作成功
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RESTResponse delete(String id) {
		Member member = UserUtils.getLoginMember();
		DogBirthCertificate po = dogBirthCertificateService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		// delete和put方法直接返回RESTResponse对象表示操作成功
		return new RESTResponse();
	}

	public RESTResponse getByBirthCerRegCode(HttpServletRequest request) {
		// 获取参数
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String snCode = request.getParameter("snCode");
		// 参数校验
		if (StringUtils.isBlank(birthCerRegCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
		}
		if (StringUtils.isBlank(snCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "识别码为空");
		}

		DogBirthCertificate example = new DogBirthCertificate();
		example.setBirthCerRegCode(birthCerRegCode);
		example.setSnCode(snCode);
		example.setDelFlag("0");
		// 查询并组装返回对象
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findList(example);
		DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
		RestDogBirthCertificate vo = null;
		if (dogBirthCertificateList.size() > 0) {
			vo = new RestDogBirthCertificate();
			dogBirthCertificate = dogBirthCertificateList.get(0);
			// 以下是CKU官网所需字段
			Dog fdog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getFdogPedigreeCertified(), true);
			Dog mdog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getMdogPedigreeCertified(), true);
			vo.setFdogName(fdog.getNameEn());
			vo.setMdogName(mdog.getNameEn());
			// DNA留存方式是否默认为位点分析，返回true表示是
			if (isDnaArchive(dogBirthCertificate)) {
				vo.setIsDnaArchive("1");
			}
			// 是否能选择双亲比对，返回true表示可以
			if (isDnaParentsCompare(fdog.getId(), mdog.getId(), dogBirthCertificate.getFmdogBreedCertifiedCode())) {
				vo.setIsDnaParentsCompare("1");
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询信息失败，请输入正确的新生犬登记卡编号和识别码！");
		}
		BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
		vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
		vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(), "dog_gender", ""));
		if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
			vo.setDogBreedName(dogType.getBreedCnName());
		}
		setDogAgeInfo(dogBirthCertificate, vo);
		// 页面控制是否展示血样留存和合作机构
		vo.setShowDna(isDnaArchive(dogBirthCertificate));
		return new RESTResponse("data", JSONObject.fromObject(vo));
	}

	public RESTResponse getByIdentificationFlag(HttpServletRequest request) {
		// 获取参数
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String identificationFlag = request.getParameter("identificationFlag");
		// 参数校验
		if (StringUtils.isBlank(birthCerRegCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号/护照编号为空");
		}
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片编号为空");
		}

		DogBirthCertificate example = new DogBirthCertificate();
		example.setBirthCerRegCode(birthCerRegCode);
		example.setIdentificationFlag(identificationFlag);
		example.setDelFlag("0");
		// 查询并组装返回对象
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findList(example);
		DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
		RestDogBirthCertificate vo = null;
		if (dogBirthCertificateList.size() > 0) {
			vo = new RestDogBirthCertificate();
			dogBirthCertificate = dogBirthCertificateList.get(0);
			// 以下是CKU官网所需字段
			Dog fdog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getFdogPedigreeCertified(), true);
			Dog mdog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getMdogPedigreeCertified(), true);
			vo.setFdogName(fdog.getNameEn());
			vo.setMdogName(mdog.getNameEn());
			vo.setCabPassPort(dogBirthCertificate.getCabPassport());
			// DNA留存方式是否默认为位点分析，返回true表示是
			if (isDnaArchive(dogBirthCertificate)) {
				vo.setIsDnaArchive("1");// 是否必选位点分析：0否；1是
			} else {
				vo.setIsDnaArchive("0");
			}
			// 是否能选择双亲比对，返回true表示可以
			if (isDnaParentsCompareNew(fdog.getId(), mdog.getId(), dogBirthCertificate.getFmdogBreedCertifiedCode())) {
				vo.setIsDnaParentsCompare("1");// 是否可以申请 DNA双亲比对标记位：0否；1是
			} else {
				vo.setIsDnaParentsCompare("0");
			}
			vo.setBreederMemberCode(dogBirthCertificate.getBreederMemberCode());
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询信息失败，登记卡编号或芯片编号不正确！");
		}
		BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
		if (null != dogBirthCertificate.getSendDate()) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(dogBirthCertificate.getSendDate());
			calendar.add(Calendar.DATE, DogActivationService.EXPIRE_DAY + 1);
			vo.setActivitionEndDate(new Date(calendar.getTimeInMillis()));
		}
		vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
		vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(), "dog_gender", ""));
		if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
			vo.setDogBreedName(dogType.getBreedCnName());
		}
		setDogAgeInfo(dogBirthCertificate, vo);
		// 根据出生纸编号和芯片号查询的接口会被出生纸二维码查询调用
		// 1需要查询额外的配种日期
		// 2毛色是毛色代码加中文
		// 3繁育人犬舍名
		// 4签发日期，即打印日期
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		vo.setBreedDate(sdf.format(dogNewborn.getBreedDate()));
		DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
		if (dogColorMark != null) {
			vo.setDogColorMarkCn(dogColorMark.getDogColorMarkCn());
		}
		Kennel kennel = kennelService.getKennelByMemberCode(dogBirthCertificate.getBreederMemberCode());
		if (kennel != null) {
			vo.setKennelName(kennel.getName());
		}
		vo.setPrintDate(dogBirthCertificateDao.getPrintDate(dogBirthCertificate.getRunningNumber()));
		Dog dog = dogService.getByBirthCertificateLevelCode(vo.getBirthCerRegCode());
		if (dog != null) {
			vo.setPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
		}
		// 页面控制是否展示血样留存和合作机构
		vo.setShowDna(isDnaArchive(dogBirthCertificate));
		vo.setDogClass(restDogService.getDogClass(identificationFlag));
		vo.setDogClassName(restDogService.getDogClassName(vo.getDogClass()));

		return new RESTResponse("data", JSONObject.fromObject(vo));
	}

	public RESTResponse getByIdentificationFlagValidate(HttpServletRequest request) {
		// 获取参数
		String cabPassportorBirthCerRegCode = request.getParameter("birthCerRegCode");
		String identificationFlag = request.getParameter("identificationFlag");
		// 参数校验
		if (StringUtils.isBlank(cabPassportorBirthCerRegCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号/护照编号为空");
		}
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片编号为空");
		}

		DogBirthCertificate example = new DogBirthCertificate();
		example.setBirthCerRegCode(cabPassportorBirthCerRegCode);
		example.setIdentificationFlag(identificationFlag);
		example.setDelFlag("0");
		// 查询并组装返回对象
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findList(example);
		String flag = "0";
		String PedigreeCertified = "";
		// 无出生纸查询犬只表
		Dog dog = new Dog();
		dog.setIdentificationFlag(identificationFlag);
		dog.setBirthCertificateLevelCode(cabPassportorBirthCerRegCode);
		dog.setDelFlag("0");
		List<Dog> dogList = dogService.findList(dog);
		if (dogBirthCertificateList.size() > 0) {
			if (StringUtils.isNotBlank(dogBirthCertificateList.get(0).getPedigreeCertified())) {
				flag = "1";
				PedigreeCertified = dogBirthCertificateList.get(0).getPedigreeCertified();
			}
		} else if (dogList.size() > 0) {
			if (StringUtils.isNotBlank(dogList.get(0).getPedigreeCertifiedCode())) {
				flag = "1";
				PedigreeCertified = dogList.get(0).getPedigreeCertifiedCode();
			}
		} else {
			// add by zhangjunwu 2021.01.21 兼容等级信息查询，如出生纸及狗表未找到相关信息，则进行等级查询
			PetClass petClass = restDogService.getDogClassInfo(identificationFlag);
			if (Objects.nonNull(petClass) && StringUtils.isNotBlank(petClass.getIdentificationFlag())) {
				String dbBirthCerRegCode = petClass.getBirthCerRegCode();
				String dbCabPassport = petClass.getCabPassport();
				String dbIdentificationFlag = petClass.getIdentificationFlag();
				if ((cabPassportorBirthCerRegCode.equals(dbBirthCerRegCode)
						|| cabPassportorBirthCerRegCode.equals(dbCabPassport))
						&& identificationFlag.equals(dbIdentificationFlag)) {
					flag = "2";
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询信息失败，登记卡编号或芯片编号不正确！");
				}
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询信息失败，登记卡编号或芯片编号不正确！");
			}
		}

		JSONObject data = new JSONObject();
		data.put("birthCerRegCode", cabPassportorBirthCerRegCode);
		data.put("identificationFlag", identificationFlag);
		data.put("flag", flag);
		data.put("PedigreeCertified", PedigreeCertified);
		return new RESTResponse("data", data);
	}

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids, String runningNumber) {
		Member member = UserUtils.getLoginMember();
		DogBirthCertificate example = new DogBirthCertificate();
		example.setBreederMemberCode(member.getMemberCode());
		example.setRunningNumber(runningNumber);
		example.setDelFlag("0");
		example.setId(ids);
		List<DogBirthCertificate> lst = dogBirthCertificateService.findList(example);
		List<RestDogBirthCertificate> list = getList(lst);
		list.stream().forEach(i -> i.setId(i.getFmdogBreedCertifiedCode()));
		return new RESTResponse("data", list);
	}

	private void validateRefundState(DogBirthCertificate po, RestDogBirthCertificate vo) {
		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(po.getFmdogBreedCertifiedCode(),
				po.getRunningNumber());
		if (vo == null) {
			if (!canCanceled)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
		} else {
			vo.setCanEdit(canCanceled);
		}
	}

	private List<RestDogBirthCertificate> getList(List<DogBirthCertificate> lst) {
		List<RestDogBirthCertificate> list = new ArrayList<RestDogBirthCertificate>();
		for (DogBirthCertificate dogBirthCertificate : lst) {
			RestDogBirthCertificate vo = new RestDogBirthCertificate();
			BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
			vo.setBusinessState(dogBirthCertificateService.getBusinessState(dogBirthCertificate));
			vo.setUpperStatus(dogBirthCertificateService.getUpperStates(dogBirthCertificate));
			this.validateRefundState(dogBirthCertificate, vo);
			// APP端返回犬种中文名
			if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
				if (dogType != null) {
					vo.setBreedCnName(dogType.getBreedCnName());
				}
			}
			if (null != dogBirthCertificate.getSendDate()) {
				Calendar calendar = Calendar.getInstance();
				calendar.setTime(dogBirthCertificate.getSendDate());
				calendar.add(Calendar.DATE, DogActivationService.EXPIRE_DAY);
				vo.setActivitionEndDate(new Date(calendar.getTimeInMillis()));
			}
			list.add(vo);
		}
		return list;
	}

	public RESTResponse getList(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String dogBirthdayString = request.getParameter("dogBirthday");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		DogBirthCertificate example = new DogBirthCertificate();
		// 设置分页参数
		Page<DogBirthCertificate> page = new Page<DogBirthCertificate>();
		page.setIbatisPagePluginEnable(false);
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		// 把身为繁殖人的查询出来
		example.setBreederMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(birthCerRegCode)) {
			example.setBirthCerRegCode(birthCerRegCode);
		}
		// APP端根据出生日期查询
		if (StringUtils.isNotBlank(dogBirthdayString)) {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date dogBirthday;
			try {
				dogBirthday = sdf.parse(dogBirthdayString);
			} catch (ParseException e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期格式不对");
			}
			example.setDogBirthday(dogBirthday);
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		// 查询并组装返回对象
		Page<DogBirthCertificate> result = dogBirthCertificateService.findPage(page, example);
		List<DogBirthCertificate> dogBirthCertificateList = result.getList();

		long count = result.getCount();
		return new RESTResponse("list",
				new PageBeanResult<RestDogBirthCertificate>(getList(dogBirthCertificateList), count));
	}

	public RESTResponse getRandomName(HttpServletRequest request) {
		// 获取参数
		String maleNum = request.getParameter("maleNum");
		String femaleNum = request.getParameter("femaleNum");

		// 参数校验
		int male = 0;
		int female = 0;
		try {
			male = Integer.parseInt(maleNum);
			female = Integer.parseInt(femaleNum);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "同胎犬数必须都为数字");
		}

		// 获取数据
		List<DogName> list = dogBirthCertificateDao.getDogNames(male, female);

		// 封装数据返回
		return new RESTResponse("list", new PageBeanResult<DogName>(list, (long) list.size()));
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		JSONObject vo = JSONObject.fromObject(json);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		List<DogBirthCertificate> poList = buildPo(vo);
		// 业务校验
		dogBirthCertificateService.validateBusiness(poList);
		// 写入业务表
		for (DogBirthCertificate po : poList) {
			dogBirthCertificateService.save(po);
			// 记录鼻纹记录
			if (StringUtils.isNotBlank(po.getNoseId())) {
				// 重复的不阻断，只存对的，临时方案
				String flag = dogNoseService.saveNoseId(po.getNoseId(), po.getId(), null);
				if (flag == null) {
					logger.error("出错请求参数：" + json);
					logger.error("重复的noseId：" + po.getNoseId());
				}
			}
		}
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		PaymentCart dogBirthCertificatePaymentCart = buildDogBirthCertificatePaymentCart(poList, businessOrderCode);
		paymentCartService.addToCart(dogBirthCertificatePaymentCart, "1002");
		PaymentCart dogChipPaymentCart = buildDogChipPaymentCart(poList, businessOrderCode);
		paymentCartService.addToCart(dogChipPaymentCart, "1002");
		StringBuilder cartIds = new StringBuilder();
		cartIds.append(dogBirthCertificatePaymentCart.getId()).append(",").append(dogChipPaymentCart.getId());
		if (vo.get("secondBreederMemberCode") != null) {
			PaymentCart secondBreederPaymentCart = buildSecondBreederPaymentCart(poList, businessOrderCode);
			paymentCartService.addToCart(secondBreederPaymentCart, "1002");
			cartIds.append(",").append(secondBreederPaymentCart.getId());
		}
		// 优惠券
		if (vo.get("checkedCoupon") != null && StringUtils.isNotBlank(vo.getString("checkedCoupon"))) {
			RestCouponGroup checkedCoupon = BeanUtil.toBean(vo.getString("checkedCoupon"), RestCouponGroup.class);
			StringBuilder couponCartIds = buildCoupons(checkedCoupon, businessOrderCode, poList);
			cartIds.append(couponCartIds);
		}

		//// 第二繁殖人
		// if(vo.containsKey("secondBreederMemberCode")){
		// PaymentCart paymenSecondBreederCart = buildSecondBreederPaymentCart(poList,
		//// businessOrderCode);
		// paymentCartService.addToCart(paymenSecondBreederCart, "1002");
		// data += ","+paymenSecondBreederCart.getId();
		// }
		return new RESTResponse("data", cartIds.toString());
	}

	/**
	 * 构建优惠券
	 * 
	 * @param couponComposeId
	 * @param checkedList
	 * @param businessOrderCode
	 * @param poList
	 * @return
	 */
	public StringBuilder buildCoupons(RestCouponGroup checkedCoupon, String businessOrderCode,
			List<DogBirthCertificate> poList) {
		if (checkedCoupon.getUseNum() > poList.size())
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "所选优惠券不能大于申请只数，请重现选择！");
		if (checkedCoupon.getFacePrice() == null || checkedCoupon.getUseNum() <= 0)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券参数无效！");

		StringBuilder cartIds = new StringBuilder();
		Member member = UserUtils.getLoginMember();
		// 具体使用哪些优惠券
		SysCoupon example = new SysCoupon();
		example.setState("0");
		example.setMemberCode(member.getMemberCode());
		example.setTargetList(Arrays.asList(new String[] { ConstantUtils.COUPON_TARGET_DOGBIRTHCERTIFICATE }));
		example.setFacePrice(checkedCoupon.getFacePrice().toString());
		List<SysCoupon> list = sysCouponService.findList(example);
		if (list.size() == 0)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无此优惠券！");
		if (list.size() < checkedCoupon.getUseNum())
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券数量超过可用数量！");
		List<SysCoupon> usedList = list.stream()
				.sorted(Comparator.comparing(SysCoupon::getValidDate, Comparator.nullsLast(Comparator.naturalOrder())))
				.limit(checkedCoupon.getUseNum()).collect(Collectors.toList());
		// 处理优惠券 50 sys_coupon@birth 100 sys_coupon@dogBirthCertificate
		String shortName = "";
		if (checkedCoupon.getFacePrice().compareTo(BigDecimal.valueOf(50)) == 0)
			shortName = "sys_coupon@birth";
		else if (checkedCoupon.getFacePrice().compareTo(BigDecimal.valueOf(100)) == 0)
			shortName = "sys_coupon@dogBirthCertificate";
		else
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券没有收费项，暂时无法使用");
		PaymentCart paymentCouponCart = buildCouponPaymentCart(shortName, poList.get(0).getToken(),
				poList.get(0).getFmdogBreedCertifiedCode(), businessOrderCode, checkedCoupon.getUseNum());
		paymentCartService.addToCart(paymentCouponCart, "1002");
		cartIds.append(",").append(paymentCouponCart.getId());
		// 修改优惠券状态
		sysCouponService.buildUseCoupon(usedList, poList.get(0).getFmdogBreedCertifiedCode());

		return cartIds;
	}

	/**
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	public void validateParameter(JSONObject vo) {
		String fmdogBreedCertifiedCode = vo.getString("fmdogBreedCertifiedCode");
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号为空");
		}
		String dogBirthday = vo.getString("dogBirthday");
		if (StringUtils.isBlank(dogBirthday)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期为空");
		}
		try {
			new SimpleDateFormat("yyyy-MM-dd").parse(dogBirthday);
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期格式不对");
		}
		String urgent = vo.getString("urgent");
		if (StringUtils.isBlank(urgent)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态为空");
		}
		if (!"0".equals(urgent) && !"1".equals(urgent)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态只能为0，1");
		}
		JSONArray dogBirthCertificateArray = vo.getJSONArray("dogBirthCertificateArray");
		if (dogBirthCertificateArray == null || dogBirthCertificateArray.size() < 1) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬信息有误");
		}
		// 存储英文名
		List<String> dogEnNameList = new ArrayList<String>();
		for (int i = 0; i < dogBirthCertificateArray.size(); i++) {
			JSONObject dogBirthCertificate = dogBirthCertificateArray.getJSONObject(i);
			String dogGender = dogBirthCertificate.getString("dogGender");
			if (StringUtils.isBlank(dogGender)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬性别为空");
			}
			String dogEnName = dogBirthCertificate.getString("dogEnName");
			if (StringUtils.isBlank(dogEnName)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬英文名为空");
			}
			// 判断英文名是否重复
			if (!dogEnNameList.contains(dogEnName)) {
				dogEnNameList.add(dogEnName);
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只英文名重复，请修改后提交");
			}
			// 只能为英文字母和空格
			Pattern pattern = Pattern.compile("^[A-Za-z ]+$");
			Matcher matcher = pattern.matcher(dogEnName);
			if (!matcher.matches()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只姓名只能为英文字母和空格");
			}
			if (!dogBirthCertificate.containsKey("colorFlag")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请选择犬只毛色");
			}
			String colorFlag = dogBirthCertificate.getString("colorFlag");
			if (StringUtils.isBlank(colorFlag)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "毛色为空");
			}
			if (!"1".equals(dogGender) && !"2".equals(dogGender)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬性别只能为1，2");
			}
			if (dogBirthCertificate.has("callName")) {
				String callName = dogBirthCertificate.getString("callName");
				if (!StringUtils.isBlank(callName)) {
					demandSensitiveWordService.validCallName(callName);
				}
			}
		}
	}

	/**
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月14日 下午2:51:28
	 */
	private List<DogBirthCertificate> buildPo(JSONObject vo) {
		List<DogBirthCertificate> poList = new ArrayList<DogBirthCertificate>();
		String fmdogBreedCertifiedCode = vo.getString("fmdogBreedCertifiedCode");
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(fmdogBreedCertifiedCode);
		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号有误");
		}
		Member member = UserUtils.getLoginMember();
		Date dogBirthday = null;
		try {
			dogBirthday = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getString("dogBirthday"));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期格式不对");
		}
		String urgent = vo.getString("urgent");
		String cabPassportType = null;
		if (vo.get("cabPassportType") != null && StringUtils.isNotBlank(vo.getString("cabPassportType"))) {
			cabPassportType = vo.getString("cabPassportType");
		} else {
			cabPassportType = "0"; // 护照类型 0实体 1电子 默认实体
		}

		String ecertFlag = null;
		if (vo.containsKey("ecertFlag")) {
			// ecertFlag = vo.getString("ecertFlag");
		}
		PaymentChargingItem dogBirthCertificatePaymentChargingItem = getDogBirthCertificatePaymentChargingItem(
				dogNewborn, urgent, ecertFlag);
		PaymentChargingItem dogChipPaymentChargingItem = dogBirthCertificateService.getDogChipPaymentChargingItem();
		Double totalPrice = Double.parseDouble(dogBirthCertificatePaymentChargingItem.getPrice())
				+ Double.parseDouble(dogChipPaymentChargingItem.getPrice());
		String dog_kennelName = validateKennel(dogNewborn);
		// String token = vo.getString("token");
		JSONArray dogBirthCertificateArray = vo.getJSONArray("dogBirthCertificateArray");
		String sameBatchNum = getSameBatchNum(dogBirthCertificateArray);
		// 提交上来的优惠劵
		int num = 0;
		List<SysCoupon> sysCouponList = null;
		if (vo.containsKey("useCouponNum")) {
			String useCouponNum = vo.getString("useCouponNum");
			num = Integer.parseInt(useCouponNum);
			sysCouponList = sysCouponService.findCouponList(member.getMemberCode(), "0");
			if (num > 0 && num > sysCouponList.size()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "可用优惠劵不足");
			}
		}

		// add by zjw 增加优惠券均摊
		CouponDivideEquallyDto divideEqually = null;
		// 优惠券
		if (vo.containsKey("checkedCoupon") && StringUtils.isNotBlank(vo.getString("checkedCoupon"))) {
			RestCouponGroup checkedCoupon = BeanUtil.toBean(vo.getString("checkedCoupon"), RestCouponGroup.class);
			BigDecimal couponTotal = new BigDecimal(checkedCoupon.getUseNum()).multiply(checkedCoupon.getFacePrice().abs());
			divideEqually = CouponUtils.divideEqually(dogBirthCertificateArray.size(), couponTotal);
		}

		String secondBreederMemberCode = "";
		String secondBreeder = "";
		if (vo.get("secondBreederMemberCode") != null) {
			secondBreederMemberCode = vo.getString("secondBreederMemberCode");
			secondBreeder = vo.getString("secondBreeder");
		}
		for (int i = 0; i < dogBirthCertificateArray.size(); i++) {
			JSONObject dogBirthCertificate = dogBirthCertificateArray.getJSONObject(i);
			DogBirthCertificate po = new DogBirthCertificate();
			po.setEcertFlag(cabPassportType);
			po.setSnCode(RandomStringUtils.randomAlphanumeric(6).toUpperCase());
			po.setPaymentChargingItem(dogBirthCertificatePaymentChargingItem);
			po.setBirthCerRegCode(SysCodeUtil.getBirthCertificateCode());
			po.setDogGender(dogBirthCertificate.getString("dogGender"));
			// 设置犬名
			String dogEnName = dogBirthCertificate.getString("dogEnName");
			po.setDogEnName(dog_kennelName + " " + dogEnName.substring(0, 1).toUpperCase()
					+ dogEnName.substring(1).toLowerCase());
			po.setColorFlag(dogBirthCertificate.getString("colorFlag"));
			if (!dogTypeService.validateColorFlag(dogNewborn.getDogBreed(), po.getColorFlag())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬种没有毛色" + po.getColorFlag());
			}
			po.setDogBirthday(dogBirthday);
			po.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
			po.setFdogPedigreeCertified(dogNewborn.getMalePedigreeCertified());
			po.setMdogPedigreeCertified(dogNewborn.getFemalePedigreeCertified());
			// 以下都是母犬主人的信息
			po.setDogOwenr(dogNewborn.getFemaleDogOwner());
			po.setMemberCode(dogNewborn.getFdogOwnerCode());
			po.setBreeder(dogNewborn.getFemaleDogOwner());
			po.setBreederMemberCode(dogNewborn.getFdogOwnerCode());
			po.setSecondBreederMemberCode(secondBreederMemberCode);
			po.setSecondBreeder(secondBreeder);
			po.setTempUserName(dogNewborn.getFemaleDogOwner());
			po.setTempMemberCode(dogNewborn.getFdogOwnerCode());
			po.setDogBreed(dogNewborn.getDogBreed());
			po.setSameBatchNum(sameBatchNum);
			// 状态
			po.setUrgent(urgent);
			po.setReviewState("0");
			// add by zjw 增加优惠券均摊
			Double tmpTotalPrice = totalPrice;
			if (Objects.nonNull(divideEqually)) {
				if (i == dogBirthCertificateArray.size() - 1) {
					tmpTotalPrice = new BigDecimal(totalPrice).subtract(divideEqually.getRemainderAmount())
							.doubleValue();
				} else {
					tmpTotalPrice = new BigDecimal(totalPrice).subtract(divideEqually.getDivideEquallyAmount())
							.doubleValue();
				}
			}
			po.setPrice(tmpTotalPrice.toString());
			// 2016年5月19日改为只有协会打印
			po.setPrintType(dogNewborn.getPrintType());
			po.setPaymentState("1");
			// 生成随机6位数字或字母字符串
			// 2017年6月1日后不生成识别码
			// po.setSnCode("");
			po.setIsAll("0");
			// 申请日期与出生日期差小于两个月增加可抵扣标记，大于两个月增加不可抵扣标记，刚好两个月
			po.setDeduction(dogBirthCertificateService.getDeduction(dogBirthday));
			// po.setToken(token);
			// 白色柴犬禁止繁殖和赛事业务，20180601以后杜高犬禁止繁殖配种,允许赛事业务
			po.setBusinessBan(businessBanService.getBusinessBan(dogNewborn.getDogBreed(),
					dogBirthCertificate.getString("colorFlag"), dogBirthday));
			po.setShowBan(businessBanService.getShowBan(dogNewborn.getDogBreed(),
					dogBirthCertificate.getString("colorFlag"), dogBirthday));
			if ("1".equals(ecertFlag)) {
				po.setEcertFlag("1");
			}
			if (num > 0) {
				po.setCouponCode(sysCouponList.get(i).getCouponCode());
				num = num - 1;
			}
			if (dogBirthCertificate.get("noseId") != null) {
				po.setNoseId(dogBirthCertificate.getString("noseId"));
			}
			// 2020-05-01起犬只办理登记卡默认激活
			po.setActivitionState("1");
			poList.add(po);
		}
		return poList;
	}

	// /**
	// *
	// * @description: 获取出生纸费用
	// * @author: laiguanglong
	// * @date: 2016年8月17日 上午10:22:21
	// */
	// private String getPrice(DogNewborn dogNewborn, String urgent) {
	// String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
	// if ("230".equals(dogNewborn.getDogBreed())) {
	// shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
	// }
	// // 根据支付项查询金额
	// PaymentChargingItem paymentChargingItem = paymentChargingItemService
	// .getByShortName(shortName);
	// Double price = Double.valueOf(paymentChargingItem.getPrice());
	// // 加急加收30%的费用,犬舍联盟的加急免收30%
	// if
	// ("1".equals(urgent)&&!kennelAllianceService.isUrgentFree(dogNewborn.getFdogOwnerCode()))
	// {
	// price = price * 1.3;
	// }
	// return price.toString();
	// }

	/**
	 * @description: 验证犬舍、获取犬舍名
	 * @author: laiguanglong
	 * @date: 2016年8月17日 上午11:20:16
	 */
	public String validateKennel(DogNewborn dogNewborn) throws ZAException {
		Kennel kennel = kennelService.getKennelByMemberCode(dogNewborn.getFdogOwnerCode());
		if (kennel == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬主所属的犬舍信息不存在");
		}
		// if(!"1".equals(kennel.getPaymentState())){
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"母犬主所属的犬舍未缴费");
		// }
		if (StringUtils.isBlank(kennel.getNameEn())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍英文名错误，请联系CKU会员部");
		}
		String dog_kennelName = kennel.getNameEn().replace("'s", "").replace("’s", "");
		dog_kennelName = dog_kennelName.replace("（FCI）", "").replace("（审核中）", "").replace("（待审核）", "");
		dog_kennelName = dog_kennelName.replace("待审核", "").replace("（不能繁殖）", "").replace("（FCI不能繁殖）", "");
		dog_kennelName = dog_kennelName.replace("（FCI不能作繁殖）", "").replace("Kennel", "");
		return dog_kennelName;
	}

	/**
	 * 计算月龄
	 *
	 * @param date
	 * @param birthdate
	 * @return
	 */
	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH) - birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}

	/**
	 * @description: 获取同胎犬数格式为 x公y母
	 * @author: laiguanglong
	 * @date: 2016年8月16日 下午6:39:29
	 */
	public String getSameBatchNum(JSONArray dogBirthCertificateArray) throws ZAException {
		if (dogBirthCertificateArray.size() == 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请新生犬登记卡数不能为0");
		}
		int male = 0;
		int female = 0;
		for (int i = 0; i < dogBirthCertificateArray.size(); i++) {
			JSONObject dogBirthCertificate = dogBirthCertificateArray.getJSONObject(i);
			if ("1".equals(dogBirthCertificate.getString("dogGender"))) {
				male++;
			} else if ("2".equals(dogBirthCertificate.getString("dogGender"))) {
				female++;
			}
		}
		return male + "公" + female + "母";
	}

	/**
	 * @description: 构造出生纸购物车收费项
	 * @author: laiguanglong
	 * @date: 2017/5/19 17:21
	 */
	private PaymentCart buildDogBirthCertificatePaymentCart(List<DogBirthCertificate> poList,
			String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = poList.get(0).getPaymentChargingItem();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum(poList.size() + "");
		String price = paymentChargingItem.getPrice();
		paymentCart.setPrice(price);
		double priceDouble = Double.parseDouble(price);
		paymentCart.setTotalPrice(priceDouble * poList.size() + "");
		paymentCart.setBusinessTable("dog_birth_certificate");
		paymentCart.setBusinessIds(poList.get(0).getFmdogBreedCertifiedCode());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setToken(poList.get(0).getToken());
		return paymentCartService.addBusinessManage(paymentCart, "1002");
	}

	/**
	 * 构造第二繁殖人购物车收费项
	 * 
	 * @param poList
	 * @param businessOrderCode
	 * @return
	 */
	private PaymentCart buildSecondBreederPaymentCart(List<DogBirthCertificate> poList, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = dogBirthCertificateService.getSecondBreederPaymentChargingItem();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum(Constants.STRING_NUM_ONE);
		String price = paymentChargingItem.getPrice();
		paymentCart.setPrice(price);
		double priceDouble = Double.parseDouble(price);
		paymentCart.setTotalPrice(String.valueOf(priceDouble));
		paymentCart.setBusinessTable("dog_birth_certificate");
		paymentCart.setBusinessIds(poList.get(0).getFmdogBreedCertifiedCode());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setToken(poList.get(0).getToken());
		return paymentCartService.addBusinessManage(paymentCart, "1002");
	}

	/**
	 * @description: 构造芯片收费项
	 * @author: laiguanglong
	 * @date: 2017/5/19 17:21
	 */
	private PaymentCart buildDogChipPaymentCart(List<DogBirthCertificate> poList, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = dogBirthCertificateService.getDogChipPaymentChargingItem();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum(poList.size() + "");
		String price = paymentChargingItem.getPrice();
		paymentCart.setPrice(price);
		double priceDouble = Double.parseDouble(price);
		paymentCart.setTotalPrice(priceDouble * poList.size() + "");
		paymentCart.setBusinessTable("dog_birth_certificate");
		paymentCart.setBusinessIds(poList.get(0).getFmdogBreedCertifiedCode());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setToken(poList.get(0).getToken());
		return paymentCartService.addBusinessManage(paymentCart, "1002");
	}

	/**
	 * 构造优惠劵收费项
	 */
	private PaymentCart buildCouponPaymentCart(String shortName, String token, String fmdogBreedCertifiedCode,
			String businessOrderCode, int num) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		if (paymentChargingItem == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券没有收费项，暂时无法使用");
		}
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum(num + "");
		String price = paymentChargingItem.getPrice();
		paymentCart.setPrice(price);
		double priceDouble = Double.parseDouble(price);
		paymentCart.setTotalPrice(priceDouble * num + "");
		paymentCart.setBusinessTable("sys_coupon");
		paymentCart.setBusinessIds(fmdogBreedCertifiedCode);
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setToken(token);
		paymentCart.setCouponNum(num + "");
		return paymentCart;
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		String ecertFlag = null;
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号为空");
		}
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(fmdogBreedCertifiedCode);
		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号有误");
		}
		String urgent = request.getParameter("urgent");
		if (StringUtils.isBlank(urgent)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态为空");
		}
		String num = request.getParameter("num");
		if (StringUtils.isBlank(urgent)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡申请数为空");
		}
		Integer numInteger = null;
		try {
			numInteger = Integer.valueOf(num);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡申请数必须为整数");
		}
		// 获取价格
		PaymentChargingItem dogBirthCertificatePaymentChargingItem = getDogBirthCertificatePaymentChargingItem(
				dogNewborn, urgent, ecertFlag);
		Double dogBirthCertificatePriceDouble = Double.valueOf(dogBirthCertificatePaymentChargingItem.getPrice());
		PaymentChargingItem dogChipPaymentChargingItem = dogBirthCertificateService.getDogChipPaymentChargingItem();
		Double dogChipPriceDouble = Double.valueOf(dogChipPaymentChargingItem.getPrice());
		Double totalPrice = (dogBirthCertificatePriceDouble + dogChipPriceDouble) * numInteger;
		JSONObject jo = new JSONObject();
		jo.put("price", String.format("%.2f", totalPrice));
		return new RESTResponse("data", jo);
	}

	/**
	 * @Description：根据父母犬配种证明编号查询该配种证明下出生纸信息
	 * @author: zhuoHeng
	 * @version: 2016年11月9日 下午3:15:04
	 */
	public RESTResponse getByBreedCertifiedCode(HttpServletRequest request) {
		// 获取参数
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		// 参数校验
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明编号为空");
		}
		// 查询并组装返回对象
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao
				.findByFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
		List<RestDogBirthCertificate> list = new ArrayList<RestDogBirthCertificate>();
		for (DogBirthCertificate dogBirthCertificate : dogBirthCertificateList) {
			RestDogBirthCertificate vo = new RestDogBirthCertificate();
			BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
			vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(), "dog_gender", ""));
			if (StringUtils.isNotBlank(vo.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
				String breedCnName = "";
				if (dogType == null) {
					breedCnName = dogTypeService.getUnMapBreedCnName(vo.getDogBreed());
				} else {
					breedCnName = dogType.getBreedCnName();
				}
				vo.setDogBreedName(breedCnName);
			}
			list.add(vo);
		}
		long count = dogBirthCertificateList.size();
		return new RESTResponse("list", new PageBeanResult<RestDogBirthCertificate>(list, count));
	}

	// 2020-08-14
	public boolean isDnaParentsCompareNew(String fatherDogId, String motherDogId, String breedCertifiedCode) {
		boolean flag = false;
		if (isHaveDogDnaNew(fatherDogId) && isHaveDogDnaNew(motherDogId)) {
			flag = true;
		}
		if (!flag && StringUtils.isNotBlank(breedCertifiedCode)) {
			DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(breedCertifiedCode);
			if (dogNewborn != null) {
				// 使用冷冻精子进行配种的要可以选双亲比对
				if (StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
					flag = true;
				}
			}
		}
		return flag;
	}

	public boolean isDnaParentsCompareNewCheck(String fatherDogId, String motherDogId, String breedCertifiedCode) {
		boolean flag = false;
		if (isHaveDogDnaNew(fatherDogId) && isHaveDogDnaNew(motherDogId)) {
			flag = true;
		}
		return flag;
	}

	// 2020-08-14
	public boolean isHaveDogDnaNew(String dogId) {
		DogDna dogDna = dogDnaDao.getByDogId(dogId);
		if (dogDna != null && StringUtils.isNotBlank(dogDna.getDnaCode())) {
			return true;
		} else {
			DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getDnaMsg(dogId);
			if (dogDnaArchive != null && StringUtils.isNotBlank(dogDnaArchive.getDnaCode())) {
				return true;
			}
		}
		return false;
	}

	/**
	 * @description: 是否能选择双亲比对，返回true表示可以
	 * @author: laiguanglong
	 * @date: 2016/11/29 11:10
	 */
	public boolean isDnaParentsCompare(String fatherDogId, String motherDogId, String breedCertifiedCode) {
		boolean flag = false;
		if (dogDnaService.isHaveDogDna(fatherDogId) && dogDnaService.isHaveDogDna(motherDogId)) {
			flag = true;
		}
		if (!flag && StringUtils.isNotBlank(breedCertifiedCode)) {
			DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(breedCertifiedCode);
			if (dogNewborn != null) {
				// 使用冷冻精子进行配种的要可以选双亲比对
				if (StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
					flag = true;
				}
			}
		}
		return flag;
	}

	public boolean isDnaParentsCheck(String breedCertifiedCode) {
		boolean flag = false;
		if (StringUtils.isNotBlank(breedCertifiedCode)) {
			DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(breedCertifiedCode);
			if (dogNewborn != null) {
				// 使用冷冻精子进行配种的要可以选双亲比对
				if (StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
					flag = true;
				}
			}
		}
		return flag;
	}

	/**
	 * @description: DNA留存方式是否默认为位点分析，返回true表示是
	 * @author: laiguanglong
	 * @date: 2016/11/29 11:10
	 */
	public boolean isDnaArchive(DogBirthCertificate dogBirthCertificate) {
		boolean flag = false;
		// 配种证明近亲繁殖取DNA字段时，DNA留存方式默认为位点分析
		DogNewborn dogNewborn = dogNewbornService
				.getBybreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		if (dogNewborn != null) {
			if ("1".equals(dogNewborn.getKinGetDna())) {
				return true;
			}
			// 一岁到两岁之前的犬只申请时,DNA留存方式默认为位点分析（不能修改）
			if (!DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
				return true;
			}
			// 使用冷冻精子进行配种的要默认为位点分析
			if (StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
				return true;
			}
		}
		return flag;
	}

	/**
	 * @description: 获取出生纸收费项
	 * @author: laiguanglong
	 * @date: 2016/12/30 10:50
	 */
	private PaymentChargingItem getDogBirthCertificatePaymentChargingItem(DogNewborn dogNewborn, String urgent,
			String ecertFlag) {
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dogNewborn.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		// 根据支付项查询金额
		PaymentChargingItem paymentChargingItem = dogBirthCertificateService
				.getDogBirthCertificatePaymentChargingItem();
		// 加急加收30%的费用,犬舍联盟的加急免收30%
		if ("1".equals(urgent) && !kennelAllianceService.isUrgentFree(dogNewborn.getFdogOwnerCode())
				&& !tcbKennelService.isUrgentFree(dogNewborn.getFdogOwnerCode())) {
			Double price = Double.valueOf(paymentChargingItem.getPrice()) * 1.3;
			paymentChargingItem.setPrice(price.toString());
		}
		// 出生纸电子化优惠10
		if ("1".equals(ecertFlag)) {
			Double price = Double.valueOf(paymentChargingItem.getPrice()) - ECERT_DISCOUNTS;
			paymentChargingItem.setPrice(price.toString());
		}
		return paymentChargingItem;
	}

	/**
	 * @description: 幼犬出生日期校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	public RESTResponse checkDogBirthday1(HttpServletRequest request) {
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		String dogBirthday = request.getParameter("dogBirthday");
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "配种证明号为空");
		}
		if (StringUtils.isBlank(dogBirthday)) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "幼犬出生日期为空");
		}
		Date dogBirthdayDate = null;
		try {
			dogBirthdayDate = new SimpleDateFormat("yyyy-MM-dd").parse(dogBirthday);
		} catch (ParseException e) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "幼犬出生日期格式不对");
		}
		if (System.currentTimeMillis() < dogBirthdayDate.getTime()) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "幼犬出生日期不能大于今天");
		}
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(fmdogBreedCertifiedCode);
		boolean flag1 = dogBirthCertificateService.checkDogBirthday(dogBirthdayDate, dogNewborn);
		if (!flag1) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "犬只出生日期必须为配种后50-70天内");
		}
		boolean flag2 = dogBirthCertificateService.checkDogBirthday1(dogBirthdayDate, new Date());
		if (!flag2) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡申请需在犬只出生十四个月内申请");
		}
		return new RESTResponse();

	}

	/**
	 * @description: 幼犬出生日期校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	public RESTResponse checkDogBirthday(HttpServletRequest request) {
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		String dogBirthday = request.getParameter("dogBirthday");
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号为空");
		}
		if (StringUtils.isBlank(dogBirthday)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "幼犬出生日期为空");
		}
		Date dogBirthdayDate = null;
		try {
			dogBirthdayDate = new SimpleDateFormat("yyyy-MM-dd").parse(dogBirthday);
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "幼犬出生日期格式不对");
		}
		if (System.currentTimeMillis() < dogBirthdayDate.getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "幼犬出生日期不能大于今天");
		}
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(fmdogBreedCertifiedCode);
		boolean flag = true;
		StringBuilder sb = new StringBuilder();
		boolean flag1 = dogBirthCertificateService.checkDogBirthday(dogBirthdayDate, dogNewborn);
		boolean flag2 = dogBirthCertificateService.checkDogBirthday(dogBirthdayDate, new Date());
		if (!flag1) {
			flag = false;
			sb.append("犬只出生日期必须为配种后50-70天内");
		}
		if (!flag2) {
			flag = false;
			if (sb.length() > 0) {
				sb.append(",");
			}
			sb.append("新生犬登记卡申请需在犬只出生四个月内申请");
		}
		JSONObject jo = new JSONObject();
		jo.put("rc", flag);
		jo.put("msg", sb.toString());
		return new RESTResponse("data", jo);

	}

	/**
	 * @description: 同胞犬数校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	public RESTResponse checkSameBatchNum(HttpServletRequest request) {
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		String maleNum = request.getParameter("maleNum");
		String femaleNum = request.getParameter("femaleNum");
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号为空");
		}
		Integer maleInteger = null;
		Integer femaleInteger = null;
		try {
			maleInteger = Integer.valueOf(maleNum);
			femaleInteger = Integer.valueOf(femaleNum);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "同胞犬数必须为整数");
		}
		int sameBatchNum = maleInteger + femaleInteger;
		if (sameBatchNum == 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "同胞犬数和不能为0");
		}
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(fmdogBreedCertifiedCode);
		DogType dogType = dogTypeDao.getByDogBreedCode(dogNewborn.getDogBreed());
		boolean flag = true;
		String msg = "";
		if (Integer.parseInt(dogType.getBatchMaxNum()) < sameBatchNum) {
			flag = false;
			msg = "您申请的犬只数量超过申请上限，需联系协会线下提交申请";
		}
		JSONObject jo = new JSONObject();
		jo.put("rc", flag);
		jo.put("msg", msg);
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 获取是否能免加急费标记位，返回true表示可以免
	 * @author: laiguanglong
	 * @date: 2017/5/19 13:57
	 */
	public RESTResponse getUrgentFreeFlag() {
		boolean urgentFreeFlag = false;
		String msg = "";
		Member member = UserUtils.getLoginMember();
		if (kennelAllianceService.isUrgentFree(member.getMemberCode())) {
			urgentFreeFlag = true;
			msg = "优生繁育犬舍，减免加急费";
		} else if (tcbKennelService.isUrgentFree(member.getMemberCode())) {
			urgentFreeFlag = true;
			msg = "淘宠犬舍，减免加急费";
		}
		JSONObject jo = new JSONObject();
		jo.put("urgentFreeFlag", urgentFreeFlag);
		jo.put("msg", msg);
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 会员犬舍是否有效校验，返回true表示有效
	 * @author: laiguanglong
	 * @date: 2017/5/19 13:57
	 */
	public RESTResponse checkMemberKennel() {
		boolean memberKennelFlag = true;
		String msg = "";
		Member member = UserUtils.getLoginMember();
		Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
		if (!MemberUtil.isActiveMember(member)) {
			memberKennelFlag = false;
			msg = "您当前的会员无效";
		} else if (kennel == null) {
			memberKennelFlag = false;
			msg = "您还没有申请犬舍";
		} else if (kennel != null && (kennel.getEndTime() == null
				|| (kennel.getEndTime().getTime() + 86399000) < System.currentTimeMillis())) {
			memberKennelFlag = false;
			msg = "您的犬舍无效";
		}
		JSONObject jo = new JSONObject();
		jo.put("memberKennelFlag", memberKennelFlag);
		jo.put("msg", msg);
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 犬名校验校验
	 * @author: laiguanglong
	 * @date: 2017/5/19 13:57
	 */
	public RESTResponse checkDogName(HttpServletRequest request) {
		String dogEnNameString = request.getParameter("dogEnName");
		if (StringUtils.isBlank(dogEnNameString)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬名为空");
		}
		String[] dogEnNameArray = dogEnNameString.split(",");
		List<String> dogEnNameList = new ArrayList<String>();
		for (String dogEnName : dogEnNameArray) {
			if (StringUtils.isBlank(dogEnName)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬英文名为空");
			}
			// 判断英文名是否重复
			if (!dogEnNameList.contains(dogEnName)) {
				dogEnNameList.add(dogEnName);
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只英文名重复，请修改后提交");
			}
			// 只能为英文字母和空格
			Pattern pattern = Pattern.compile("^[A-Za-z ]+$");
			Matcher matcher = pattern.matcher(dogEnName);
			if (!matcher.matches()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只姓名只能为英文字母和空格");
			}
		}
		return new RESTResponse();
	}

	/**
	 * @description: 设置犬只年龄信息 dogAge格式为n年n月，12个月显示为1年
	 *               dogAgeFlag为犬只年龄标记位。犬龄<12个月，值为0；犬龄>=12个月，值为1；犬龄为2岁，值为2
	 * @author: laiguanglong
	 * @date: 2017/5/23 14:29
	 */
	private void setDogAgeInfo(DogBirthCertificate po, RestDogBirthCertificate vo) {
		StringBuilder dogAge = new StringBuilder();
		int monthAge = getMonthAge(new Date(), po.getDogBirthday());
		if (monthAge / 12 > 0) {
			dogAge.append(monthAge / 12).append("年");
			if (monthAge % 12 != 0) {
				dogAge.append(monthAge % 12).append("月");
			}
		} else {
			dogAge.append(monthAge % 12).append("月");
		}
		vo.setDogAge(dogAge.toString());
		String dogAgeFlag = "";
		if (DateUtils.isInXMounth(po.getDogBirthday(), 12)) {
			dogAgeFlag = "0";
		} else if (DateUtils.isInXMounth(po.getDogBirthday(), 24)) {
			dogAgeFlag = "1";
		} else {
			dogAgeFlag = "2";
		}
		vo.setDogAgeFlag(dogAgeFlag);
	}

	/**
	 * 根据芯片号 检查是否有宠爱登记卡号 或者早先的登记卡号
	 *
	 * @param request
	 * @return
	 */

	public RESTResponse checkSnCodeByIdentificationFlag(HttpServletRequest request) {
		String result = "false";
		// 获取参数
		String identificationFlag = request.getParameter("identificationFlag");
		// 参数校验
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空。");
		}

		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(identificationFlag);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号有误，没有相应的记录。");
		}

		// String birthCerRegCode = dogBirthCertificate.getBirthCerRegCode();//出生证明登记编号
		String cabRegisterCode = dogBirthCertificate.getCabRegisterCode();// 宠爱登记卡号

		if (StringUtils.isNoneBlank(cabRegisterCode)) {
			result = "true";
		}
		return new RESTResponse("cabCode", result);
	}

	public RESTResponse getBySnCodeOrIdentificationFlag(HttpServletRequest request) {
		// 获取参数
		String identificationFlag = request.getParameter("identificationFlag");
		String snCode = request.getParameter("snCode");
		String snCodeType = request.getParameter("snCodeType");
		String msg = "";
		// 参数校验
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		if (StringUtils.isBlank(snCode)) {
			if ("cabRegisterCode".equals(snCodeType)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠爱登记卡号为空");
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡号为空");
			}

		}
		// DogBirthCertificate dogBirthCertificate;
		// RestDogBirthCertificate vo = null;

		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(identificationFlag);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号有误，没有相应的记录。");
		}

		String birthCerRegCode = dogBirthCertificate.getBirthCerRegCode();// 出生证明登记编号
		String cabRegisterCode = dogBirthCertificate.getCabRegisterCode();// 宠爱登记卡号

		if ("cabRegisterCode".equals(snCodeType)) {
			if (snCode.equals(cabRegisterCode)) {
				msg = "恭喜您,您所查询的登记卡信息是真实有效的,欢迎您继续申请办理CKU的《纯血犬血统证书》,通过CKU颁发的《纯血犬血统证书》认证爱犬的血统价值,获得血统谱系信息。";
			} else {
				msg = "没有符合条件的查询结果!";
			}
		} else {
			if (snCode.equals(birthCerRegCode)) {
				msg = "恭喜您,您所查询的登记卡信息是真实有效的,欢迎您继续申请办理CKU的《纯血犬血统证书》,通过CKU颁发的《纯血犬血统证书》认证爱犬的血统价值,获得血统谱系信息。";
			} else {
				msg = "没有符合条件的查询结果!";
			}
		}

		// DogBirthCertificate example = new DogBirthCertificate();
		// example.setBirthCerRegCode(birthCerRegCode);
		// example.setSnCode(snCode);
		// example.setDelFlag("0");

		// List<DogBirthCertificate> dogBirthCertificateList =
		// dogBirthCertificateDao.findList(example);
		// if (dogBirthCertificateList.size() > 0) {
		/// * vo = new RestDogBirthCertificate();
		// dogBirthCertificate = dogBirthCertificateList.get(0);*/
		// msg =
		// "恭喜您,您所查询的登记卡信息是真实有效的,欢迎您继续申请办理CKU的《纯血犬血统证书》,通过CKU颁发的《纯血犬血统证书》认证爱犬的血统价值,获得血统谱系信息。";
		// } else {
		// example.setSnCode(null);
		// example.setIdentificationFlag(snCode);
		// dogBirthCertificateList = dogBirthCertificateDao.findList(example);
		// if (dogBirthCertificateList.size() > 0) {
		// /* vo = new RestDogBirthCertificate();
		// dogBirthCertificate = dogBirthCertificateList.get(0);*/
		// msg =
		// "恭喜您,您所查询的登记卡信息是真实有效的,欢迎您继续申请办理CKU的《纯血犬血统证书》,通过CKU颁发的《纯血犬血统证书》认证爱犬的血统价值,获得血统谱系信息。";
		// }else{
		// msg = "没有符合条件的查询结果!";
		// //return new RESTResponse("data", vo);
		// }
		// }
		// BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
		// 以下是CKU官网所需字段
		/*
		 * Dog fdog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.
		 * getFdogPedigreeCertified(),true); Dog mdog =
		 * dogService.getByPedigreeCertifiedCode(dogBirthCertificate.
		 * getMdogPedigreeCertified(),true); vo.setFdogName(fdog.getNameEn());
		 * vo.setMdogName(mdog.getNameEn());
		 * vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(), "dog_gender",""));
		 * if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) { DogType
		 * dogType =
		 * dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		 * vo.setDogBreedName(dogType.getBreedCnName()); }
		 */
		// return new RESTResponse("data", JSONObject.fromObject(vo));
		return new RESTResponse("data", msg);
	}

	public RESTResponse getBySnCodeOrIdentificationFlagOld(HttpServletRequest request) {
		// 获取参数
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String snCode = request.getParameter("snCode");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		// 参数校验
		if (StringUtils.isBlank(birthCerRegCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
		}
		if (StringUtils.isBlank(snCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "识别码或芯片号为空");
		}
		DogBirthCertificate dogBirthCertificate = null;
		RestDogBirthCertificate vo = null;

		DogBirthCertificate example = new DogBirthCertificate();
		example.setBirthCerRegCode(birthCerRegCode);
		example.setSnCode(snCode);
		example.setDelFlag("0");
		String msg = "";
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findList(example);
		if (dogBirthCertificateList.size() > 0) {
			/*
			 * vo = new RestDogBirthCertificate();
			 */
			dogBirthCertificate = dogBirthCertificateList.get(0);
			msg = "恭喜您,您所查询的登记卡信息是真实有效的,欢迎您继续申请办理CKU的《纯血犬血统证书》,通过CKU颁发的《纯血犬血统证书》认证爱犬的血统价值,获得血统谱系信息。";
		} else {
			DogBirthCertificate example1 = new DogBirthCertificate();
			example1.setBirthCerRegCode(birthCerRegCode);
			example1.setDelFlag("0");
			example1.setIdentificationFlag(snCode);
			dogBirthCertificateList = dogBirthCertificateDao.findList(example1);
			if (dogBirthCertificateList.size() > 0) {
				/*
				 * vo = new RestDogBirthCertificate();
				 */
				dogBirthCertificate = dogBirthCertificateList.get(0);
				msg = "恭喜您,您所查询的登记卡信息是真实有效的,欢迎您继续申请办理CKU的《纯血犬血统证书》,通过CKU颁发的《纯血犬血统证书》认证爱犬的血统价值,获得血统谱系信息。";
			} else {
				msg = "没有符合条件的查询结果!";
				// return new RESTResponse("data", vo);
			}
		}
		if ("ckumc".equals(source) && dogBirthCertificate != null && !"15C".equals(dogBirthCertificate.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询犬只非玛犬！");
		}

		// BeanUtil.copyProperties(vo, dogBirthCertificate, "yyyy-MM-dd");
		// 以下是CKU官网所需字段
		/*
		 * Dog fdog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.
		 * getFdogPedigreeCertified(),true); Dog mdog =
		 * dogService.getByPedigreeCertifiedCode(dogBirthCertificate.
		 * getMdogPedigreeCertified(),true); vo.setFdogName(fdog.getNameEn());
		 * vo.setMdogName(mdog.getNameEn());
		 * vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(), "dog_gender",""));
		 * if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) { DogType
		 * dogType =
		 * dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		 * vo.setDogBreedName(dogType.getBreedCnName()); }
		 */
		// return new RESTResponse("data", JSONObject.fromObject(vo));
		return new RESTResponse("data", msg);
	}

	// @Transactional(readOnly = false)
	@Transactional(rollbackFor = Exception.class)
	public RESTResponse addDogNose(String json) {
		Member loginMember = UserUtils.getLoginMember();
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("birthCerRegCode") || jo.getString("birthCerRegCode") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡号为空");
		}
		if (!jo.containsKey("noseId") || jo.getString("noseId") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "noseId为空");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
				.getByBirthCerRegCode(jo.getString("birthCerRegCode"));

		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡号不正确");
		}
		String flag = dogNoseService.saveNoseId(jo.getString("noseId"), dogBirthCertificate.getId(), null);
		if (flag == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "鼻纹标识与库中信息重复！");
		}
		DogChip dogChip = dogChipService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogChip != null) {
			dogChipService.createBirthCode(dogChip.getId());
		}
		return new RESTResponse();
	}

	public void checkSecondBreeder(String secondBreederMemberCode) {
		if (StringUtils.isBlank(secondBreederMemberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人会员号为空");
		}
		Member member = memberService.getByMemberCode(secondBreederMemberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号码有误，请输入正确会员号");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人需为有效爱宠银卡及以上会员办理!");
		}
		if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(secondBreederMemberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人需为有效爱宠银卡及以上会员办理！");
		}
	}

	/**
	 * 获得价格
	 * 
	 * @param urgent          是否加急
	 * @param ecertFlag       是否电子版
	 * @param fdogOwnerCode   母犬主人会员号
	 * @param num             狗的数量
	 * @param couponComposeId 购买券包id
	 * @param checkedList     选中的券
	 * @return
	 * @throws Exception
	 */
	public Double getPrice(RestDogBirthCertificatePostVO postVO) throws Exception {
		if (postVO.getDogBirthCertificateArray() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只列表不能为空！");
		}
		int num = postVO.getDogBirthCertificateArray().size();// 购买只数
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(postVO.getFmdogBreedCertifiedCode());
		String fdogOwnerCode = dogNewborn.getFdogOwnerCode();// 母犬犬主人
		Member member = UserUtils.getLoginMember();
		Double price = Double.valueOf(0);
		// 芯片收费项
		PaymentChargingItem dogChipPaymentChargingItem = dogBirthCertificateService.getDogChipPaymentChargingItem();
		price += Double.valueOf(dogChipPaymentChargingItem.getPrice());
		// 出生纸收费项
		PaymentChargingItem dogBirthCertificatePaymentChargingItem = dogBirthCertificateService
				.getDogBirthCertificatePaymentChargingItem();
		// 加急加收30%的费用,犬舍联盟的加急免收30%
		Double dogBirthCertificatePrice = Double.valueOf(dogBirthCertificatePaymentChargingItem.getPrice());
		if (1 == postVO.getUrgent() && !kennelAllianceService.isUrgentFree(fdogOwnerCode)
				&& !tcbKennelService.isUrgentFree(fdogOwnerCode)) {
			dogBirthCertificatePrice = dogBirthCertificatePrice * 1.3;
		}
		// 出生纸电子化优惠10
		if ("1".equals(postVO.getEcertFlag())) {
			dogBirthCertificatePrice = dogBirthCertificatePrice - ECERT_DISCOUNTS;
		}
		price += dogBirthCertificatePrice;
		Double totalPrice = price * num;
		// 优惠券抵扣金额
		if (postVO.getCheckedCoupon() != null) {
			if (postVO.getCheckedCoupon().getUseNum() > num)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "所选优惠券不能大于申请只数，请重现选择！");
			if (postVO.getCheckedCoupon().getFacePrice() == null || postVO.getCheckedCoupon().getUseNum() <= 0)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券参数无效！");
			SysCoupon example = new SysCoupon();
			example.setState("0");
			example.setMemberCode(member.getMemberCode());
			example.setTargetList(Arrays.asList(new String[] { ConstantUtils.COUPON_TARGET_DOGBIRTHCERTIFICATE }));
			example.setFacePrice(postVO.getCheckedCoupon().getFacePrice().toString());
			List<SysCoupon> list = sysCouponService.findList(example);
			if (list.size() == 0)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无此优惠券！");
			if (list.size() < postVO.getCheckedCoupon().getUseNum())
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券数量超过可用数量！");
			totalPrice -= (postVO.getCheckedCoupon().getFacePrice().compareTo(new BigDecimal(price)) == 1
					? new BigDecimal(price)
					: postVO.getCheckedCoupon().getFacePrice())
					.multiply(BigDecimal.valueOf(postVO.getCheckedCoupon().getUseNum())).doubleValue();
		}
		if (StringUtils.isNotBlank(postVO.getSecondBreederMemberCode())) {
			PaymentChargingItem secondBreederPaymentCharging = paymentChargingItemService.getByShortName(SECOND_BREEDER);
			if (Objects.nonNull(secondBreederPaymentCharging)) {
				totalPrice += Double.parseDouble(secondBreederPaymentCharging.getPrice());
			}
		}
		return totalPrice;
	}

}