package com.cku.restful.v1.dog.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.restful.v1.dog.model.CkuShowsResults;
import com.cku.util.Debugger;

@Service
@Transactional(readOnly = true)
public class CkuShowsResultsService {

	@Autowired
	public ShowResultsDao showResultsDao;
	
	public List<CkuShowsResults> getShowsResult(String pedigreeCertifiedCode, Integer pageNo, Integer pageSize,
			String ageGroup, String annual) {
		if(pageNo!=null && pageSize!=null){
			Debugger.doAssert(pageNo>0, ZAErrorCode.ZA_ERC_PARAM_ERROR, "起始页数应大于0");
			Debugger.doAssert(pageSize>0, ZAErrorCode.ZA_ERC_PARAM_ERROR, "每页展示条数应大于0");
			pageNo = (pageNo-1)*pageSize;
		}
		List<CkuShowsResults> list = showResultsDao.getShowsResult(pedigreeCertifiedCode,pageNo,pageSize,ageGroup,annual);
		return list;
	}

	
}
