/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.web;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageBeanResult;
import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.restful.v1.breeder.model.IEnumDogBirthCertificate;
import com.cku.restful.v1.breeder.service.BreederDogBirthCertificateService;
import com.cku.restful.v1.dog.vo.RestDogBirthCertificatePostVO;
import com.cku.restful.v1.sys.model.RestCouponGroup;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONObject;

/**
 * 出生证明Controller
 *
 * @author lgl
 * @version 2016-08-04
 */
@Controller
@Api(tags = "APP登记卡接口")
@RequestMapping(value = "/api/v1/breeder/dog/birthcertificate")
public class BreederDogBirthCertificateController extends BaseRestController {

	@Autowired
	private BreederDogBirthCertificateService service;
	@Autowired
	private DogActivationService dogActivationService;

	@RequestMapping(value = "", method = RequestMethod.POST)
	public void post(@RequestBody String json, HttpServletResponse response, HttpServletRequest request)
			throws IOException {
		ServletUtils.writeResponse(response, service.post(json, request));
	}

	@RequestMapping(value = "/order/{id}", method = RequestMethod.GET)
	public void order(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.order(id));
	}

	@ApiOperation(value = "繁育幼犬登记卡-列表", tags = { "新生犬登记卡-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "number", value = "配种证明编号-模糊查询使用"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"list\":[\n" + "        {\n" + "            \"id\":\"d19557c3f21c4f97aa89c6ca5123e0be\",\n"
			+ "            \"breedCertifiedCode\":\"200322218401\",\n"
			+ "            \"malePedigreeCertified\":\"CKU-111007903/11\",\n"
			+ "            \"femalePedigreeCertified\":\"CKU-111346187/17\",\n"
			+ "            \"dogBreed\":\"金毛寻回猎犬\",\n" + "            \"dogBreedCode\":\"111\",\n"
			+ "            \"birthday\":\"\",\n" + "            \"createDate\":\"2020-03-22\",\n"
			+ "            \"breedDate\":\"2019-12-05\",\n" + "            \"maleDogOwner\":\"董平\",\n"
			+ "            \"femaleDogOwner\":\"刘载春\",\n" + "            \"reviewState\":\"1\",\n"
			+ "            \"dogBirthCertificateList\":[\n" + "                {\n"
			+ "                    \"id\":\"1e9abb15ae944469bb75285536d2db83\",\n"
			+ "                    \"dogGender\":\"2\",\n" + "                    \"birthCerRegCode\":\"000993571\",\n"
			+ "                    \"identificationFlag\":\"\",\n" + "                    \"isAll\":\"0\",\n"
			+ "                    \"colorFlag\":\"金黄色\",\n" + "                    \"ecertFlag\":\"0\",\n"
			+ "                    \"businessState\":\"待审核\",\n"
			+ "                    \"canApplyPedigreeCertifiedFlag\":\"0\",  // 获取是否能申请血统证书标记位，0表示不可以申请，1表示可以申请\n"
			+ "                    \"dogActivationState\":\"\",\n"
			+ "                    \"dogActivationReviewState\":\"\",\n"
			+ "                    \"canTransferFlag\":1 // 0:可以转让 1:不可转让 2:已转让 3:杜高马犬不可转让\n" + "                } \n"
			+ "            ]\n" + "        }\n" + "    ],\n" + "    \"total\":10\n" + "}") })
	@RequestMapping(value = "", method = RequestMethod.GET)
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.getList(request));
	}
	
	

	@RequestMapping(value = "exclude/ckuhk", method = RequestMethod.GET)
	public void excludeCkuhk(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.excludeCkuhk(request));
	}

	@RequestMapping(value = "getList1", method = RequestMethod.GET)
	public void getList1(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.getList1(request));
	}

	/**
	 * 获取筛选条件类型
	 *
	 * @return
	 */
	@RequestMapping(value = "getEnumDogType", method = RequestMethod.GET)
	public void getEnumDogType(HttpServletResponse response) throws IOException {
		List<JSONObject> list = Lists.newArrayList();
		for (IEnumDogBirthCertificate.EnumDogType s : IEnumDogBirthCertificate.EnumDogType.values()) {
			JSONObject jo = new JSONObject();
			jo.put("label", s.getLable());
			jo.put("value", s.getValue());
			list.add(jo);
		}
		ServletUtils.writeResponse(response,
				new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size()))));
	}

	/**
	 * 更改上架状态
	 */
	@ResponseBody
	@RequestMapping(value = "updateState", method = RequestMethod.PUT)
	public RESTResponse updateState(@RequestBody String json) throws IOException {
		String mcode = UserUtils.getLoginMember().getMemberCode();
		if (StringUtils.isBlank(mcode))
			throw new ZAException(ZAErrorCode.ZA_ERC_AUTHENTICATION, "尚未登录");
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("state"))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "state不存在");
		Integer state = jo.getInt("state");
		if (!IEnumDogBirthCertificate.EnumDogType.isInEnum(state))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "state超出范围");
		String id = jo.getString("id");
		if (StringUtils.isBlank(id))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id参数为空");
		service.updateState(mcode, state.toString(), id);
		JSONObject data = new JSONObject();
		return new RESTResponse("data",data);
		

	}

	@RequestMapping(value = "updateSoldState", method = RequestMethod.PUT)
	public void updateSoldState(@RequestBody String json, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.updateSoldState(json));
	}

	@RequestMapping(value = "updateDogActivationState", method = RequestMethod.PUT)
	public void updateDogActivationState(@RequestBody String json, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.updateDogActivationState(json));
	}

	@ApiOperation(value = "购买幼犬登记卡-列表", tags = { "新生犬登记卡-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "number", value = "配种证明编号-模糊查询使用"),
			@ApiImplicitParam(name = "source", value = "1:app / 2:h5"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"list\":[\n" + "        {\n" + "            \"id\":\"1e9abb15ae944469bb75285536d2db83\",\n"
			+ "            \"dogName\":\"犬名\",\n" + "            \"dogGender\":\"性别\", // 1:公犬 2:母犬\n"
			+ "			\"breeder\":\"繁殖人\"\n" + "            \"birthCerRegCode\":\"出生证明编号\",\n"
			+ "            \"identificationFlag\":\"芯片号\",\n" + "            \"isAll\":\"0\",\n"
			+ "            \"colorFlag\":\"金黄色\",\n" + "            \"ecertFlag\":\"0\",\n"
			+ "            \"businessState\":\"已完成\",\n" + "            \"canApplyPedigreeCertifiedFlag\":\"0\",\n"
			+ "            \"canTransferFlag\": \n" + "            \"noseCode\":\"鼻纹编号\",\n"
			+ "            \"cabPassport\":\"护照号\",\n" + "            \"registerGrade\":\"E级\",\n"
			+ "            \"snCode\":\"识别码\",\n" + "            \"dogBreed\":\"犬种\",\n"
			+ "            \"dogBreedCode\":\"犬种code\",\n" + "            \"dogBirthday\":\"日期\"\n"
			+ "            \"pedigreeCertified\":\"血统证书号\"\n" + "        }\n" + "    ],\n" + "    \"total\":1\n" + "}\n"
			+ "\n" + "") })
	@RequestMapping(value = "transferList", method = RequestMethod.GET)
	public void transferList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.getTransferList(request, response));
	}

	@ApiOperation(value = "登记卡-详情", tags = { "新生犬登记卡-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "id", value = "登记卡id"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{    \n" + "	\"rc\": 0,\n" + "	    \"msg\": \"OK\",\n"
			+ "	    \"data\": {            \n" + "		\"id\": \"1e9abb15ae944469bb75285536d2db83\",\n"
			+ "		            \"dogName\": \"犬名\",\n" + "		            \"dogGender\": \"性别\",\n"
			+ "		            \"birthCerRegCode\": \"出生证明编号\",\n"
			+ "		            \"identificationFlag\": \"芯片号\",\n" + "		            \"isAll\": \"0\",\n"
			+ "		            \"colorFlag\": \"金黄色\",\n" + "		            \"ecertFlag\": \"0\",\n"
			+ "		            \"businessState\": \"已完成\",\n"
			+ "		            \"canApplyPedigreeCertifiedFlag\": \"0\",\n"
			+ "		            \"canTransferFlag\": false,\n" + "		            \"noseCode\": \"鼻纹编号\",\n"
			+ "		            \"cabPassport\": \"护照号\",\n" + "		            \"registerGrade\": \"E级\",\n"
			+ "		            \"snCode\": \"识别码\",\n" + "		            \"dogBreed\": \"犬种\",\n"
			+ "		            \"dogBreedCode\": \"犬种code\",\n" + "		            \"dogBirthday\": \"日期\",\n"
			+ "		\"pedigreeCertified\": \"血统证书号\"    \n" + "	}\n" + "}") })
	@RequestMapping(value = "info", method = RequestMethod.GET)
	public void info(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.getInfo(request));
	}

	// @RequestMapping(value = "transfer", method = RequestMethod.GET)
	// public void getTransfer(HttpServletRequest request,HttpServletResponse
	// response) throws IOException {
	// ServletUtils.writeResponse(response, service.getTransfer(request,response));
	// }

	/**
	 * 申请实体护照
	 */
	@ResponseBody
	@RequestMapping(value = "getPhysicalCabPassport", method = RequestMethod.PUT)
	public RESTResponse getPhysicalCabPassport(@RequestBody String json) throws IOException {
		String mcode = UserUtils.getLoginMember().getMemberCode();
		if (StringUtils.isBlank(mcode))
			throw new ZAException(ZAErrorCode.ZA_ERC_AUTHENTICATION, "尚未登录");
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("id"))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡ID未传入！");
		service.updatePhysicalCabPassport("0", jo.get("id").toString());

		return new RESTResponse();

	}
	
	@ApiOperation(value = "登记卡-获取可用优惠券列表")
	@RequestMapping(value = "/coupons", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestCouponGroup> getCoupons(@RequestParam int pageNo,
			@RequestParam int pageSize,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		PageResultDto<RestCouponGroup> result = service.getCoupons(pageNo, pageSize);
		ServletUtils.writeResponse(response, result);
		// 保留返回值，是为了swagger上可以看到结构体
		return null;
    }
	
	@ApiOperation(value = "登记卡-获取最优解")
	@RequestMapping(value = "/optimalCoupons", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<RestCouponGroup> getOptimalCoupons(
			@RequestParam int couponNum,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		return service.getOptimalCoupons(couponNum);
    }
	
	@ApiOperation(value = "登记卡-获取价格")
	@RequestMapping(value = "/getPrice", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<String> getPrice(@RequestBody RestDogBirthCertificatePostVO postVO,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		return service.getPrice(postVO);
    }


}