package com.cku.oa.sys.web;

import com.cku.oa.sys.service.SysScriptService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Title: com.cku.oa.sys.web
 * Description:
 * Company: cab
 *
 * @author yuanshuai
 * @date 2020/5/19 13:44
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/script")
public class SysScriptController extends BaseController {

	@Autowired
	private SysScriptService sysScriptService;

	@RequiresPermissions("sys:script:view")
	@RequestMapping(value = {"list", ""})
	public String list(HttpServletRequest request, HttpServletResponse response) {
		return "oa/sys/sysScriptList";
	}

	@RequiresPermissions("sys:script:reBuildName")
	@RequestMapping(value = "reBuild/memberName")
	public String reBuildMemberName(HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			sysScriptService.reBuildMemberName();
			addMessage(redirectAttributes, "重新生成会员姓名成功");
		} catch (Exception e){
			addMessage(redirectAttributes, "重新生成会员姓名失败：" + e.getMessage());
		}
		return "redirect:"+ Global.getAdminPath()+"/sys/script/?repage";
	}
}
