package com.cku.oa.sys.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.sys.entity.MemberSyncTask;
import com.cku.oa.sys.dao.MemberSyncTaskDao;

/**
 * 会员同步任务Service
 * @author gyh
 * @version 2019-09-20
 */
@Service
@Transactional(readOnly = true)
public class MemberSyncTaskService extends CrudService<MemberSyncTaskDao, MemberSyncTask> {

	public MemberSyncTask get(String id) {
		return super.get(id);
	}
	
	public List<MemberSyncTask> findList(MemberSyncTask memberSyncTask) {
		return super.findList(memberSyncTask);
	}
	
	public Page<MemberSyncTask> findPage(Page<MemberSyncTask> page, MemberSyncTask memberSyncTask) {
		return super.findPage(page, memberSyncTask);
	}
	
	@Transactional(readOnly = false)
	public void save(MemberSyncTask memberSyncTask) {
		super.save(memberSyncTask);
	}
	
	@Transactional(readOnly = false)
	public void delete(MemberSyncTask memberSyncTask) {
		super.delete(memberSyncTask);
	}
	
}