/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import lombok.AllArgsConstructor;
import lombok.Builder;

/**
 * 鼻纹开关设置记录表Entity
 * @author Sunny
 * @version 2021-06-02
 */
@Builder
@AllArgsConstructor
public class NoseprintSwitchSettingLog extends DataEntity<NoseprintSwitchSettingLog> {
	
	private static final long serialVersionUID = 1L;
	private String operatorId;		// 操作人ID
	private String operatorName;		// 操作人姓名
	private String memberCode;		// 会员号
	private String memberName;		// 会员名称
	private String detectionRepeatedOld;		// 原重复检测设置(0打开1关闭)
	private String detectionLivenessOld;		// 原活体检测设置(0打开1关闭)
	private String detectionRepeatedNew;		// 新重复检测设置(0打开1关闭)
	private String detectionLivenessNew;		// 新活体检测设置(0打开1关闭)
	private String ipAddr;		// IP地址
	private String macAddr;		// MAC地址
	
	public NoseprintSwitchSettingLog() {
		super();
	}

	public NoseprintSwitchSettingLog(String id){
		super(id);
	}

	@Length(min=0, max=64, message="操作人ID长度必须介于 0 和 64 之间")
	public String getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}
	
	@Length(min=0, max=64, message="操作人姓名长度必须介于 0 和 64 之间")
	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}
	
	@Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=64, message="会员名称长度必须介于 0 和 64 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}
	
	@Length(min=0, max=1, message="原重复检测设置(0打开1关闭)长度必须介于 0 和 1 之间")
	public String getDetectionRepeatedOld() {
		return detectionRepeatedOld;
	}

	public void setDetectionRepeatedOld(String detectionRepeatedOld) {
		this.detectionRepeatedOld = detectionRepeatedOld;
	}
	
	@Length(min=0, max=1, message="原活体检测设置(0打开1关闭)长度必须介于 0 和 1 之间")
	public String getDetectionLivenessOld() {
		return detectionLivenessOld;
	}

	public void setDetectionLivenessOld(String detectionLivenessOld) {
		this.detectionLivenessOld = detectionLivenessOld;
	}
	
	@Length(min=0, max=1, message="新重复检测设置(0打开1关闭)长度必须介于 0 和 1 之间")
	public String getDetectionRepeatedNew() {
		return detectionRepeatedNew;
	}

	public void setDetectionRepeatedNew(String detectionRepeatedNew) {
		this.detectionRepeatedNew = detectionRepeatedNew;
	}
	
	@Length(min=0, max=1, message="新活体检测设置(0打开1关闭)长度必须介于 0 和 1 之间")
	public String getDetectionLivenessNew() {
		return detectionLivenessNew;
	}

	public void setDetectionLivenessNew(String detectionLivenessNew) {
		this.detectionLivenessNew = detectionLivenessNew;
	}
	
	@Length(min=0, max=64, message="IP地址长度必须介于 0 和 64 之间")
	public String getIpAddr() {
		return ipAddr;
	}

	public void setIpAddr(String ipAddr) {
		this.ipAddr = ipAddr;
	}
	
	@Length(min=0, max=64, message="MAC地址长度必须介于 0 和 64 之间")
	public String getMacAddr() {
		return macAddr;
	}

	public void setMacAddr(String macAddr) {
		this.macAddr = macAddr;
	}
	
}