package com.cku.oa.statistics.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.alibaba.druid.util.StringUtils;
import com.cku.oa.statistics.dao.DogStatisticsDao;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
/**
 * 犬只统计
 * @author fanhuibin
 *
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/dog")
public class DogStatisticsController {
	
	@Autowired
	private DogStatisticsDao dogStatisticsDao;
	
	/**
	 * 犬只信息统计全国总表
	 * @throws ParseException 
	 */
	@RequestMapping(value = "regionalDistribution")
	public String regionalDistribution(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			page.setPageSize(40);
			String nowDate = request.getParameter("nowDate");				
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String province = request.getParameter("province");
			if(nowDate==null)
			{
				nowDate="";
			}
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			
			//统计各个地区的总犬只数量
			List<Map> results = dogStatisticsDao.countByRegion(province,startDate,endDate,page.getPageSize(),(page.getPageNo()-1)*page.getPageSize());
			//查询总记录条数
			List<Map> AllResults = dogStatisticsDao.countByRegion(province,startDate,endDate,0,0);
			 //你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
			page.setCount(AllResults.size());
			page.initialize();//重新计算页码信息
			
			//往页面传值			
			model.addAttribute("province", province);
			model.addAttribute("provinces", UserUtils.getProvince());
			model.addAttribute("startDate", startDate);
			model.addAttribute("endDate", endDate);
			model.addAttribute("results",results);
			
			model.addAttribute("page", page);
						
			return "oa/statistics/dog/regionalDistribution";

	}
	
	/**
	 * 犬只信息统计单地区全犬种
	 * @throws ParseException 
	 */
	@RequestMapping(value = "regionalDistribution_breed")
	public String regionalDistributionBreed(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		
			String nowDate = request.getParameter("nowDate");				
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String province = request.getParameter("province");
			if(nowDate==null)
			{
				nowDate="";
			}
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			
			//统计各个地区的总犬只数量
			List<Map> results = dogStatisticsDao.countByRegionBreed(province,startDate,endDate);
			//往页面传值			
			model.addAttribute("province", province);
			model.addAttribute("provinces", UserUtils.getProvince());
			model.addAttribute("startDate", startDate);
			model.addAttribute("endDate", endDate);
			model.addAttribute("results",results);
			
			//下面的代码纯粹是为了演示如何使用分页功能，这个功能其实不需要分页的
			Page<User> page = new Page<User>(request, response);//从页面的参数中获取当前的页码等信息
			page.setCount(100); //总条数
			page.setPageNo(1);//当前的页数
			page.setPageSize(20); //每页的大小
			page.initialize();//初始化
			model.addAttribute("page", page);
						
			return "oa/statistics/dog/regionalDistribution_breed";

	}
	
	/**
	 * 犬只信息统计单地区单犬种会员犬只信息
	 * @throws ParseException 
	 */
	@RequestMapping(value = "regionalDistribution_breed_owner")
	public String regionalDistributionBreedOwner(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		
			String nowDate = request.getParameter("nowDate");				
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String province = request.getParameter("province");
			String breed = request.getParameter("breed");
			if(nowDate==null)
			{
				nowDate="";
			}
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			
			//统计各个地区的总犬只数量
			List<Map> results = dogStatisticsDao.countByRegionBreedOwner(province,breed,startDate,endDate);
			//往页面传值			
			model.addAttribute("province", province);
			model.addAttribute("provinces", UserUtils.getProvince());
			model.addAttribute("startDate", startDate);
			model.addAttribute("endDate", endDate);
			model.addAttribute("results",results);
			
			//下面的代码纯粹是为了演示如何使用分页功能，这个功能其实不需要分页的
			Page<User> page = new Page<User>(request, response);//从页面的参数中获取当前的页码等信息
			page.setCount(100); //总条数
			page.setPageNo(1);//当前的页数
			page.setPageSize(20); //每页的大小
			page.initialize();//初始化
			model.addAttribute("page", page);
						
			return "oa/statistics/dog/regionalDistribution_breed_owner";

	}
	/**
	 * 犬只信息统计地区，时间，跟个统计 按会员号
	 * @throws ParseException
	 */
	@RequestMapping(value = "regionalDistribution_type_owner")
	public String regionalDistributionTypeOwner(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{

		String nowDate = request.getParameter("nowDate");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String province = request.getParameter("province");
		String type = request.getParameter("type");
		if(nowDate==null)
		{
			nowDate="";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if(!nowDate.equals(""))
		{
			if(nowDate.equals("year"))
			{
				startDate = String.valueOf(year)+"-01-01 00:00:00";
				endDate = String.valueOf(year)+"-12-31 23:59:59";
			}else if(nowDate.equals("month")){
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
				endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
			}
		}else{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}

		//统计各个地区的总犬只数量
		List<Map> results = dogStatisticsDao.countByRegionTypeOwner(province,type,startDate,endDate);
		//往页面传值
		model.addAttribute("province", province);
		model.addAttribute("provinces", UserUtils.getProvince());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("type", type);
		model.addAttribute("results",results);

		//下面的代码纯粹是为了演示如何使用分页功能，这个功能其实不需要分页的
		Page<User> page = new Page<User>(request, response);//从页面的参数中获取当前的页码等信息
		page.setCount(100); //总条数
		page.setPageNo(1);//当前的页数
		page.setPageSize(20); //每页的大小
		page.initialize();//初始化
		model.addAttribute("page", page);

		return "oa/statistics/dog/regionalDistribution_type_owner";

	}
	
	/**
	 * 配种证明统计
	 * @throws ParseException 
	 */
	@RequestMapping(value = "BreedCertified")
	public String BreedCertified(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		
		String nowDate = request.getParameter("nowDate");				
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String province = request.getParameter("province");
		if(nowDate==null)
		{
			nowDate="";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if(!nowDate.equals(""))
		{
			if(nowDate.equals("year"))
			{
				startDate = String.valueOf(year)+"-01-01";
				endDate = String.valueOf(year)+"-12-31";
			}else if(nowDate.equals("month")){
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01";
				endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01";
			}
		}else{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}
		
		List<Map> results = dogStatisticsDao.countBreedCertified(province,startDate,endDate);
		
		model.addAttribute("province", province);
		model.addAttribute("provinces", UserUtils.getProvince());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("results",results);
		
		return "oa/statistics/dog/BreedCertified";
	}
	
	/**
	 * 全国出生证明统计
	 * @throws ParseException 
	 */
	@RequestMapping(value = "BirthCertificate")
	public String BirthCertificate(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		
		String nowDate = request.getParameter("nowDate");				
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String province = request.getParameter("province");
		if(nowDate==null)
		{
			nowDate="";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if(!nowDate.equals(""))
		{
			if(nowDate.equals("year"))
			{
				startDate = String.valueOf(year)+"-01-01 00:00:00";
				endDate = String.valueOf(year)+"-12-31 23:59:59";
			}else if(nowDate.equals("month")){
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
				endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
			}
		}else{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}
		
		List<Map> results = dogStatisticsDao.countBirthCertificate(province,startDate,endDate);
		
		model.addAttribute("province", province);
		model.addAttribute("provinces", UserUtils.getProvince());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("results",results);
		
		return "oa/statistics/dog/BirthCertificate";
	}
	
	/**
	 * 单地区会员出生证明统计
	 * @throws ParseException 
	 */
	@RequestMapping(value = "BirthCertificate_owner")
	public String BirthCertificateOwner(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		
		String nowDate = request.getParameter("nowDate");				
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String province = request.getParameter("province");
		if(nowDate==null)
		{
			nowDate="";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if(!nowDate.equals(""))
		{
			if(nowDate.equals("year"))
			{
				startDate = String.valueOf(year)+"-01-01";
				endDate = String.valueOf(year)+"-12-31";
			}else if(nowDate.equals("month")){
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01";
				endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01";
			}
		}else{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}
		
		List<Map> results = dogStatisticsDao.countBirthCertificateOwner(province,startDate,endDate);
		
		model.addAttribute("province", province);
		model.addAttribute("provinces", UserUtils.getProvince());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("results",results);
		
		return "oa/statistics/dog/BirthCertificate_owner";
	}
}
