package com.cku.oa.shop.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.util.JSONUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.shop.entity.ShopUserAddress;
import com.cku.oa.shop.service.ShopUserAddressService;

import java.util.HashMap;

/**
 * 商城用户地址Controller
 * @author lyy
 * @version 2016-08-24
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopUserAddress")
public class ShopUserAddressController extends BaseController {

	@Autowired
	private ShopUserAddressService shopUserAddressService;
	
	@ModelAttribute
	public ShopUserAddress get(@RequestParam(required=false) String id) {
		ShopUserAddress entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = shopUserAddressService.get(id);
		}
		if (entity == null){
			entity = new ShopUserAddress();
		}
		return entity;
	}
	
	@RequiresPermissions("shop:shopUserAddress:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShopUserAddress shopUserAddress, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShopUserAddress> page = shopUserAddressService.findPage(new Page<ShopUserAddress>(request, response), shopUserAddress); 
		model.addAttribute("page", page);
		return "oa/shop/shopUserAddressList";
	}

	@RequiresPermissions("shop:shopUserAddress:view")
	@RequestMapping(value = "form")
	public String form(ShopUserAddress shopUserAddress, Model model) {
		model.addAttribute("shopUserAddress", shopUserAddress);
		return "oa/shop/shopUserAddressForm";
	}
	@RequestMapping(value = "updateAddress")
	@ResponseBody
	public String updateAddress(ShopUserAddress shopUserAddress) {
		shopUserAddressService.updateAddress(shopUserAddress);
		HashMap<String,String> result = new HashMap<String,String>();
		return JSONUtils.toJSON(result);
	}
	@RequiresPermissions("shop:shopUserAddress:edit")
	@RequestMapping(value = "save")
	public String save(ShopUserAddress shopUserAddress, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, shopUserAddress)){
			return form(shopUserAddress, model);
		}
		shopUserAddressService.save(shopUserAddress);
		addMessage(redirectAttributes, "保存商城用户地址成功");
		return "redirect:"+Global.getAdminPath()+"/shop/shopUserAddress/?repage";
	}
	
	@RequiresPermissions("shop:shopUserAddress:edit")
	@RequestMapping(value = "delete")
	public String delete(ShopUserAddress shopUserAddress, RedirectAttributes redirectAttributes) {
		shopUserAddressService.delete(shopUserAddress);
		addMessage(redirectAttributes, "删除商城用户地址成功");
		return "redirect:"+Global.getAdminPath()+"/shop/shopUserAddress/?repage";
	}

}