/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.dao;

import java.util.List;
import java.util.Set;

import com.cku.oa.groomer.entity.GroomerRegister;
import org.apache.ibatis.annotations.Param;

import com.cku.oa.handler.entity.HandlerRegister;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 报名DAO接口
 * @author 柴雪腾
 * @version 2016-08-08
 */
@MyBatisDao
public interface HandlerRegisterDao extends CrudDao<HandlerRegister> {

	/**
	 * 成绩列表
	 * @Author chaixueteng
	 * @2016年8月10日下午5:00:39
	 */
	List<HandlerRegister> findGradeList(HandlerRegister handlerRegister);

	/**
	 * 生成报名信息
	 * @Author chaixueteng
	 * @2016年8月15日下午5:01:23
	 */
	void mobilesave(HandlerRegister handlerRegister);

	/**
	 * 保存并审核图片
	 * @Author chaixueteng
	 * @2016年8月18日下午1:34:44
	 */
	void saveImage(HandlerRegister hR);

	/**
	 * 导出的报名信息数据
	 * @Author chaixueteng
	 * @2016年8月19日上午11:46:41
	 */
	List<HandlerRegister> getRegisterList(HandlerRegister handlerRegister);

	/**
	 * 确认是否到场
	 * @Author chaixueteng
	 * @2016年8月24日上午10:31:58
	 */
	void match(HandlerRegister handlerRegister);

	/**
	 * 录入成绩
	 * @Author chaixueteng
	 * @2016年8月24日下午2:56:00
	 */
	int inputGrade(HandlerRegister handlerRegister);
	//得到培训机构
	String getSchoolNameCn(String memberCode);
	//报名未审核数
	int getRegisterCount();
	//报名重复性验证
	List<HandlerRegister> getByRegister(@Param("memberCode")String memberCode,@Param("showCode")String showCode);

	List<HandlerRegister> registerExaminerCheck(@Param("memberCode")String memberCode,@Param("showCode")String showCode);
	/**
	 *
	 * @Description：获取登录人的历史报名信息
	 * @author: zhuoHeng
	 * @version: 2016年12月14日 上午9:35:08
	 */
	List<HandlerRegister> getHandlerRegister(@Param("memberCode") String memberCode);
	List<HandlerRegister> getExaminerHandlerRegister(@Param("memberCode") String memberCode);
	
	/**
	 *
	 * @Description：重置美容报名审核状态（宠爱王国使用）
	 * @author: zhuoHeng
	 * @version: 2016年12月15日 下午2:24:15
	 */
	void changeReviewState(@Param("id") String id);
	
	void changeExaminerReviewState(@Param("id") String id);

	/**
	 *
	 * @Description：获取登录人的历史报名信息(训练师)
	 * @author: zhuoHeng
	 * @version: 2016年12月14日 上午9:35:08
	 */
	List<HandlerRegister> getHandlerTrainerRegister(@Param("memberCode") String memberCode);

	void refundHandlerRegister(@Param("vo") HandlerRegister vo, @Param("ids") Set<String> ids);
}