/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 财务映射表Entity
 * @author 财务映射表
 * @version 2019-09-23
 */
public class SaFinanceSubjectMapping extends DataEntity<SaFinanceSubjectMapping> {
	
	private static final long serialVersionUID = 1L;
	private String subjectCode;		// 科目代码
	private String subjectName;		// 科目名称
	private String yonyouDeptCode;		// 用友部门编码
	private String yonyouDeptName;		// 用友部门名称
	private String typeId;		// 科目类型id 1 收款 2预收 3收入 4税费 5应付 6应收
	private String typeName;		// 科目类型名
	private String districtId;		// 地区id
	private String districtName;		// 地区名称
	private String businessRefund;		// 是否可退费
	private String sysOfficeCode;		// 业务系统部门代码
	
	public SaFinanceSubjectMapping() {
		super();
	}

	public SaFinanceSubjectMapping(String id){
		super(id);
	}

	@Length(min=0, max=100, message="科目代码长度必须介于 0 和 100 之间")
	public String getSubjectCode() {
		return subjectCode;
	}

	public void setSubjectCode(String subjectCode) {
		this.subjectCode = subjectCode;
	}
	
	@Length(min=0, max=100, message="科目名称长度必须介于 0 和 100 之间")
	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}
	
	@Length(min=0, max=100, message="用友部门编码长度必须介于 0 和 100 之间")
	public String getYonyouDeptCode() {
		return yonyouDeptCode;
	}

	public void setYonyouDeptCode(String yonyouDeptCode) {
		this.yonyouDeptCode = yonyouDeptCode;
	}
	
	@Length(min=0, max=100, message="用友部门名称长度必须介于 0 和 100 之间")
	public String getYonyouDeptName() {
		return yonyouDeptName;
	}

	public void setYonyouDeptName(String yonyouDeptName) {
		this.yonyouDeptName = yonyouDeptName;
	}
	
	@Length(min=1, max=100, message="科目类型id 1 收款 2预收 3收入 4税费 5应付 6应收长度必须介于 1 和 100 之间")
	public String getTypeId() {
		return typeId;
	}

	public void setTypeId(String typeId) {
		this.typeId = typeId;
	}
	
	@Length(min=1, max=100, message="科目类型名长度必须介于 1 和 100 之间")
	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}
	
	@Length(min=0, max=20, message="地区id长度必须介于 0 和 20 之间")
	public String getDistrictId() {
		return districtId;
	}

	public void setDistrictId(String districtId) {
		this.districtId = districtId;
	}
	
	@Length(min=0, max=20, message="地区名称长度必须介于 0 和 20 之间")
	public String getDistrictName() {
		return districtName;
	}

	public void setDistrictName(String districtName) {
		this.districtName = districtName;
	}
	
	@Length(min=0, max=20, message="是否可退费长度必须介于 0 和 20 之间")
	public String getBusinessRefund() {
		return businessRefund;
	}

	public void setBusinessRefund(String businessRefund) {
		this.businessRefund = businessRefund;
	}
	
	@Length(min=0, max=25, message="业务系统部门代码长度必须介于 0 和 25 之间")
	public String getSysOfficeCode() {
		return sysOfficeCode;
	}

	public void setSysOfficeCode(String sysOfficeCode) {
		this.sysOfficeCode = sysOfficeCode;
	}
	
}