package com.cku.oa.dog.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogBirthCertificateTransferDao;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBirthCertificateTransfer;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.sys.entity.SMSChangePassword;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ZtSmsUtil;
import com.cku.restful.v1.breeder.dto.RestBirthCertificateRequestVo;
import com.cku.restful.v1.breeder.dto.RestTransferReviewRequestVo;
import com.cku.restful.v1.breeder.dto.TransferListRequestVo;
import com.cku.restful.v1.breeder.dto.TransferListResponseVo;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只鼻纹Service
 * 
 * @author xx
 * @version 2020-04-24
 */
@Service
@Transactional(readOnly = true)
public class DogBirthCertificateTransferService
		extends CrudService<DogBirthCertificateTransferDao, DogBirthCertificateTransfer> {

	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;

	@Autowired
	private DogChipDao dogChipDao;

	@Autowired
	private DogNoseService dogNoseService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private SMSRemindService smsRemindService;

	@Autowired
	private DogTypeDao dogTypeDao;

	@Autowired
	private DogColorMarkDao dogColorMarkDao;

	public DogBirthCertificateTransfer get(String id) {
		return super.get(id);
	}

	public List<DogBirthCertificateTransfer> findList(DogBirthCertificateTransfer dogBirthCertificateTransfer) {
		return super.findList(dogBirthCertificateTransfer);
	}

	public Page<DogBirthCertificateTransfer> findPage(Page<DogBirthCertificateTransfer> page,
			DogBirthCertificateTransfer dogBirthCertificateTransfer) {
		return super.findPage(page, dogBirthCertificateTransfer);
	}

	@Transactional(readOnly = false)
	public void save(DogBirthCertificateTransfer dogBirthCertificateTransfer) {
		super.save(dogBirthCertificateTransfer);
	}

	@Transactional(readOnly = false)
	public void delete(DogBirthCertificateTransfer dogBirthCertificateTransfer) {
		super.delete(dogBirthCertificateTransfer);
	}

	@Transactional(readOnly = false)
	public void updateByParams(DogBirthCertificateTransfer dogBirthCertificateTransfer) {
		dao.updateByParams(dogBirthCertificateTransfer);
	}

	public PageResultDto<TransferListResponseVo> getRestList(TransferListRequestVo vo) {
		vo.setPageNo(vo.getPageNo() < 1 ? 1 : vo.getPageNo());
		vo.setPageNo((vo.getPageNo() - 1) * vo.getPageSize());
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		vo.setMemberCode(memberCode);
		Integer count = dao.restListCount(vo);
		List<TransferListResponseVo> resultList = dao.restList(vo);
		for (TransferListResponseVo t : resultList) {
			t.setDogGenderDesc("1".equals(t.getDogGender()) ? "公" : "母");
			t.setDogBirthdayDesc(DateUtils.formatDate(t.getDogBirthday()));
			t.setCreateDateDesc(DateUtils.formatDateTime(t.getCreateDate()));
			if (t.getReviewDate() != null) {
				t.setReviewDateDesc(DateUtils.formatDateTime(t.getReviewDate()));
			}
			switch (t.getBusinessStatus()) {
			case "0":
				t.setBusinessStatusDesc("通过");
				break;
			case "1":
				t.setBusinessStatusDesc("未通过");
				break;
			case "2":
				t.setBusinessStatusDesc("待审核");
				break;
			}
		}
		Integer totalPage = (count + vo.getPageSize() - 1) / vo.getPageSize();
		return PageResultDto.success(resultList, count.longValue(), totalPage.longValue());
	}

	public ResultDto<TransferListResponseVo> search(RestBirthCertificateRequestVo vo, HttpServletRequest request) {
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
				.getByBirthCodeAndSnCode(vo.getBirthCerRegCode(), vo.getSnCode());
		String msg = this.valid(dogBirthCertificate, request);
		if (!"OK".equals(msg)) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, msg);
		}
		TransferListResponseVo respVo = new TransferListResponseVo();
		respVo.setBirthCerRegCode(dogBirthCertificate.getBirthCerRegCode());
		respVo.setDogBirthCertificateId(dogBirthCertificate.getId());
		respVo.setDogName(dogBirthCertificate.getDogEnName());
		DogType dogType = dogTypeDao.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		respVo.setDogBreedDesc(dogType.getBreedCnName());
		respVo.setDogBreed(dogBirthCertificate.getDogBreed());

		DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
		respVo.setColorFlagDesc(dogColorMark.getDogColorMarkCn());
		respVo.setColorFlag(dogBirthCertificate.getColorFlag());
		respVo.setDogGender(dogBirthCertificate.getDogGender());
		respVo.setDogGenderDesc("1".equals(dogBirthCertificate.getDogGender()) ? "公" : "母");
		respVo.setDogBirthday(dogBirthCertificate.getDogBirthday());
		respVo.setDogBirthdayDesc(DateUtils.formatDate(dogBirthCertificate.getDogBirthday()));
		respVo.setIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
		respVo.setTransferorMemberCode(dogBirthCertificate.getMemberCode());
		respVo.setTransferorMemberName(dogBirthCertificate.getDogOwenr());

		Member receiverMember = UserUtils.getLoginMember();
		respVo.setReceiverMemberCode(receiverMember.getMemberCode());
		respVo.setReceiverMemberName(receiverMember.getName());

		respVo.setSnCode(dogBirthCertificate.getSnCode());
		return ResultDto.success(respVo);
	}

	@Transactional(readOnly = false)
	public ResultDto<?> transfer(RestBirthCertificateRequestVo vo, HttpServletRequest request) {
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
				.getByBirthCodeAndSnCode(vo.getBirthCerRegCode(), vo.getSnCode());
		String msg = this.valid(dogBirthCertificate, request);
		if (!"OK".equals(msg)) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, msg);
		}
		// 添加流水
		DogBirthCertificateTransfer dogBirthCertificateTransfer = new DogBirthCertificateTransfer();
		dogBirthCertificateTransfer.setTransferorMemberCode(dogBirthCertificate.getMemberCode());// 转出犬主会员号
		dogBirthCertificateTransfer.setTransferorMemberName(dogBirthCertificate.getDogOwenr());
		dogBirthCertificateTransfer.setReceiverMemberCode(UserUtils.getLoginMember().getMemberCode());// 新犬主会员号
		dogBirthCertificateTransfer.setReceiverMemberName(UserUtils.getLoginMember().getName());
		dogBirthCertificateTransfer.setBusinessStatus("2");
		dogBirthCertificateTransfer.setDogBirthCertificateId(dogBirthCertificate.getId());
		this.save(dogBirthCertificateTransfer);

		Member transferorMember = memberService.getByMemberCode(dogBirthCertificateTransfer.getTransferorMemberCode());
		// 发送短信
		ZtSmsUtil.sendNote("您的登记卡编号为" + dogBirthCertificate.getBirthCerRegCode() + "犬只，于"
				+ DateUtils.formatDateTime(dogBirthCertificateTransfer.getCreateDate()) + "办理登记卡转让业务，由"
				+ dogBirthCertificateTransfer.getTransferorMemberName() + "变更为"
				+ dogBirthCertificateTransfer.getReceiverMemberName() + UserUtils.getLoginMember().getSafeMobile()
				+ "涉及犬只归属权安全，请仔细确认核实对方信息，如对该业务办理有任何疑问，请致电协会客服400-660-7000", transferorMember.getSafeMobile());
		return ResultDto.SUCCESSFUL();
	}

	private String valid(DogBirthCertificate dogBirthCertificate, HttpServletRequest request) {
		if (dogBirthCertificate == null) {
			return "检索的数据不存在";
		}
		// 审核未通过不可转让
		if (!"1".equals(dogBirthCertificate.getReviewState())) {
			return "登记卡审核未通过不可转让";
		}
		// 正窝办理不可转让
		if ("1".equals(dogBirthCertificate.getIsAll())) {
			return "整窝办理不可转让";
		}
		// 匹配无芯片记录不可转让
		if (StringUtils.isEmpty(dogBirthCertificate.getIdentificationFlag())) {
			return "登记卡无芯片记录不可转让";
		}
		// 已申请血统证书不可转让
		DogChip dogChip = dogChipDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogChip != null) {
			return "登记卡已申请血统证书不可转让";
		}

		// 已转让
		DogBirthCertificateTransfer dogBirthCertificateTransfer = new DogBirthCertificateTransfer();
		dogBirthCertificateTransfer.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		dogBirthCertificateTransfer.setBusinessFlag("1");
		if (!CollectionUtils.isEmpty(this.findList(dogBirthCertificateTransfer))) {
			return "登记卡已申请转让不可转让";
		}

		if ("292".equals(dogBirthCertificate.getDogBreed()) || "15C".equals(dogBirthCertificate.getDogBreed())) {
			return "杜高/玛犬不可转让";
		}
		// 不同站点不能转让
		Member member = UserUtils.getLoginMember();
		String memberSite = StringUtils.isEmpty(member.getMemberSite()) ? "2" : member.getMemberSite();
		Member rmember = memberService.getByMemberCode(dogBirthCertificate.getMemberCode());
		String rmemberSite = StringUtils.isEmpty(rmember.getMemberSite()) ? "2" : rmember.getMemberSite();

		// 判断新犬主与申请人为同一站点会员
		if (!memberSite.equals(rmemberSite)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主与申请人会员站点不同，不能进行新生犬登记");
		}
		if (dogBirthCertificate.getBreederMemberCode().equals(member.getMemberCode())) {
			return "申请人和繁殖人是同一人，不可转让";
		}
		return "OK";
	}

	public void sms() {
		smsRemindService.sendTransferSMSCode(UserUtils.getLoginMember().getSafeMobile());
	}

	@Transactional(readOnly = false)
	public ResultDto<?> review(RestTransferReviewRequestVo vo) {
		DogBirthCertificateTransfer dogBirthCertificateTransfer = this.get(vo.getId());
		Member rmember = memberService.getByMemberCode(dogBirthCertificateTransfer.getReceiverMemberCode());
		
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao .get(dogBirthCertificateTransfer.getDogBirthCertificateId());
		if ("0".equals(vo.getBusinessStatus())) {
			if (StringUtils.isEmpty(vo.getSmsCode())) {
				return ResultDto.error(ZAErrorCode.ZA_ERROR, "smsCode不能为空");
			}
			if (!(Global.isDevMode() && "6666".equals(vo.getSmsCode()))) {
				try {
					checkSmsCode(vo.getSmsCode());
				} catch (ZAException e) {
					return ResultDto.error(ZAErrorCode.ZA_ERROR, e.getMessage());
				}
			}
			// 修改登记卡犬主
			dogBirthCertificate.setMemberCode(dogBirthCertificateTransfer.getReceiverMemberCode());
			dogBirthCertificate.setDogOwenr(dogBirthCertificateTransfer.getReceiverMemberName());
			dogBirthCertificate.preUpdate();
			dogBirthCertificateDao.update(dogBirthCertificate);
			
			// 发送短信
			ZtSmsUtil.sendNote(
					"CKU登记卡转让业务提醒，犬只（" + dogBirthCertificate.getBirthCerRegCode() + "）已于"
							+ DateUtils.formatDateTime(new Date()) + "经繁殖人审核通过完成登记卡转让，犬主由"
							+ dogBirthCertificateTransfer.getTransferorMemberName() + "变更为"
							+ dogBirthCertificateTransfer.getReceiverMemberName() + "。如有疑问，请致电协会客服400-660-7000。",
					rmember.getSafeMobile());
		} else {
			ZtSmsUtil.sendNote(
					"CKU登记卡转让业务提醒，犬只（" + dogBirthCertificate.getBirthCerRegCode() + "）已于"
							+ DateUtils.formatDateTime(new Date()) +   "被繁殖人拒绝转让。",
							rmember.getSafeMobile());
		}
		dogBirthCertificateTransfer.setId(vo.getId());
		dogBirthCertificateTransfer.setBusinessStatus(vo.getBusinessStatus());
		dogBirthCertificateTransfer.setRemarks(vo.getRemarks());
		dogBirthCertificateTransfer.setReviewBy(UserUtils.getLoginMember().getName());
		dogBirthCertificateTransfer.setReviewDate(new Date());
		this.save(dogBirthCertificateTransfer);
		return ResultDto.SUCCESSFUL();
	}

	public void checkSmsCode(String smsCode) {
		String mobile = UserUtils.getLoginMember().getSafeMobile();
		SMSChangePassword oldSMS = (SMSChangePassword) CacheUtils.get("dogBirthCertificateTransfer",
				"dog_birth_certificate_transfer" + mobile);
		if (oldSMS == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请重新获取");
		}
		int time = (int) (300 - (System.currentTimeMillis() - oldSMS.getDate().getTime()) / 1000);
		if (time <= 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请重新获取");
		}
		if (!smsCode.equals(oldSMS.getKey())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误，请填写正确的变更授权验证码！");
		}
		// 校验通过后移除验证授权码
		CacheUtils.remove("dogBirthCertificateTransfer", "dog_birth_certificate_transfer" + mobile);
	}

}