package com.cku.oa.contest.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.contest.entity.ContestBreed;
import com.cku.oa.contest.dao.ContestBreedDao;

/**
 * 赛场犬种Service
 * @author yuanshuai
 * @version 2020-10-12
 */
@Service
@Transactional(readOnly = true)
public class ContestBreedService extends CrudService<ContestBreedDao, ContestBreed> {

	public ContestBreed get(String id) {
		return super.get(id);
	}
	
	public List<ContestBreed> findList(ContestBreed contestBreed) {
		return super.findList(contestBreed);
	}
	
	public Page<ContestBreed> findPage(Page<ContestBreed> page, ContestBreed contestBreed) {
		return super.findPage(page, contestBreed);
	}
	
	@Transactional(readOnly = false)
	public void save(ContestBreed contestBreed) {
		super.save(contestBreed);
	}
	
	@Transactional(readOnly = false)
	public void delete(ContestBreed contestBreed) {
		super.delete(contestBreed);
	}

	/**
	 * @Description： 根据犬种代码获得犬种
	 * @author: yuanshuai
	 * @date: 2020/10/12 16:20
	 */
	public List<ContestBreed> getByBreedCode(String breedCode) {
		return dao.getByBreedCode(breedCode);
	}

	/**
	 * @Description： 根据犬种编号获得
	 * @author: yuanshuai
	 * @date: 2020/11/6 11:06
	 */
	public ContestBreed getByBreedNo(String breedNo, String language) {
		return dao.getByBreedNo(breedNo,language);
	}
}