package com.cku.oa.appreciation.dao;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.appreciation.entity.AppreciationApply;
import com.cku.oa.appreciation.entity.AppreciationCertificate;
import com.cku.oa.appreciation.entity.AppreciationUser;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 鉴赏课报名DAO接口
 * 
 * @author zxy
 * @version 2022-02-15
 */
@MyBatisDao
public interface AppreciationApplyDao extends CrudDao<AppreciationApply> {

	Integer getMaxApplyCode();

	Integer updateCourseId(AppreciationApply appreciationApply);

	Integer updateCourseIds(@Param("ids") List<String> ids, @Param("cid") String cid);

	List<AppreciationApply> getCoursesApplyNum(@Param("ids") Set<String> ids);

	AppreciationApply getCoursesApplyNumById(@Param("id") String id);

	List<AppreciationApply> getPaidByMobile(@Param("mobile") String mobile);

	List<AppreciationUser> getByMobileWithMember(@Param("mobile") String mobile);

	List<AppreciationCertificate> getByMemberCodeOrCertificateCode(@Param("memberCode") String memberCode,
			@Param("certificateCode") String certificateCode);

	Integer countByMemberCode(@Param("memberCode") String memberCode);

	Integer updateCertificate(AppreciationApply apply);
	
	Integer clean(AppreciationApply apply);
}