<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>修改绑定关系</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		body {
			min-height:300px;
		}
	</style>
	
	<script src="${ctxStatic}/vue/clipboard.js" type="text/javascript"></script>
	<script src="${ctxStatic}/vue/vue.js" type="text/javascript"></script>
	<script type="text/javascript">
		function loadFun(btnId){
			top.layer.load();
			if(!btnId){
				$("#"+btnId).prop("disabled",true);	
			}
		}
		function closeLoadFun(btnId){
			top.layer.closeAll('loading');
			if(!btnId){
				$("#"+btnId).prop("disabled",false);
			}
		}
		$(document).ready(function(){
			var vueEle = new Vue({
				el:"#resetPwdForm",
				data(){
					return {
						loginMobile:'${member.loginMobile}',
						safeMobile:"${member.loginMobile ne member.safeMobile?member.safeMobile:''}",
						newPassword:'',
						formData:{
							id:'${member.id}',
							userId:'${member.userId}',
							sendSmsFlag:'0',
							memberCode:'${member.memberCode}',
							memberName:'${member.name}',
							receiveMobile:'${not empty member.loginMobile ? member.loginMobile:member.safeMobile}'
						}
					}
				},
				methods: {
					isNull(value) {
						return value == undefined || value == null || value.length == 0;
					},
					isNotNull(value) {
						return value != undefined && value != null && value.length != 0;
					},
					clipboardNewPwd(){
						var clipboard = new ClipboardJS('.copyPwdBtn');
						clipboard.on('success', function(e) {
							layer.msg("复制成功");
						});
						clipboard.on('error', function(e) {
							layer.msg("复制失败，请手动复制");
						});
					},
					resetPwd(){
						var that = this;
						console.log(this.formData)
						$.jBox.confirm("确认要重置密码吗？","系统提示",function(v,h,f){
							if(v=="ok"){
								loadFun();
								$.ajax({
									type : "post",
									data: JSON.stringify(that.formData),
									contentType: "application/json",
									url : "${ctx}/sys/user/member/password/reset",
									dataType: 'JSON',
									success : function(result) {
										closeLoadFun();
										if (result.rc == 0) {
											that.newPassword = result.data;
										} else {
											layer.msg(result.msg);
										}
									},
									error: function (res) {
										closeLoadFun();
										layer.msg("操作失败!");
									}
								});
							}
						},{buttonsFocus:1});
						$('.jbox-body .jbox-icon').css('top','55px');
					},
					cancel(){
						var index = parent.layer.getFrameIndex(window.name);
						parent.layer.close(index);
					}
				}
			});
		});
	
	</script>
</head>
<body>
	<div id="resetPwdForm" style="padding-top:20px;">
		<form id="inputForm"  action="#" method="post" class="form-horizontal">
			<div class="control-group">
				<label class="control-label">会员编号：</label>
				<div class="controls">
					<input type="text" class="input-xlarge" v-model="formData.memberCode" readonly="readonly"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">会员姓名：</label>
				<div class="controls">
					<input type="text" class="input-xlarge " v-model="formData.memberName" readonly="readonly"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">短信通知：</label>
				<div class="controls">
					<div style="line-height:25px;display:flex;">
						<div style="display:flex;margin-right:20px;">
							<input value="1" v-model="formData.sendSmsFlag" type="radio"/>
							<div>是</div>
						</div>
						<div style="display:flex;margin-right:20px;">
							<input value="0" v-model="formData.sendSmsFlag" type="radio"/>
							<div>否</div>
						</div>
					</div>
				</div>
			</div>
			<div class="control-group" v-if="formData.sendSmsFlag == 1">
				<label class="control-label">接收手机号：</label>
				<div class="controls">
					<div style="line-height:25px;display:flex;">
						<div style="display:flex;margin-right:20px;" v-if="isNotNull(loginMobile)">
							<input id="loginMobile" :value="loginMobile" v-model="formData.receiveMobile" type="radio"/>
							<div>{{loginMobile}}<span v-if="isNotNull(loginMobile) && isNotNull(safeMobile)">（登）</span></div>
						</div>
						<div style="display:flex;margin-right:20px;" v-if="isNotNull(safeMobile) ">
							<input id="safeMobile" :value="safeMobile" v-model="formData.receiveMobile" type="radio"/>
							<div>{{safeMobile}}<span v-if="isNotNull(loginMobile) && isNotNull(safeMobile) ">（安）</span></div>
						</div>
					</div>
				</div>
			</div>
			<div v-if="!newPassword" class="control-group" style="text-align:center;">
				<div class="help-inline"><font color="red">注：如遇到登录与安全手机号不一致，请核对会员有效手机号后，再选择接收手机号</font> </div><br>
			</div>
			<center>
			<div v-if="newPassword" class="control-group">
				<div class="control-group" style="text-align:center;">
					<div class="help-inline"><font color="green">密码重置成功，新密码： <span style="font-size:18px;"><strong>{{newPassword}}</strong></span>&nbsp;&nbsp;&nbsp;&nbsp;您可点击下方复制按钮复制。</font> </div><br>
				</div>
			</div>
			<button type="button" class="btn btn-default" style="width:100px;" @click="cancel">{{newPassword?"关闭":"取消"}}</button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<button v-if="newPassword"  @click="clipboardNewPwd" :data-clipboard-text="newPassword" type="button" class="btn btn-primary copyPwdBtn" style="width:100px;">复制</button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<button v-if="!newPassword" type="button" class="btn btn-primary" style="width:100px;" @click="resetPwd">提交</button></center>
		</form>
	</div>
</body>
</html>