<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容官网轮播图管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/gcWeb/banner/">轮播图列表</a></li>
    <shiro:hasPermission name="gcWeb:banner:add">
        <li><a href="${ctx}/gcWeb/banner/form">轮播图添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="gcWebBanner" action="${ctx}/gcWeb/banner/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>标题：</label>
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>显示标记：</label>
            <form:select path="showFlag" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>标题</th>
        <th>图片</th>
        <th>小图</th>
        <th>显示标记</th>
        <th>排序</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="gcWebBanner">
        <tr>
            <td>
                    ${gcWebBanner.title}
            </td>
            <td>
                <img id="image" src="${gcWebBanner.image}" style="height:50px;"/>
            </td>
            <td>
                <img id="smallImage" src="${gcWebBanner.smallImage}" style="height:50px;"/>
            </td>
            <td>
                    ${fns:getDictLabel(gcWebBanner.showFlag, 'show_hide', '')}
            </td>
            <td>
                    ${gcWebBanner.sort}
            </td>
            <td>
                <shiro:lacksPermission name="gcWeb:banner:edit">
                    <a href="${ctx}/gcWeb/banner/form?id=${gcWebBanner.id}">查看</a>
                </shiro:lacksPermission>
                <shiro:hasPermission name="gcWeb:banner:edit">
                    <a href="${ctx}/gcWeb/banner/form?id=${gcWebBanner.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="gcWeb:banner:del">
                    <a href="${ctx}/gcWeb/banner/delete?id=${gcWebBanner.id}"
                       onclick="return confirmx('确认要删除该美容官网轮播图吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>