<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>登记卡管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
        function deleteAll(id){
			var remarks = prompt("删除原因:","");
			if(remarks){
				window.location.href="${ctx}/birthcertificate/dogBirthCertificate/deleteAll?remarks="+remarks+"&id="+id;
			}else if(remarks == ""){
				alert("删除原因不能为空！！");
			} else{
				return false;
			}
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/birthcertificate/dogBirthCertificate/list">登记卡管理</a></li>
		<shiro:hasPermission name="birthcertificate:dogBirthCertificate:edit">
		</shiro:hasPermission>
	    <li><a href="${ctx}/birthcertificate/dogBirthCertificate/transferList">登记卡变更</a></li>
	</ul>
	<%-- <ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/user/member/">会员列表</a></li>
		<shiro:hasPermission name="sys:user:member:add"><li><a href="${ctx}/sys/user/member/form">添加会员</a></li></shiro:hasPermission>
		<shiro:hasPermission name="sys:user:member:tcadd"><li><a href="${ctx}/sys/user/member/tcform">淘宠会员注册</a></li></shiro:hasPermission>
	</ul> --%>
	<form:form id="searchForm" modelAttribute="dogBirthCertificate" action="${ctx}/birthcertificate/dogBirthCertificate/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCerRegCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>配种证明编号：</label>
				<form:input path="fmdogBreedCertifiedCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬主/繁殖人：</label>
				<form:input path="dogOwenr" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>付款的状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_birth_certificate_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>加急状态：</label>
				<form:select path="urgent" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('urgent_status')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>区域：</label>
                <form:select path="agency" class="input-medium">
                	<form:option value="" label="全部"/>
                	<form:options items="${agencyList}" itemLabel="name" itemValue="id" htmlEscape="false"/>
                </form:select>
			</li>
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>打印类型：</label>
				<form:select path="newbornPrintType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('print_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>打印状态：</label>
				<form:select path="printStatus" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="全部未打印"/>
					<form:option value="2" label="身份登记卡未打印"/>
					<form:option value="3" label="等级贴纸未打印"/>
					<form:option value="4" label="已打印"/>
					<%--<form:options items="${fns:getDictList('birth_certificate_print_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>--%>
				</form:select>
			</li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>宠爱护照号：</label>
				<form:input path="cabPassportLike" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>

			<li><label>宠爱登记卡号：</label>
				<form:input path="cabRegisterCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>

			<li><label>激活状态：</label>
                <form:select path="activitionState" class="input-medium">
                    <form:option value="" label="全部"/>
					<form:option value="3" label="寄出待激活"/>
					<form:option value="4" label="超期未激活"/>
					<form:option value="0" label="激活中"/>
                    <form:option value="1" label="已完成"/>
                    <form:option value="2" label="激活失败"/>
                </form:select>
            </li>
			<li><label>上架状态：</label>
                <form:select path="upperStatus" class="input-medium">
                    <form:option value="" label="全部"/>
					<form:option value="0" label="已上架"/>
					<form:option value="1" label="已下架"/>
					<form:option value="2" label="未上架"/>
					<form:option value="3" label="待审核"/>
					<form:option value="4" label="审核失败"/>
                </form:select>
            </li>
			<li><label>办理方式：</label>
				<form:select path="isAll" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('birth_transact')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>犬种：</label>
				<form:input path="dogBreed" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>配种证明编号</th>
				<th>性别</th>
				<th>英文犬名</th>
				<th>犬种</th>
				<th>出生日期</th>
				<th>授权码</th>
				<th>芯片号码</th>
				<th>宠爱护照号</th>
				<th>宠爱登记卡号</th>
				<th>繁殖人</th>
				<th>加急</th>
				<th>抵扣</th>
				<th>缴费状态</th>
				<th>缴费日期</th>
				<th>业务状态</th>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:audit"><th>初审</th></shiro:hasPermission>
				<th>办理方式</th>
				<th>类型</th>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print"><th>登记卡打印</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print"><th>等级打印</th></shiro:hasPermission>
				<th>激活复审</th>
				<th>上架状态</th>
				<th>上架审核</th>
				<%--<shiro:hasPermission name="birthcertificate:dogBirthCertificate:review"><th>激活复审</th></shiro:hasPermission>--%>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:view"><th>管理</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:delete"><th>删除</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:deleteALL"><th>整窝删除</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:desensitize(dogBirthCertificate.birthCerRegCode,4)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.fmdogBreedCertifiedCode)}
				</td>
				<td>
					${fns:getDictLabel(dogBirthCertificate.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogEnName)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogBreed)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.snCode)}
				</td>
				<td>
					${fns:desensitize(dogBirthCertificate.identificationFlag,2)}
				</td>
				<td>
					${fns:desensitize(dogBirthCertificate.cabPassport,3)}
				</td>
				<td>
						${fns:desensitize(dogBirthCertificate.cabRegisterCode,5)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.breeder)}
				</td>
				<td style="color:${dogBirthCertificate.urgent=='1'?'#F00':''}">
					${fns:getDictLabel(dogBirthCertificate.urgent, 'urgent_status', '')}
				</td>
				<td>
					<c:if test="${fns:escapeHtml(dogBirthCertificate.deduction)=='0'}">
							<font>否</font>
					</c:if>
					<c:if test="${fns:escapeHtml(dogBirthCertificate.deduction)=='1'}">
						<font color="red">是</font>
					</c:if>
				</td>
				<td style="color:${dogBirthCertificate.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogBirthCertificate.paymentState, 'user_payment_state', '未缴费')}
				</td>
				<td style="color:${empty dogBirthCertificate.snCode?'#F00':'#000'}">
                    <fmt:formatDate value="${dogBirthCertificate.paymentTime}" pattern="yyyy-MM-dd"/>
                </td>
				<td>
					${dogBirthCertificate.businessState}
				</td>
				
				
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:audit">
				<td style="color:#000">
					<c:if test="${dogBirthCertificate.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogBirthCertificate.businessRefundState}">
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" >
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogBirthCertificate.reviewState=='0'}">
							<a style="color:#F00" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogBirthCertificate.reviewState=='2'}">
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:otherwise>
					</c:choose>
					</c:if>
    			</td>
				</shiro:hasPermission>
				<td>
					<c:if test="${'1' eq dogBirthCertificate.isAll}">整窝办理</c:if>
					<c:if test="${'0' eq dogBirthCertificate.isAll}">单只办理</c:if>
				</td>
				
				<td>
					
					<c:if test="${'0' eq  dogBirthCertificate.ecertFlag}">纸质版</c:if>
					<c:if test="${'1' eq  dogBirthCertificate.ecertFlag}">电子版</c:if>
				</td>
		
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print">
				<td>
					<c:if test="${'0' eq dogBirthCertificate.ecertFlag}"> 
						<c:if test="${dogBirthCertificate.paymentState=='2'&&dogBirthCertificate.reviewState=='1'   && !dogBirthCertificate.businessRefundState}">
							<c:if test="${dogBirthCertificate.printType=='0'||dogBirthCertificate.printType=='1'}">
		    					<a href="${ctx}/birthcertificate/dogBirthCertificate/print?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印吗？', this.href)">
		    					${fns:getDictLabel(dogBirthCertificate.newbornPrintType, 'birth_certificate_print_type', '')}</a>
							</c:if>
							<c:if test="${dogBirthCertificate.printType=='9'}">
		    					<a href="${ctx}/birthcertificate/dogBirthCertificate/resetPrint?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印重置吗？', this.href)">
		    					${fns:getDictLabel(dogBirthCertificate.printType, 'birth_certificate_print_type', '')}</a>
							</c:if>
						</c:if>
					</c:if>
    			</td>
				<td>
					<c:if test="${'0' eq dogBirthCertificate.ecertFlag}"> 
						<c:if test="${dogBirthCertificate.classPrintFlag && dogBirthCertificate.paymentState=='2'&&dogBirthCertificate.reviewState=='1' && dogBirthCertificate.isAll != '1' && !dogBirthCertificate.businessRefundState}">
							<c:if test="${dogBirthCertificate.classPrintStatus=='0'||dogBirthCertificate.classPrintStatus=='1'}">
								<a href="${ctx}/birthcertificate/dogBirthCertificate/classPrint?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印吗？', this.href)">
										${fns:getDictLabel(dogBirthCertificate.newbornPrintType, 'birth_certificate_print_type', '')}</a>
							</c:if>
							<c:if test="${dogBirthCertificate.classPrintStatus=='9'}">
								<a href="${ctx}/birthcertificate/dogBirthCertificate/resetClassPrint?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印重置吗？', this.href)">
										${fns:getDictLabel(dogBirthCertificate.classPrintStatus, 'birth_certificate_print_type', '')}</a>
							</c:if>
						</c:if>
					</c:if>
				</td>
				</shiro:hasPermission>
		
				<%--<shiro:hasPermission name="birthcertificate:dogBirthCertificate:review">--%>
				<td>
					<c:if test="${dogBirthCertificate.businessState=='激活中' }">
						<a href="${ctx}/dog/dogActivation/review?id=${dogBirthCertificate.id}">图片审核</a>
					</c:if>
    			</td>
				<td>
					${dogBirthCertificate.businessState eq "已完成"?dogBirthCertificate.upperStatus:""}
    			</td>
				<td>
					<c:if test="${dogBirthCertificate.upperStatus=='待审核'}">
						<a href="${ctx}/dog/dogActivation/review?id=${dogBirthCertificate.id}">审核</a>
					</c:if>
    			</td>
				<%--</shiro:hasPermission>--%>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:view">
				<td>
    				<a href="${ctx}/birthcertificate/dogBirthCertificate/form?id=${dogBirthCertificate.id}">查看</a>
					<c:if test="${!dogBirthCertificate.businessRefundState}">
    				<a href="${ctx}/birthcertificate/dogBirthCertificate/editForm?id=${dogBirthCertificate.id}">编辑</a>
					</c:if>
					<c:if test="${dogBirthCertificate.upperStatus eq '已上架'}">
						<c:if test="${dogBirthCertificate.firstStatus == '1' || empty dogBirthCertificate.firstStatus}">
							<a href="${ctx}/birthcertificate/dogBirthCertificate/firstStatus?id=${dogBirthCertificate.id}">
								<font color="red"> 置顶</font></a>
						</c:if>
						<c:if test="${dogBirthCertificate.firstStatus == '2'}">
							<a href="${ctx}/birthcertificate/dogBirthCertificate/firstStatus?id=${dogBirthCertificate.id}">
								<font color="red">取消置顶</font></a>
						</c:if>
					</c:if>
					<c:if test="${dogBirthCertificate.reviewState=='3' && empty dogBirthCertificate.regetNewBirthCode }">
					<a href="${ctx}/birthcertificate/dogBirthCertificate/reGetForm?id=${dogBirthCertificate.id}">重领</a>
					</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:delete">
    			<td>
                    <c:if test="${ !dogBirthCertificate.businessRefundState}">
						<a href="${ctx}/birthcertificate/dogBirthCertificate/delete?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要删除该登记卡吗？', this.href)">删除</a>
					</c:if>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:deleteALL">
				<td>
					<c:if test="${ !dogBirthCertificate.businessRefundState}">
						<a href="#" onclick="deleteAll('${dogBirthCertificate.id}')">整窝删除</a>
					</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>