package com.cku.restful.v1.show.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ChildShowsDao;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.dao.ShowJudgeDao;
import com.cku.oa.show.dao.ShowReportInfoDao;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.CkuImage;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowJudge;
import com.cku.oa.show.entity.ShowMainJudgeInfo;
import com.cku.oa.show.entity.ShowReportInfo;
import com.cku.oa.show.service.ShowMainJudgeInfoService;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.restful.v1.show.model.CKUShowReportInfo;
import com.cku.restful.v1.show.model.RestChildShows;
import com.cku.restful.v1.show.model.RestRefereeInfo;
import com.cku.restful.v1.show.model.RestShowJudge;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import net.sf.json.JSONObject;

/**
 *
 * <p>Title:RestShowsService </p>
 * <p>Description: 赛事相关服务层</p>
 * <p>Company: </p>
 * @author zhuoHeng
 * @date 2016年9月23日 上午10:22:01
 */
@Service
@Transactional(readOnly = true)
public class APPShowsService {
	@Autowired
	public MainShowsDao mainShowsDao;
	@Autowired
	public ChildShowsDao childShowsDao;
	@Autowired
	private ShowReportInfoDao showReportInfoDao;
	@Autowired
	private ShowJudgeDao showJudgeDao;
	@Autowired
	private ShowMainJudgeInfoService showMainJudgeInfoService;



	public RESTResponse review(HttpServletRequest request) {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String year = request.getParameter("year");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if(StringUtils.isNotBlank(pageNo)){
				pageNoInt = Integer.parseInt(pageNo);
			}
			if(StringUtils.isNotBlank(pageSize)){
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"pageNo和pageSize必须都为数字");
		}
		//判断年份，只可显示17年之后数据
		if (StringUtils.isNotBlank(year)
				&& 2017 > Integer.parseInt(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年份需大于等于2017年");
		}
		List<MainShows> mainShowsList = mainShowsDao.findCloseMainShows(year,(pageNoInt-1)*pageSizeInt,pageSizeInt);
		List<JSONObject> list = new ArrayList<JSONObject>();
		for(MainShows mainShows:mainShowsList){
			CkuImage ckuImage = mainShowsDao.getCkuImage(mainShows.getShowLocation());
			JSONObject jo = new JSONObject();
			jo.put("mainShowId",getString(mainShows.getId()));
			jo.put("thumbnailImage",getString(ImgUtil.getImgUrl(request,mainShows.getThumbnailImage())));
			jo.put("handerImage",getString(ImgUtil.getImgUrl(request,mainShows.getHanderImage())));
			if(ckuImage == null){
				jo.put("image_min_url","");
				jo.put("image_max_url","");
			}else {
				jo.put("image_min_url",ckuImage.getImageMinUrl());
				jo.put("image_max_url",ckuImage.getImageMaxUrl());
			}
			jo.put("mainShowName",getString(mainShows.getMainShowName()));
			String organizer = mainShows.getOrganizer();
			jo.put("organizer",DictUtils.getDictLabel(organizer, "show_organizer", ""));
			jo.put("showLocation",getString(mainShows.getShowLocation()));
			jo.put("showAddress",getString(mainShows.getShowLocation().split("-")[0]));
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
			jo.put("startTime",getString(sdf.format(mainShows.getStartTime())));
			jo.put("endTime",getString(sdf.format(mainShows.getEndTime())));
			list.add(jo);
		}
		long count = mainShowsDao.countCloseMainShows(year);
		return new RESTResponse("list",new PageBeanResult<>(list,count));
	}
	private static String getString(String str){
		return str==null?"":str;
	}

	public RESTResponse getChildListByMainId(HttpServletRequest request) {
		String mainId = request.getParameter("mainId");

		HashMap<String ,List<CKUShowReportInfo>> map =new HashMap<String ,List<CKUShowReportInfo>>();
		List<CKUShowReportInfo> listinmap = new ArrayList<CKUShowReportInfo>();
		//1，从子赛事表中查出所有子赛事
		List<ChildShows> childList = childShowsDao.getByMainShowId(mainId);
		//2，查询已经录入的赛事播报信息
		List<ShowReportInfo> re = showReportInfoDao.getChildListByMainId(mainId);
		for(ChildShows childShows : childList){
			if(!"0".equals(childShows.getShowRules())){
				continue;
			}
			String insertReportId = null;
			if(re!=null && re.size()>0){
				for(ShowReportInfo showReportInfo: re){
					if(childShows.getShowCode().equals(showReportInfo.getShowCode())){
						insertReportId = showReportInfo.getId();
					}
				}
			}
			String showCode = childShows.getShowCode();
			String shortName = ("0".equals(childShows.getCacType())?"CAC":"CACIB")+"-" +showCode.substring(showCode.lastIndexOf("-")+1,showCode.length());

			listinmap.add(new CKUShowReportInfo(insertReportId,childShows.getShowCode(),childShows.getShowName(),
					childShows.getStartTime(),childShows.getEndTime(),shortName));
		}
		map.put("childList",listinmap);
		return new RESTResponse("data",map);
	}
	public RESTResponse getChildListInfoByMainId(HttpServletRequest request) {
		String mainId = request.getParameter("mainId");
		//1，从子赛事表中查出所有子赛事
		List<ChildShows> childList = childShowsDao.getByMainShowId(mainId);

		List<RestChildShows> listinmap = new ArrayList<RestChildShows>();
		MainShows mainShow = mainShowsDao.get(mainId);
		for(ChildShows childShows : childList){
			String showCode = childShows.getShowCode();
			String shortName = ("0".equals(childShows.getCacType())?"CAC":"CACIB")+"-" +showCode.substring(showCode.lastIndexOf("-")+1,showCode.length());
			//子赛事多个裁判
			List<RestRefereeInfo> refereeInfoList = new ArrayList<>();
			if(StringUtils.isNotBlank(childShows.getReferee())) {
				String[] ids = childShows.getReferee().split(",");
				List<String> idsList = Arrays.asList(ids);
				List<ShowJudge> showJudges = showJudgeDao.findByIds(idsList);
				for(ShowJudge showJudge: showJudges) {
					refereeInfoList.add(new RestRefereeInfo(showJudge.getCitizenship(),showJudge.getJudgeName(),showJudge.getId()));
				}
			}
			ShowJudge showJudge = showJudgeDao.get(childShows.getReferee());
			RestChildShows restChildShows = new RestChildShows(childShows.getId(),childShows.getShowName() == null ? null : StringEscapeUtils.unescapeHtml4(childShows.getShowName()),shortName,
					DateUtils.formatDateTime(childShows.getStartTime()),DateUtils.formatDateTime(childShows.getEndTime()),
					getString(childShows.getReferee()),
					showJudge==null?null: StringEscapeUtils.unescapeHtml4(showJudge.getJudgeName()),
					showJudge==null?null:showJudge.getCitizenship());
			for (RestRefereeInfo restRefereeInfo : refereeInfoList) {
				if (StringUtils.isNotBlank(restRefereeInfo.getRefereeName())) {
					String refereeName = StringEscapeUtils.unescapeHtml4(restRefereeInfo.getRefereeName());
					restRefereeInfo.setRefereeName(refereeName);
				}
			}
			restChildShows.setRefereeInfoList(refereeInfoList);
			restChildShows.setMainShowId(mainId);
			listinmap.add(restChildShows);
		}
		return new RESTResponse("data",listinmap);
	}

	public RESTResponse getShowJudgeInfo(HttpServletRequest request) {
		String referee = request.getParameter("referee");
		String mainShowId = request.getParameter("mainShowId");

		ShowJudge showJudge = showJudgeDao.get(referee);
		showJudge.setJudgeSex(showJudge.getJudgeSex() == "1" ? "男" : "女");
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image/" + showJudge.getJudgePicture();
		//使用哪个裁判照片 是否为show特殊类型 0国秀裁判照 1默认裁判照 2特殊裁判照 
		MainShows mainShow = mainShowsDao.get(mainShowId);
		if("0".equals(mainShow.getIsShowType())&&StringUtils.isNotBlank(showJudge.getShowTypeJudgePicture())) {
			 imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + 
					 path + "/api/v1/open/image/" + showJudge.getShowTypeJudgePicture();
		}else if("2".equals(mainShow.getIsShowType())) {
			ShowMainJudgeInfo showMainJudgeInfo = showMainJudgeInfoService.findByShowMainIdAndshowJudgeId(mainShowId, referee);
			if(showMainJudgeInfo!=null&&StringUtils.isNotBlank(showMainJudgeInfo.getShowJudgePicture())) {
				 imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + 
						 path + "/api/v1/open/image/" + showMainJudgeInfo.getShowJudgePicture();
			}
		}
		RestShowJudge restShowJudge = new RestShowJudge(StringEscapeUtils.unescapeHtml4(showJudge.getJudgeName()), imgPath, showJudge.getCitizenship(),
				StringEscapeUtils.unescapeHtml4(showJudge.getIntroduce()), StringEscapeUtils.unescapeHtml4(showJudge.getJudgeTitle()), showJudge.getJudgeTitleShort());
		
		return new RESTResponse("data",restShowJudge);
	}

	public RESTResponse getcheduleImageByMainId(HttpServletRequest request) {
		String mainId = request.getParameter("mainId");
		HashMap<String ,Object> map =new HashMap<String ,Object>();

		MainShows mainShows = mainShowsDao.get(mainId);
		String scheduleImage = mainShows.getScheduleImage();
		if(StringUtils.isNotBlank(scheduleImage)){
			String path = request.getContextPath();
			String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image/" + scheduleImage;
			map.put("scheduleImage",imgPath);
		}else{
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬展时间安排表更新中，敬请期待");
		}
		return new RESTResponse("data",map);
	}
}
