package com.cku.restful.v1.open;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.cku.core.ResultDto;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.subscription.restful.service.WXpayServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value = "公众号OAuth2获取授权-xuxue", tags = { "公众号OAuth2获取授权-xuxue" })
@RestController
@RequestMapping(value = "api/v1/open/subscription/auth2/")
public class WXOAuth2Controller extends BaseRestController {

	@Autowired
	private WXpayServiceImpl wxpayServiceImpl;


	@ApiOperation(value = "获取openid")
	@RequestMapping(value = "getOpenId", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<String> getOpenId(@RequestBody String json, HttpServletRequest request) throws Exception {
		HashMap<String, String> map = JSON.parseObject(json, HashMap.class);
		String code = map.get("code");
		return wxpayServiceImpl.getOpenId(code);

	}


}
