package com.cku.restful.v1.kennel.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelRename;
import com.cku.oa.kennel.service.KennelRenameService;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.entity.ExpressQueue;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.restful.v1.kennel.model.RestKennelRename;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 犬舍名称变更Service
 * 
 * @author zhuguanjin
 * @version 2016-08-15
 */
@Service
@Transactional(readOnly = true)
public class RestKennelRenameService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME = "kennel_rename@BG";
	private static final String KENNEL_RENAME_PERMANENT = "kennel_rename@PBG";

	@Autowired
	private KennelRenameService kennelRenameService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private ExpressQueueService expressQueueService;

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids) {

		Member member = UserUtils.getLoginMember();
		KennelRename example = new KennelRename();
		// 设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setId(ids);
		List<KennelRename> kennelRenameList = kennelRenameService.findList(example);
		List<RestKennelRename> list = new ArrayList<RestKennelRename>();
		for (KennelRename kennelRename : kennelRenameList) {
			RestKennelRename vo = new RestKennelRename();
			BeanUtil.copyProperties(vo, kennelRename, "yyyy-MM-dd");
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			list.add(vo);
		}
		return new RESTResponse("data", list);
	}

	private void validateRefundState(KennelRename po, RestKennelRename vo) {
		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(po.getId(),
				po.getRunningNumber());
		if (vo == null) {
			if (!canCanceled)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
		} else {
			vo.setCanEdit(canCanceled);
		}
	}

	public RESTResponse getList(HttpServletRequest request) {

		Member member = UserUtils.getLoginMember();

		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		KennelRename example = new KennelRename();
		// 设置分页参数
		Page<KennelRename> page = new Page<KennelRename>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);

		// 查询并组装返回对象
		Page<KennelRename> result = kennelRenameService.findPage(page, example);
		List<KennelRename> kennelRenameList = result.getList();
		List<RestKennelRename> list = new ArrayList<RestKennelRename>();
		for (KennelRename kennelRename : kennelRenameList) {
			RestKennelRename vo = new RestKennelRename();
			BeanUtil.copyProperties(vo, kennelRename, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			this.validateRefundState(kennelRename, vo);
			
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestKennelRename>(list, count));
	}

	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		KennelRename kennelRename = kennelRenameService.get(id);
		if (kennelRename == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(kennelRename.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestKennelRename vo = new RestKennelRename();
		BeanUtil.copyProperties(vo, kennelRename, "yyyy-MM-dd");
		vo.setMemberName(member.getName());
		String memberType = "";
		if ("basic".equals(member.getMemberType())) {
			memberType = "基础会员";
		} else if ("professional".equals(member.getMemberType())) {
			memberType = "专业会员";
		}
		vo.setMemberType(memberType);
		String memberEndTime = "";
		if (member.getMemberEndDate() != null) {
			memberEndTime = new SimpleDateFormat("yyyy-MM-dd").format(member.getMemberEndDate());
		}
		vo.setMemberEndTime(memberEndTime);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(PAYMENTCHARGINGITEM_SHORTNAME);
		vo.setPrice(paymentChargingItem.getPrice());
		return new RESTResponse("data", vo);
	}

	/**
	 * 
	 * @description: 校验参数
	 * @author: laiguanglong
	 * @date: 2016年9月12日 下午5:28:41
	 */
	private void validateParameter(KennelRename vo) {
		if (StringUtils.isBlank(vo.getNewNameCn())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬舍中文名为空");
		}
		if (StringUtils.isBlank(vo.getNewNameEn())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬舍英文名为空");
		}
	}

	/**
	 * 
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private KennelRename buildPo(KennelRename vo) {
		KennelRename po = new KennelRename();
		Member member = UserUtils.getLoginMember();
		Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
		if (kennel == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员还没有关联的犬舍");
		}
		if (!"1".equals(kennel.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "该业务仅限审核状态为通过的犬舍办理");
		}
		po.setMemberCode(member.getMemberCode());
		po.setKennelCode(member.getMemberCode());
		po.setOriginalNameCn(kennel.getName());
		po.setOriginalNameEn(kennel.getNameEn());
		po.setNewNameCn(vo.getNewNameCn());
		po.setNewNameEn(vo.getNewNameEn());
		po.setFciKennel(vo.getFciKennel());
		po.setFciKennelBackup(vo.getFciKennelBackup());
		po.setPaymentMoney(getPriceString());
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProcessState("0");
		po.setMedalFlag(vo.getMedalFlag());
		return po;
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		KennelRename vo = BeanUtil.toBean(json, KennelRename.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		KennelRename po = buildPo(vo);
		// 业务校验
		kennelRenameService.validateBusiness(po);
		// 订单重复校验
		KennelRename example = new KennelRename();
		example.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		example.setProcessState("0");
		List<KennelRename> kennelRenameList = kennelRenameService.findList(example);
		// 排除已撤销的记录
		for (Iterator<KennelRename> it = kennelRenameList.iterator(); it.hasNext();) {
			KennelRename item = it.next();
			if ("3".equals(item.getReviewState())) {
				it.remove();
			}
		}
		if (kennelRenameList.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有未处理的犬舍名称变更订单，请处理后再提交");
		}
		// 写入业务表
		kennelRenameService.save(po);
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
		paymentCartService.addToCart(paymentCart, "1022");
		Member member = UserUtils.getLoginMember();
//		Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
		Integer cardType = UserUtils.getMemberCardType(member);
		
		if(!"40".equals(cardType.toString()) && "1".equals(vo.getMedalFlag()) ) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有紫金卡用户可选永久犬舍铜牌补做！");
		}
		
		StringBuilder cartIds = new StringBuilder();
		cartIds.append(paymentCart.getId());
		if ("1".equals(vo.getMedalFlag())) {
			// 永久犬舍名称变更需要加入额外的收费项
			PaymentCart paymentCartPermanent = buildPaymentCartPermanent(po, businessOrderCode);
			paymentCartService.addToCart(paymentCartPermanent, "1022");
			cartIds.append(",").append(paymentCartPermanent.getId());
		}
		return new RESTResponse("data", cartIds.toString());
	}

	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		Member member = UserUtils.getLoginMember();
		// json转换为对象
		KennelRename vo = BeanUtil.toBean(json, KennelRename.class);
		// 参数校验
		validateParameter(vo);
		if (StringUtils.isBlank(vo.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍名称变更id为空");
		}
		// 业务校验
		kennelRenameService.validateBusiness(vo);
		KennelRename kennelRename = kennelRenameService.get(vo.getId());
		if (kennelRename == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍名称变更id有误");
		}
		if (!member.getMemberCode().equals(kennelRename.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍名称变更id有误");
		}
		if ("1".equals(kennelRename.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍名称变更已通过审核，不允许修改");
		}
		this.validateRefundState(kennelRename, null);
		// 更新,并且更新后改为待审核
		kennelRename.setNewNameCn(vo.getNewNameCn());
		kennelRename.setNewNameEn(vo.getNewNameEn());
		kennelRename.setFciKennel(vo.getFciKennel());
		kennelRename.setFciKennelBackup(vo.getFciKennelBackup());
		kennelRename.setReviewState("0");
		kennelRenameService.save(kennelRename);
		return new RESTResponse();
	}

	private PaymentCart buildPaymentCart(KennelRename po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("kennel_rename");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1022");
	}

	private PaymentCart buildPaymentCartPermanent(KennelRename po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = getPaymentChargingItemPermanent();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("kennel_rename");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1022");
	}

	/**
	 * 
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月12日 上午10:01:23
	 */
	public RESTResponse orderDetail(String id) {
		KennelRename model = kennelRenameService.get(id);
		Map<String, String> map = new HashMap<>();
		map.put("key1", model.getKennelCode());
		map.put("key2", model.getOriginalNameCn());
		map.put("key3", model.getNewNameCn());
		map.put("key4", model.getMemberCode());
		map.put("key5", model.getOriginalNameEn());
		map.put("key6", model.getNewNameEn());
		map.put("key7", model.getFciKennel());
		map.put("key8", model.getFciKennelBackup());
		return new RESTResponse("data", map);
	}

	/**
	 * 获取犬舍更名详细及审核信息
	 * 
	 * @author yuanshuai
	 * @data 2017年3月21日 上午11:20:28
	 */
	public RESTResponse getRenameDetail(String memberCode) {
		KennelRename kennelRename = kennelRenameService.getTopByMemberCode(memberCode);
		Map<String, String> map = new HashMap<>();
		map.put("originalNameCn", kennelRename.getOriginalNameCn());
		map.put("originalNameEn", kennelRename.getOriginalNameEn());
		map.put("newNameCn", kennelRename.getNewNameCn());
		map.put("newNameEn", kennelRename.getNewNameEn());
		map.put("fciKennel", kennelRename.getFciKennel());
		map.put("fciKennelBackup", kennelRename.getFciKennelBackup());
		map.put("reviewState", kennelRename.getReviewState());
		return new RESTResponse("data", map);
	}

	/**
	 * @description: 获取犬舍名称变更收费项
	 * @author: laiguanglong
	 * @date: 2017/5/12 17:19
	 */
	private PaymentChargingItem getPaymentChargingItem() {
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(PAYMENTCHARGINGITEM_SHORTNAME);
		return paymentChargingItem;
	}

	/**
	 * @description: 获取永久犬舍名称变更额外收费项
	 * @author: laiguanglong
	 * @date: 2017/5/12 17:19
	 */
	private PaymentChargingItem getPaymentChargingItemPermanent() {
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(KENNEL_RENAME_PERMANENT);
		return paymentChargingItem;
	}

	/**
	 * @description: 获取犬舍名称变更价格字符串
	 * @author: laiguanglong
	 * @date: 2017/5/12 17:31
	 */
	private String getPriceString() {
		Member member = UserUtils.getLoginMember();
		Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
		// 犬舍变更基础收费项 120
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem();
		Double price = Double.parseDouble(paymentChargingItem.getPrice());
		// 永久犬舍变更多收 100
		if ("permanent".equals(kennel.getType())) {
			PaymentChargingItem paymentChargingItemPermanent = getPaymentChargingItemPermanent();
			price = price + Double.parseDouble(paymentChargingItemPermanent.getPrice());
		}
		return price.toString();
	}

	private String getPriceString(String medalFlag) {
		Member member = UserUtils.getLoginMember();
//		Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem();
		Double price = Double.parseDouble(paymentChargingItem.getPrice());
		
		Integer cardType = UserUtils.getMemberCardType(member);
		if(!"40".equals(cardType.toString()) && "1".equals(medalFlag) ) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有紫金卡用户可选永久犬舍铜牌补做！");
		}
		if ("1".equals(medalFlag)) {
			PaymentChargingItem paymentChargingItemPermanent = getPaymentChargingItemPermanent();
			price = price + Double.parseDouble(paymentChargingItemPermanent.getPrice());
		}
		return price.toString();
	}
	
	public RESTResponse getPrice() {
		JSONObject jo = new JSONObject();
		jo.put("price", getPriceString());
		return new RESTResponse("data", jo);
	}
	
	public RESTResponse getPrice(HttpServletRequest request) {
		String medalFlag = request.getParameter("medalFlag");
		JSONObject jo = new JSONObject();
		jo.put("price", getPriceString(medalFlag));
		return new RESTResponse("data", jo);
	}
}