package com.cku.restful.v1.groomer.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.groomer.service.InternationalGroomerCertificateService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 国际美容证书申领
 * 
 * @author zhaoxy
 *
 */
@Controller
@RequestMapping(value = "/api/v1/lngroomer")
public class RettGroomerApply extends BaseRestController {

	@Autowired
	private InternationalGroomerCertificateService internationalGroomerCertificateService;

	
	/**
	 * 国际美容证书申领列表
	 */
	@RequestMapping(value = "/applyList", method = RequestMethod.GET)
	@ResponseBody
	public void applyList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		/*
		 * param	
		 * 	 token
		 */
		RESTResponse result = internationalGroomerCertificateService.getApplyList(request);
		ServletUtils.writeResponse(response, result);
	}
	
	
	/**
	 * 国际美容证书申领
	 */
	@RequestMapping(value = "/apply", method = RequestMethod.GET)
	@ResponseBody
	public void apply(HttpServletRequest request, HttpServletResponse response) throws IOException {
		/*
		 * param	
		 * 	 token
		 *   certificateType ISPG:国际高级证书  IPG:国际证书
		 */
		RESTResponse result = internationalGroomerCertificateService.applyCertificate(request);
		ServletUtils.writeResponse(response, result);
	}
	
	
	
}
