/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.oa.breeder.dao.BannerDao;
import com.cku.oa.breeder.entity.Banner;
import com.cku.oa.sys.util.ImgUtil;
import com.google.common.collect.Lists;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Service
@Transactional(readOnly = true)
public class RestBannerService {

    @Autowired
    private BannerDao bannerDao;

    public RESTResponse banner(HttpServletRequest request) {
        List<JSONObject> list = Lists.newArrayList();
        List<Banner> bannerList = bannerDao.getByModule("breeder");
        for (Banner banner : bannerList) {
            JSONObject jo = new JSONObject();
            jo.put("img", ImgUtil.getImgUrl(request, banner.getImg()));
            jo.put("url", banner.getUrl());
            jo.put("type", banner.getType());
            jo.put("programId", banner.getProgramId());
            list.add(jo);
        }
        return new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size())));
    }

}