package com.cku.oa.timedtask.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.show.service.MainShowsService;

@Service
@Transactional(readOnly = true)
public class TestTask extends JobActingService{

	@Autowired
	private MainShowsService mainShowsService;
	
	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			mainShowsService.updateRegisterFlag();//此处需要返回执行条数
		} catch (Exception e) {
			count = -1;
		} finally {
			return count;
		}
	}

	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			mainShowsService.updateRegisterFlag();//此处需要返回执行条数
		} catch (Exception e) {
			count = -1;
		} finally {
			return count;
		}
	}
	
	

}
