package com.cku.oa.sys.code;

import com.cku.oa.sys.entity.Org;
import com.cku.util.DateUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/5
 * Time: 18:14
 */
public class SysCodeUtil implements ApplicationContextAware {

    private static final String CKU = "CKU";
    private static final String CKUJD = "CKUJD";//淘宠鉴定证书
    private static final String CKUCN = "NO.CKU CH./";
    private static final String CKUJH = "NO.CKU JH./";
    private static final String INTCH = "INT.CH";
    private static final String GROOMER = "G";
    private static final String HANDLER = "H";
    private static final String ELITE = "ETS";
    private static final String DNA = "DNA#";
    private static final String SEMEN = "JZ";
    private static final String SEMEN_BATCH = "JZPC";
    private static final String LINK = "-";
    private static final String BLINK= "/";
    private static final String COUPON= "YHJ";
    private static final String CDSC = "CDSC";
    private static final String JS = "JS";

    private static final String PDG = "PDG";

    private static final String TRAINER = "T";

    private static ApplicationContext applicationContext; // Spring应用上下文环境
    private static SysCodeService sysCodeService;
    private static SysCodeGroomerService sysCodeGroomerService;
    private static String[] yearColumn  = new String[]{"match_code","groom_activity_code","handler_activity_code"};
    public static Long duGaoTimeMillis = null;

    static{
        try {
            duGaoTimeMillis = new SimpleDateFormat("yyyy-MM-dd").parse("2017-08-01").getTime();
        } catch (ParseException e) {
            System.out.println("杜高血统证书号变化判断时间格式化出错");
        }
    }
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SysCodeUtil.applicationContext = applicationContext;
        SysCodeUtil.sysCodeService = SysCodeUtil.getBean("sysCodeService");
        SysCodeUtil.sysCodeGroomerService = SysCodeUtil.getBean("sysCodeGroomerService");
    }
    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
    @SuppressWarnings("unchecked")
    public static <T> T getBean(String name) throws BeansException {
        return (T) applicationContext.getBean(name);
    }
    /**
     * 会员编号：以当前基数递增
     * @return 会员编号
     */
	public static synchronized String getMemberCode() {
		String resultCode = null;
		String code = sysCodeService.getCode("member_code");
		resultCode = (Long.parseLong(code) + 1) + "";
		sysCodeService.updateCode("member_code", resultCode);
		return resultCode;
	}
    /**
     * 合作机构会员编号：以当前基数递增
     * @return 合作机构会员编号
     */
    public static synchronized String getHZMemberCode(Org org){
        String resultCode = null;
        String code = sysCodeService.getCode("hzmember_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("hzmember_code",resultCode);
        if(org.getOrgType().equals("hospital")){
            return "HOSP"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
        }else if(org.getOrgType().equals("club")){
            return "HZ"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
        }else if(org.getOrgType().equals("chongjihemendian")){
            return "CJH"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
        }else if(org.getOrgType().equals("catRenZheng")){
            return "CAB"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
        }else if(org.getOrgType().equals("singleTypeClub")){
			return "DQZ"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
		}
        return "";
    }
    /**
     * 宠集盒门店会员编号：以当前基数递增
     * @return 合作机构会员编号
     */
    public static synchronized String getCJHMemberCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("hzmember_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("hzmember_code",resultCode);
        return "CJH"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
    }
    
    /**
     * C级认证师证书编号：以当前基数递增
     * @return C级认证师证书编号
     */
    public static synchronized String getAppraiserCertifiedCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("appraiser_certified_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("appraiser_certified_code",resultCode);
        return "E"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000/")
        		+DateUtils.getStringDateFormatter(new Date(),"yy");
    }
    
    /**
     * 国际纯种犬猫认证服务中心会员编号：以当前基数递增
     * @return 合作机构会员编号
     */
    public static synchronized String getCABMemberCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("hzmember_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("hzmember_code",resultCode);
        return "CAB"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
    }
    /**
     * 美容学校会员编号：以当前基数递增
     * @return 美容学校会员编号
     */
    public static synchronized String getMRHZMemberCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("mrhzmember_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("mrhzmember_code",resultCode);
        return "MRHZ"+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000");
    }
    /**
     * 犬舍编号：以当前基数递增
     * @return 犬舍编号
     */
    public static synchronized String getKennelCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("kennel_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("kennel_code",resultCode);
        return resultCode;
    }
    /**
     * 配种证明编号：160623（年月日）2268（会员编号）1（本次提交窝数）
     * @param memberCode 会员号
     * @param batch 窝数
     * @return 配种证明编号
     */
    public static synchronized String getBreedingCertifiedCode(String memberCode,String batch){
        String dateStr = DateUtils.getStringDateFormatter(new Date(),"yyMMdd");
        return dateStr+memberCode+batch;
    }
    /**
     *
     * @Description：按冠军登录类型获取对应登录序号的最大值
     * @author: zhuoHeng
     * @version: 2016年9月20日 下午3:36:04
     */
    public static synchronized String getChampionloginCode(String loginType){

    	String code = sysCodeService.getCode(loginType);
    	String resultCode = "";
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode(loginType,resultCode);

    	String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
    	if("champion_login_cn_code".equals(loginType)){//普通冠军登录
    		return CKUCN+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else if("champion_login_copper_code".equals(loginType)) {//铜制冠军登录
    		return CKUCN+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else if("champion_login_silver_code".equals(loginType)) {//银质冠军登录
    		return CKUCN+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else if("champion_login_gold_code".equals(loginType)) {//金质冠军登录
    		return CKUCN+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else if("champion_login_super_code".equals(loginType)) {//超级冠军登录
    		return CKUCN+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else if("champion_login_yong_code".equals(loginType)) {//青年冠军登录
    		return CKUJH+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else if("champion_login_w_code".equals(loginType)) {//世界冠军登录
    		return INTCH+LINK+yearStr+BLINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	} else {
    		return "";
    	}
    }
    /**
     * 血统证书号：CKU-（固定或者CKUTM等）122（犬种代码）006634（基数递增）/16（年份）
     * @param dogCode 犬种代码
     * @return 血统证书号
     */
    public static synchronized  String getPedigreeCertifiedCode(String dogCode){
        String resultCode = null;
        String code  = sysCodeService.getCode("pedigree_certified_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("pedigree_certified_code",resultCode);
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        String prefix = CKU;
        if ("230".equals(dogCode)) {
            prefix = "CKUTM";
        } else if ("292".equals(dogCode) && System.currentTimeMillis() > duGaoTimeMillis) {
            prefix = "CKUDC";
        } else if ("15C".equals(dogCode)) {
            prefix = "CKUMC";
        }
        return prefix+LINK+dogCode+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000")+BLINK+yearStr;
    }
    /**
     * 淘宠鉴定证书号：CKUJD-（固定或者CKUTM等）122（犬种代码）006634（基数递增）/ 17（年份）
     * @param dogCode 犬种代码
     * @return 淘宠鉴定证书号
     */
    public static synchronized  String getClubPedigreeCertifiedCode(String dogCode){
    	String resultCode = null;
    	String code  = sysCodeService.getCode("club_dog");
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode("club_dog",resultCode);
    	String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
    	String prefix = CKUJD;
    	return prefix+LINK+dogCode+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000")+BLINK+yearStr;
    }
    /**
     * 出生纸编号：000056504（从000001递增的）
     * @return 出生纸编号
     */
    public static synchronized String getBirthCertificateCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("birth_certificate_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("birth_certificate_code",resultCode);
        return SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000000");
    }
    /**
     * DNA样本登记号码：DNA#122（犬种代码）006634（从000001递增的）
     * @return DNA样本登记号码
     */
    public static synchronized String getDnaCode(String dogCode){
    	String resultCode = null;
    	String code = sysCodeService.getCode("dna_code");
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode("dna_code",resultCode);
    	return DNA+dogCode+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"00000");
    }
    /**
     * CKU冷冻精子批次号：JZPC0002017
     * @return CKU冷冻精子编号
     */
    public static synchronized String getSemenBatchCode(){
    	String resultCode = null;
    	String code = sysCodeService.getCode("semen_batch_code");
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode("semen_batch_code",resultCode);
    	return SEMEN_BATCH+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000000");
    }
    /**
     * CKU冷冻精子编号：JZ000002017
     * @return CKU冷冻精子编号
     */
    public static synchronized String getSemenCode(){
    	String resultCode = null;
    	String code = sysCodeService.getCode("semen_code");
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode("semen_code",resultCode);
    	return SEMEN+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000000");
    }

    /**
     *赛事编号：2014（年份）53（今年场次）-廊坊（地点）-3（本场的分场次）
     * @param location 地点
     * @param times 本场的分场次
     * @return 赛事编号
     */
    public static synchronized String getMatchCode(String location,String times){
        String resultCode = null;
        String year = SysCodeUtil.getNowYear();
        String code = sysCodeService.getCode("match_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("match_code",resultCode);
        return year+resultCode+LINK+location+LINK+times;
    }

    /**
     * 中国冠军登录序号：NO.CKU CH./（固定）13（年份）-1270（递增）
     * @return 中国冠军登录序号
     */
    public static synchronized String getChampionLoginCNCode(){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        String code = sysCodeService.getCode("champion_login_cn_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("champion_login_cn_code",resultCode);
        return CKUCN+yearStr+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    }

    /**
     * 世界冠军登录序号：INT.CH-（固定）0042（递增）/12（年份）
     * @return 世界冠军登录序号
     */
    public static synchronized String getChampionLoginWCode(){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        String code = sysCodeService.getCode("champion_login_w_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("champion_login_w_code",resultCode);
        return INTCH+LINK+yearStr+BLINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    }

    /**
     * 美容师结业证书编号：G（代表美容师）-T9（学校名称缩写）-B（等级）-14（年份）0272（递增）
     * @param school 学校名称缩写
     * @param level 等级
     * @return 美容师结业证书编号
     */
    public static synchronized String getGroomerDiplomaCode(String school,String level){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        if ("C".equals(level)) {
        	String code = sysCodeService.getCode("groomer_diploma_code");
        	resultCode = (Long.parseLong(code)+1)+"";
        	sysCodeService.updateCode("groomer_diploma_code",resultCode);
        	return GROOMER+LINK+school+LINK+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
		}else if("B".equals(level)){
			String code = sysCodeService.getCode("groomer_diploma_b");
        	resultCode = (Long.parseLong(code)+1)+"";
        	sysCodeService.updateCode("groomer_diploma_b",resultCode);
        	return GROOMER+LINK+school+LINK+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
		}else{
			String code = sysCodeService.getCode("groomer_diploma_a");
        	resultCode = (Long.parseLong(code)+1)+"";
        	sysCodeService.updateCode("groomer_diploma_a",resultCode);
        	return GROOMER+LINK+school+LINK+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
		}
    }
    /**
     * 美容师资格证书编号：CKU（固定）-GC（学校名称缩写）-2014（考试日期年份）0081（递增）
     * @param level 证书级别
     * @return  美容师资格证书编号
     */
    public static synchronized String getGroomerQualificationCertificateCode(String level,Date take){
        String resultCode = null;
        String yearStr=null;
       if("M".equals(level)){
	        if(take==null){
	        	 yearStr = DateUtils.getStringDateFormatter(new Date(),"yyyy");
	        }else{
	        	 yearStr = DateUtils.getStringDateFormatter(take,"yyyy");
	        }
	        String code = sysCodeService.getCode("groomer_qualification_certificate_code");
	        resultCode = (Long.parseLong(code)+1)+"";
	        sysCodeService.updateCode("groomer_qualification_certificate_code",resultCode);
	        return CKU+LINK+GROOMER+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
       }else{//ABC级别 根据不同年份的不同级别 逐渐自增
    	   if(take==null){
	        	 yearStr = DateUtils.getStringDateFormatter(new Date(),"yyyy");
	        }else{
	        	 yearStr = DateUtils.getStringDateFormatter(take,"yyyy");
	        }
    	   SysCodeGroomer sysCodeGroomer = sysCodeGroomerService.getCode(yearStr,level);
    	   String code = sysCodeGroomer.getCode();
    	   resultCode = (Long.parseLong(code)+1)+"";
    	   sysCodeGroomer.setCode(resultCode);
    	   sysCodeGroomerService.updateCode(sysCodeGroomer);
    	   String certifiedCode = SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    	   return CKU+LINK+GROOMER+level+LINK+yearStr+certifiedCode;
       }
    }
    /**
     * 美容活动编号：2014（年份）10（年度场次）-北京（地点）2（分场次）-JZ（类别：年度赛或者团体赛或者讲座等）
     * @param location 地点
     * @param times 分场次
     * @param type 类别
     * @return 美容活动编号
     */
    public static synchronized String getGroomActivityCode(String location,String times,String type){
        String resultCode = null;
        String year = SysCodeUtil.getNowYear();
        String code = sysCodeService.getCode("groom_activity_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("groom_activity_code",resultCode);
        return year+resultCode+LINK+location+times+LINK+type;
    }
    /**
     * 美容活动报名序号：WB(线上报名) -001（递增）  或者  BM(电话报名)-001（递增）
     * @param type WB(线上报名) BM(电话报名)
     * @return  美容活动报名序号
     */
        public static synchronized String getGroomActivitySignCode(String type){
            String resultCode = null;
            String code = sysCodeService.getCode("groom_activity_sign_code");
            resultCode = (Long.parseLong(code)+1)+"";
            sysCodeService.updateCode("groom_activity_sign_code",resultCode);
            return type+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
        }
    /**
     *  牵犬师结业证书编号：H（牵犬师）- BJTCY（学校名称缩写）-B（等级）-14（年份）0272（递增）
     * @param school 学校名称缩写
     * @param level 等级
     * @return 牵犬师结业证书编号
     */
    public static synchronized String getHandlerDiplomaCode(String school,String level){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        String code = sysCodeService.getCode("handler_diploma_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("handler_diploma_code",resultCode);
        return HANDLER+LINK+school+LINK+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    }
    /**
     *  训犬师结业证书编号：F（训犬师的类别）- BJTCY（学校名称缩写）-B（等级）-14（年份）0272（递增）
     * @param school 学校名称缩写
     * @param level 等级
     * @return 牵犬师结业证书编号
     */
    public static synchronized String getTrainDiplomaCode(String type,String school,String level){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        String code = sysCodeService.getCode("train_diploma_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("train_diploma_code",resultCode);
        return type+LINK+school+LINK+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    }

    /**
     *  精英培训班结业证书编号：H（牵犬师）- CKU（官方）-ETS（精英）-0272（递增）
     * @return 牵犬师结业证书编号
     */
    public static synchronized String getEliteDiplomaCode(){
        String resultCode = null;
        String code = sysCodeService.getCode("elite_diploma_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("elite_diploma_code",resultCode);
        return HANDLER+LINK+CKU+LINK+ELITE+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0");
    }
    /**
     *  牵犬师资格证书编号：CKU（固定）-GC（学校名称缩写）-2014（年份）0081（递增）
     * @param level 级别
     * @return 牵犬师资格证书编号
     */
    public static synchronized String getHandlerQualificationCertificateCode(String level){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yyyy");
        String code = sysCodeService.getCode("handler_qualification_certificate_code");
        System.out.println("--------------证书号  : {}" + code);
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("handler_qualification_certificate_code",resultCode);
        return CKU+LINK+HANDLER+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    }
    /**
     * 牵犬师活动编号：2014（年份）10（年度场次）-北京（地点）2（分场次）
     * @param location 地点
     * @param times 分场次
     * @return 牵犬师活动编号
     */
    public static synchronized String getHandlerActivityCode(String location,String times){
        String resultCode = null;
        String year = SysCodeUtil.getNowYear();
        String code = sysCodeService.getCode("handler_activity_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("handler_activity_code",resultCode);
        return year+resultCode+LINK+location+times;
    }

    /**
     * 美容活动报名序号：WB(线上报名) -001（递增）  或者  BM(电话报名)-001（递增）
     * @param type WB(线上报名) BM(电话报名)
     * @return  美容活动报名序号
     */
    public static synchronized String getHandlerActivitySignCode(String type){
        String resultCode = null;
        String code = sysCodeService.getCode("handler_activity_sign_code");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("handler_activity_sign_code",resultCode);
        return type+LINK+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
    }
    /**
     * 缴费流水号 会员中心
     * @param memberCode 会员号
     * @return 缴费流水号
     */
    public static synchronized  String getPayRunningNumberWithMemberCode(String memberCode){
        String dateStr = DateUtils.getStringDateFormatter(new Date(),"yyMMddHHmmss");
        java.util.Random random=new java.util.Random();// 定义随机类
        int result=random.nextInt(10000);
        return dateStr+stringFormat(result,"0000")+"@"+memberCode;
    }
    /**
     * 缴费流水号 后台生成
     * @return 缴费流水号
     */
    public static synchronized  String getPayRunningNumber(){
        String dateStr = DateUtils.getStringDateFormatter(new Date(),"yyMMddHHmmss");
        java.util.Random random=new java.util.Random();// 定义随机类
        int result=random.nextInt(10000);
        return dateStr+stringFormat(result,"0000");
    }

    /**
     * 繁育证书编号：CKU-F212000001/13
     * @param no 繁育代码
     * @return
     */
    public static synchronized String getBreedCertifiedCode(String no){
        String resultCode = null;
        String code = sysCodeService.getCode("breed_certified_code");
        String yearStr = DateUtils.getStringDateFormatter(new Date(),"yy");
        resultCode = (Long.parseLong(code)+1)+"";
        sysCodeService.updateCode("breed_certified_code",resultCode);
        return "CKU-F"+no+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"000000")+BLINK+yearStr;
    }
    /**
     * 俱乐部赛事鉴定编号：HZ000001+1711+1~99
     * @param no 繁育代码
     * @return
     */
    public static synchronized String getOrgAppraisalCode(String no){
    	String resultCode = null;
    	String code = sysCodeService.getCode("club_match_code");
    	String yearStr = DateUtils.getStringDateFormatter(new Date(),"yyMM");
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode("club_match_code",resultCode);
    	return no+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"00");
    }
    /**
     * 优惠劵编号：YHJ2018041700001
     * @return
     */
    public static synchronized String getCouponCode(){
    	String resultCode = null;
    	String code = sysCodeService.getCode("coupon_code");
    	String yearStr = DateUtils.getStringDateFormatter(new Date(),"yyMM");
    	resultCode = (Long.parseLong(code)+1)+"";
    	sysCodeService.updateCode("coupon_code",resultCode);
    	return COUPON+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"00000");
    }
    /**
     * 格式化字符串补0
     * @param l
     * @param format
     * @return
     */
    public static String stringFormat(long l,String format){
        DecimalFormat df = new DecimalFormat(format);
        return df.format(l);
    }

    /**
     * 得到当前年，如果过一年则更新按年递增的字段
     * @return
     */
    public static synchronized String getNowYear(){
        String year = sysCodeService.getCode("year");
        String nowYear = DateUtils.getStringDateFormatter(new Date(),"yyyy");
        if(!nowYear.equals(year)){
            year = nowYear;
            sysCodeService.updateCode("year",nowYear);
            for(String col : yearColumn){
            	sysCodeService.updateCode(col,"0");
            }
        }
      return year;
    }

    /**
     * 犬运动会员号
     * @author yuanshuai
     * @date 2021/6/21 14:52
     */
	public static synchronized String getCDSCMemberCode() {
		String code = sysCodeService.getCode("cdsc_member_code");
		sysCodeService.updateCode("cdsc_member_code", String.valueOf(Long.parseLong(code) + 1));
		return CDSC +SysCodeUtil.stringFormat(Long.parseLong(code)+1,"00000");
	}
	/**
	 * 犬运动犬只证书号
	 * @author yuanshuai
	 * @date 2021/6/21 14:52
	 */
	public static synchronized String getCDSCDogCertificateCode() {
		String code = sysCodeService.getCode("cdsc_dog_certificate_code");
		sysCodeService.updateCode("cdsc_dog_certificate_code", String.valueOf(Long.parseLong(code) + 1));
		String yearStr = DateUtils.getStringDateFormatter(new Date(), "yy");
		String dayStr = DateUtils.getStringDateFormatter(new Date(), "MMdd");
		return CDSC + dayStr + SysCodeUtil.stringFormat(Long.parseLong(code) + 1, "0000") + BLINK + yearStr;
	}

	/**
	 * 鉴赏课程证书
	 * @author yuanshuai
	 * @date 2022/3/2 16:25
	 */
	public static String getAppreciationCertificateCode() {
		String code = sysCodeService.getCode("appreciation_certificate_code");
		sysCodeService.updateCode("appreciation_certificate_code", String.valueOf(Long.parseLong(code) + 1));
		String yearStr = DateUtils.getStringDateFormatter(new Date(), "yyyy");
		return JS + yearStr + SysCodeUtil.stringFormat(Long.parseLong(code) + 1, "0000");
	}

    /**
     * 派多格CKU国际美容师资格认证书编号：PDG（固定）-GC（学校名称缩写）-2024（考试日期年份）0000（递增）
     * @param level 证书级别
     * @return  美容师资格证书编号
     */
    public static synchronized String getPDGGroomerQualificationCertificateCode(String level,Date take){
        String resultCode = null;
        String yearStr = null;
        /*if("M".equals(level)){
            if(take==null){
                yearStr = DateUtils.getStringDateFormatter(new Date(),"yyyy");
            }else{
                yearStr = DateUtils.getStringDateFormatter(take,"yyyy");
            }
            String code = sysCodeService.getCode("groomer_qualification_certificate_code");
            resultCode = (Long.parseLong(code)+1)+"";
            sysCodeService.updateCode("groomer_qualification_certificate_code",resultCode);
            return CKU+LINK+GROOMER+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
        }else{*///ABC级别 根据不同年份的不同级别 逐渐自增
        if (Objects.isNull(take)) {
            yearStr = DateUtils.getStringDateFormatter(new Date(), "yyyy");
        } else {
            yearStr = DateUtils.getStringDateFormatter(take, "yyyy");
        }
        //因美容资格证书已存在ABC级，则派多格增加前缀PDG-ABC
        String queryLevel = PDG + LINK + level;
        SysCodeGroomer sysCodeGroomer = sysCodeGroomerService.getCode(yearStr, queryLevel);
        String code = sysCodeGroomer.getCode();
        resultCode = (Long.parseLong(code) + 1) + "";
        sysCodeGroomer.setCode(resultCode);
        sysCodeGroomerService.updateCode(sysCodeGroomer);
        String certifiedCode = SysCodeUtil.stringFormat(Long.parseLong(code) + 1, "0000");
        return PDG + LINK + GROOMER + level + LINK + yearStr + certifiedCode;
    }

    /**
     * Fci资格认证书编号：PDG（固定）-GC（学校名称缩写）-2024（考试日期年份）0000（递增）
     * @param level 证书级别
     * @return  美容师资格证书编号
     */
    public static synchronized String getFciGroomerQualificationCertificateCode(String level,Date take){
        String resultCode = null;
        String yearStr = null;
        /*if("M".equals(level)){
            if(take==null){
                yearStr = DateUtils.getStringDateFormatter(new Date(),"yyyy");
            }else{
                yearStr = DateUtils.getStringDateFormatter(take,"yyyy");
            }
            String code = sysCodeService.getCode("groomer_qualification_certificate_code");
            resultCode = (Long.parseLong(code)+1)+"";
            sysCodeService.updateCode("groomer_qualification_certificate_code",resultCode);
            return CKU+LINK+GROOMER+level+LINK+yearStr+SysCodeUtil.stringFormat(Long.parseLong(code)+1,"0000");
        }else{*///ABC级别 根据不同年份的不同级别 逐渐自增
        if (Objects.isNull(take)) {
            yearStr = DateUtils.getStringDateFormatter(new Date(), "yyyy");
        } else {
            yearStr = DateUtils.getStringDateFormatter(take, "yyyy");
        }
        //因美容资格证书已存在ABC级，则派多格增加前缀PDG-ABC
        String queryLevel = PDG + LINK + level;
        SysCodeGroomer sysCodeGroomer = sysCodeGroomerService.getCode(yearStr, queryLevel);
        String code = sysCodeGroomer.getCode();
        resultCode = (Long.parseLong(code) + 1) + "";
        sysCodeGroomer.setCode(resultCode);
        sysCodeGroomerService.updateCode(sysCodeGroomer);
        String certifiedCode = SysCodeUtil.stringFormat(Long.parseLong(code) + 1, "0000");
        return PDG + LINK + GROOMER + level + LINK + yearStr + certifiedCode;
    }
    /*}*/


    /**
     *  牵犬师资格证书编号：CKU（固定）-GC（学校名称缩写）-2014（年份）0081（递增）
     * @param level 级别
     * @return 牵犬师资格证书编号
     */
    public static synchronized String getTrainerDogHandlerQualificationCertificateCode(String level){
        String resultCode = null;
        String yearStr = DateUtils.getStringDateFormatter(new Date(), "yyyy");
        String code = sysCodeService.getCode("handler_qualification_certificate_partner_dog_code");
        System.out.println("--------------证书号  : {}" + code);
        resultCode = (Long.parseLong(code) + 1) + "";
        sysCodeService.updateCode("handler_qualification_certificate_partner_dog_code", resultCode);
        return CKU + LINK + TRAINER + level + LINK + yearStr + SysCodeUtil.stringFormat(Long.parseLong(code) + 1, "0000");
    }

}