package com.cku.oa.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.show.entity.ShowOffice;
import com.cku.oa.show.service.ShowOfficeService;

/**
 * 犬展办公室Controller
 *
 * @author 赖广龙
 * @version 2017-08-03
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showOffice")
public class ShowOfficeController extends BaseController {

    @Autowired
    private ShowOfficeService showOfficeService;

    @ModelAttribute
    public ShowOffice get(@RequestParam(required = false) String id) {
        ShowOffice entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = showOfficeService.get(id);
        }
        if (entity == null) {
            entity = new ShowOffice();
        }
        return entity;
    }

    @RequiresPermissions("show:showOffice:view")
    @RequestMapping(value = {"list", ""})
    public String list(ShowOffice showOffice, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<ShowOffice> page = showOfficeService.findPage(new Page<ShowOffice>(request, response), showOffice);
        model.addAttribute("page", page);
        return "oa/show/office/showOfficeList";
    }

    @RequiresPermissions("show:showOffice:view")
    @RequestMapping(value = "form")
    public String form(ShowOffice showOffice, Model model) {
        model.addAttribute("showOffice", showOffice);
        return "oa/show/office/showOfficeForm";
    }

    @RequiresPermissions("show:showOffice:edit")
    @RequestMapping(value = "save")
    public String save(ShowOffice showOffice, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, showOffice)) {
            return form(showOffice, model);
        }
        try {
            if (StringUtils.isBlank(showOffice.getId())) {
                if (!SecurityUtils.getSubject().isPermitted("show:showOffice:add")) {
                    throw new ZAException(ZAErrorCode.ZA_ERROR, "无添加犬展办公室权限。");
                } else {
                    addMessage(redirectAttributes, "添加犬展办公室成功");
                }
            } else {
                addMessage(redirectAttributes, "修改犬展办公室成功");
            }
            showOfficeService.save(showOffice);
        } catch (Exception e) {
            addMessage(redirectAttributes, "添加犬展办公室失败：" + e.getMessage());
        }
        return "redirect:" + Global.getAdminPath() + "/show/showOffice/?repage";
    }

    @RequiresPermissions("show:showOffice:del")
    @RequestMapping(value = "delete")
    public String delete(ShowOffice showOffice, RedirectAttributes redirectAttributes) {
        showOfficeService.delete(showOffice);
        addMessage(redirectAttributes, "删除犬展办公室成功");
        return "redirect:" + Global.getAdminPath() + "/show/showOffice/?repage";
    }

}