/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事裁判关联信息表Entity
 * @author xx
 * @version 2021-08-06
 */
public class ShowMainJudgeInfo extends DataEntity<ShowMainJudgeInfo> {
	
	private static final long serialVersionUID = 1L;
	private String showMainId;		// 主赛事主键
	private String showJudgeId;		// 裁判主键
	private String showJudgePicture;		// 赛事裁判关联图片
	
	
	private String judgeName;		
	
	
	public String getJudgeName() {
		return judgeName;
	}

	public void setJudgeName(String judgeName) {
		this.judgeName = judgeName;
	}

	public ShowMainJudgeInfo() {
		super();
	}

	public ShowMainJudgeInfo(String id){
		super(id);
	}

	@Length(min=0, max=64, message="主赛事主键长度必须介于 0 和 64 之间")
	public String getShowMainId() {
		return showMainId;
	}

	public void setShowMainId(String showMainId) {
		this.showMainId = showMainId;
	}
	
	@Length(min=0, max=64, message="裁判主键长度必须介于 0 和 64 之间")
	public String getShowJudgeId() {
		return showJudgeId;
	}

	public void setShowJudgeId(String showJudgeId) {
		this.showJudgeId = showJudgeId;
	}
	
	@Length(min=0, max=50, message="赛事裁判关联图片长度必须介于 0 和 50 之间")
	public String getShowJudgePicture() {
		return showJudgePicture;
	}

	public void setShowJudgePicture(String showJudgePicture) {
		this.showJudgePicture = showJudgePicture;
	}
	
}