package com.cku.oa.sampling.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 采样包犬只来源（0血统证书号，1出生纸编号，2国外证书号）
 */
public enum SamplingDogSourceTypeEnum implements IEnum<Integer> {

	PEDIGREE_CERTIFIED(0, "血统证书号"),
	BIRTH_CODE(1, "出生纸编号"),
	OVERSEAS_PEDIGREE_CERTIFIED(2, "国外证书号");

	private Integer code;

	private String message;

	SamplingDogSourceTypeEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
