/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.nativedog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 原生犬新闻Entity
 * @author lyy
 * @version 2018-12-11
 */
public class NativeDogNews extends DataEntity<NativeDogNews> {
	
	private static final long serialVersionUID = 1L;
	private String title;		// 标题
	private String author;		// 作者
	private String newsDetail;		// 新闻更多信息
	
	public NativeDogNews() {
		super();
	}

	public NativeDogNews(String id){
		super(id);
	}

	@Length(min=0, max=50, message="标题长度必须介于 0 和 50 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}
	
	public String getNewsDetail() {
		return newsDetail;
	}

	public void setNewsDetail(String newsDetail) {
		this.newsDetail = newsDetail;
	}
	
}