package com.cku.oa.kennel.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelRename;
import com.cku.oa.kennel.service.KennelRenameService;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.kennel.vo.KennelRenameVO;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬舍名称变更Controller
 * 
 * @author zhuguanjin
 * @version 2016-08-15
 */
@Controller
@RequestMapping(value = "${adminPath}/kennel/kennelRename")
public class KennelRenameController extends BaseController {

	@Autowired
	private KennelRenameService kennelRenameService;
	@Autowired
	private KennelService kennelService;

	@ModelAttribute
	public KennelRename get(@RequestParam(required = false) String id) {
		KennelRename entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = kennelRenameService.get(id);
		}
		if (entity == null) {
			entity = new KennelRename();
		}
		return entity;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions("kennel:kennelRename:view")
	@RequestMapping(value = { "list", "" })
	public String list(KennelRename kennelRename, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<KennelRename> page = kennelRenameService.findPage(new Page<KennelRename>(request, response), kennelRename);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<KennelRename> list = page.getList().stream().map(a -> {
			KennelRenameVO b = new KennelRenameVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		return "oa/kennel/kennelRenameList";
	}

	@RequiresPermissions("kennel:kennelRename:view")
	@RequestMapping(value = "form")
	public String form(KennelRename kennelRename, Model model) {
		model.addAttribute("kennelRename", kennelRename);
		return "oa/kennel/kennelRenameForm";
	}

	@RequiresPermissions("kennel:kennelRename:audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		model.addAttribute("kennelRename", kennelRenameService.get(id));
		return "oa/kennel/kennelRenameAuditForm";
	}

	@RequiresPermissions("kennel:kennelRename:audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(KennelRename kennelRename) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			kennelRenameService.audit(kennelRename);
		} catch (Exception e) {
			logger.warn("审核失败", e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions("kennel:kennelRename:edit")
	@RequestMapping(value = "save")
	public String save(KennelRename kennelRename, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, kennelRename)) {
			return form(kennelRename, model);
		}
		kennelRenameService.save(kennelRename);
		addMessage(redirectAttributes, "保存犬舍名称变更成功");
		return "redirect:" + Global.getAdminPath() + "/kennel/kennelRename/?repage";
	}

	@RequiresPermissions("kennel:kennelRename:edit")
	@RequestMapping(value = "delete")
	public String delete(KennelRename kennelRename, RedirectAttributes redirectAttributes) {
		kennelRenameService.delete(kennelRename);
		addMessage(redirectAttributes, "删除犬舍名称变更成功");
		return "redirect:" + Global.getAdminPath() + "/kennel/kennelRename/?repage";
	}

	@RequiresPermissions("kennel:kennelRename:resolve")
	@RequestMapping(value = "resolve")
	public String resolve(KennelRename kennelRename, RedirectAttributes redirectAttributes) {
		try {
			kennelRenameService.resolve(kennelRename);
		} catch (Exception e) {
			logger.warn("处理犬舍名称变更失败：", e);
			addMessage(redirectAttributes, "处理犬舍名称变更失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/kennel/kennelRename/?repage";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		KennelRename kennelRename = new KennelRename(runningNumber, chargingItemId, memberCode);
		Kennel kennel = kennelService.getKennelByMemberCode(kennelRename.getPaymentMemberCode());
		kennelRename.setKennelCode(kennel.getKennelCode());
		kennelRename.setOriginalNameCn(kennel.getName());
		kennelRename.setOriginalNameEn(kennel.getNameEn());
		kennelRename.setMemberCode(kennelRename.getPaymentMemberCode());
		Member member = new Member();
		member.setName(kennel.getMember().getName());
		member.setMemberType(kennel.getMember().getMemberType());
		member.setMemberEndDate(kennel.getMember().getMemberEndDate());
		kennelRename.setMember(member);
		model.addAttribute("kennelRename", kennelRename);
		return "oa/kennel/KennelRenameOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public Object orderSave(KennelRename kennelRename, Model model) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			kennelRenameService.orderSave(kennelRename);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(KennelRename kennelRename, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<KennelRename> page = kennelRenameService.findPage(new Page<KennelRename>(request, response), kennelRename);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<KennelRename> list = page.getList().stream().map(a -> {
			KennelRenameVO b = new KennelRenameVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		return "oa/kennel/KennelRenameOrderList";
	}
}