/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.kennel.entity.KennelOwnerChange;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬舍所有人变更DAO接口
 * 
 * @author zhuguanjin
 * @version 2016-08-23
 */
@MyBatisDao
public interface KennelOwnerChangeDao extends CrudDao<KennelOwnerChange> {

	// 首页--犬舍所有人变更提醒
	int getOwnerChangeCount();

	List<KennelOwnerChange> getOriginApplyingChangeList(@Param("memberCode") String memberCode);
	
	List<KennelOwnerChange> getNewApplyingChangeList(@Param("memberCode") String memberCode);

}